<?php

/*
   WOT: Image Buttons plugin (GPL v2)
   WEN: Mon Sep  1 21:58:59 MDT 2003
   WHY: To display image links rather than text links on the top menu bar
   WHO: Brad Donison <bucovina@users.sourceforge.net> and contributors
*/

if (defined('SM_PATH')) {
    include_once(SM_PATH . 'functions/options.php');
    include_once(SM_PATH . 'plugins/image_buttons/config.php');
    include_once(SM_PATH . 'functions/i18n.php');
} else {
    include_once('../functions/options.php');
    include_once('../plugins/image_buttons/config.php');
    include_once('../functions/i18n.php');
}

function image_buttons_do ($args) {
    global $username, $data_dir, $image_buttons_type, $image_buttons_select,
           $image_buttons_img, $image_buttons_size, $image_buttons_cache,
           $image_buttons_verticle, $image_buttons_sitetype, $image_buttons_sitesize,
           $image_buttons_sitecache, $image_buttons_siteverticle, $image_buttons_width,
           $image_buttons_height, $REQUEST_URI, $color, $javascript_on;

    if ($image_buttons_select == 0) {
        $image_buttons_type = $image_buttons_sitetype;
        $image_buttons_size = $image_buttons_sitesize;
        $image_buttons_cache = $image_buttons_sitecache;
        $image_buttons_verticle = $image_buttons_siteverticle;
    }

    if ((!isset($GLOBALS['image_buttons_type'])) ||
        ($GLOBALS['image_buttons_type'] == '') ||
        ($GLOBALS['image_buttons_type'] == 'plain')) {
        if (is_array($args)) {
            return $args[0];
        } else {
            return $args;
        }
    }

    if (is_array($args)) {
        $mypath = $args[1];
    } else {
        $mypath = $REQUEST_URI;
    }
    $linktext = 0;
    if (!stristr($mypath, 'passed_id=')) {
        if (stristr($mypath, 'compose.php')) {
            if (stristr($mypath, 'compose.php?mailbox=')) {
                $linktext = 1;
            }
        } else {
            $linktext = 1;
        }
    }

    if ($linktext > 0) {
        sqgetGlobalVar('base_uri', $base_uri, SQ_SESSION);
        if (is_array($args)) {
            $text = $args[0];
            $path = preg_replace("/\?.*$/", '', $args[1]);
        } else {
            $text = $args;
            $path = '';
        }

        $iconfile = '';
        if (($GLOBALS['image_buttons_type'] == 'icons') ||
            ($GLOBALS['image_buttons_type'] == 'texticons')) {
            $iconslot = preg_replace("/^.*\//", '', $path);
            if (isset($image_buttons_img["$iconslot"])) {
               $img_filename = $image_buttons_img["$iconslot"];
               if ($img_filename != '') {
                   $iconfile = $img_filename;
               }
            }
        }

        if (($iconfile != '') &&
            (!file_exists(SM_PATH . 'plugins/image_buttons/images/' . $iconfile))) {
            $iconfile = '';
        }
        if ($iconfile != '') {
            $iburl = $base_uri . 'plugins/image_buttons/images/' . $iconfile;
            $button = '<img src="' . $iburl . '" border="0" alt="' . $text .
                      '" title="' . $text . '"';
            if ($image_buttons_height > 0) {
                $button .= ' height="' . $image_buttons_height . '"';
            }
            if ($image_buttons_width > 0) {
                $button .= ' width="' . $image_buttons_width . '"';
            }
            $button .= '>';
        } else {
            $iburl = $base_uri . 'plugins/image_buttons/create_button.php';
            $button = '<img src="' . $iburl . '?button_text=' . $text .
                      '&button_link=' . $path .
                      '" border="0" alt="' . $text . '"' . ' title="' . $text . '">';
        }
        if (($GLOBALS['image_buttons_type'] == 'texticons') &&
            ($iconfile != '')) {
            if ($GLOBALS['image_buttons_size'] == 'small') {
                $newtext = "<font size=2>$text</font>";
            } elseif ($GLOBALS['image_buttons_size'] == 'medium') {
                $newtext = "<font size=3>$text</font>";
            } elseif ($GLOBALS['image_buttons_size'] == 'large') {
                $newtext = "<font size=4>$text</font>";
            } else {
                $newtext = $text;
            }
            
            if (isset($image_buttons_verticle) &&
                ($image_buttons_verticle == 'textbelow') &&
                ! preg_match('/Opera/', $_SERVER["HTTP_USER_AGENT"]) &&
                (($javascript_on == 1) ||
                 (! preg_match('/^Mozilla.4.0 .compatible; MSIE/', $_SERVER["HTTP_USER_AGENT"])))) {
                $myBRTag = '<br>';
            } else {
                $myBRTag = '';
            }

            //TODO: Find out what to do if RightToLeft is standard...
            if (isset($GLOBALS['languages']['DIR']) &&
                $GLOBALS['languages']['DIR'] == 'rtl') {
                if (!isset($image_buttons_verticle) ||
                    $image_buttons_verticle == 'textafter') {
                    return "<table><tr><td>$button</td></tr><tr><td>" .
                           "$newtext</td></tr></table>";
                } else {
                    return "$newtext$button";
                }
            }
            
            //To avoid trouble whith javascript link.
            if (stristr($path, 'compose.php') &&
                (getPref($data_dir, $username, 'compose_new_win') == 1))  {
              if (preg_match('/Opera/', $_SERVER["HTTP_USER_AGENT"])) {
                // Opera table displays don't work
                return "$button$myBRTag$newtext";
              } elseif ($javascript_on) {
                return "<table style=\"display:inline;\"><tr><td style=\"".
                       "text-align:center;position:relative;cursor:hand;" .
                       "border:1px;padding:1px;\" onmouseover=\"" .
                       "javascript:this.style.backgroundColor='$color[9]';" .
                       "this.style.border='1px solid $color[8]';" .
                       "this.style.padding='1px';\" onmouseout=\"javascript:" .
                       "this.style.backgroundColor='$color[4]';" .
                       "this.style.border='1px';this.style.padding='1px';\">" .
                       "$button$myBRTag$newtext</td></tr></table>";  
              } elseif (! preg_match('/^Mozilla.4.0 .compatible; MSIE/', $_SERVER["HTTP_USER_AGENT"])) {
                return "<table style=\"display:inline;\"><tr><td style=\"".
                       "text-align:center;position:relative;cursor:hand;" .
                       "border:0px;padding:3px;\">" .
                       "$button$myBRTag$newtext</td></tr></table>";  
              } else {
                // IE doesn't work unless JavaScripting is enabled
                return "$button$myBRTag$newtext";
              }
            } elseif (stristr($path, 'signout.php')) {
              if (preg_match('/Opera/', $_SERVER["HTTP_USER_AGENT"])) {
                // Opera table displays don't work
                return "$button$myBRTag$newtext";
              } elseif ($javascript_on) {
                return "<table style=\"display:inline;\"><tr><td style=\"" .
                       "text-align:center;cursor:hand;border:1px;padding:1px;\" " .
                       "onclick=\"top.location='$base_uri$args[1]';\" " .
                       "onmouseover=\"javascript:this.style.backgroundColor='" .
                       "$color[9]';this.style.border='1px solid $color[8]';" .
                       "this.style.padding='1px';\" onmouseout=\"javascript:" .
                       "this.style.backgroundColor='$color[4]';" .
                       "this.style.border='1px';this.style.padding='1px';\">" .
                       "$button$myBRTag$newtext</td></tr></table>";  
              } elseif (! preg_match('/^Mozilla.4.0 .compatible; MSIE/', $_SERVER["HTTP_USER_AGENT"])) {
                return "<table style=\"display:inline;\"><tr><td style=\"" .
                       "text-align:center;cursor:hand;border:1px;padding:1px;\">" .
                       "$button$myBRTag$newtext</td></tr></table>";
              } else {
                // IE doesn't work unless JavaScripting is enabled
                return "$button$myBRTag$newtext";
              }
            } else  {
                //These are the normal menus.
              if (preg_match('/Opera/', $_SERVER["HTTP_USER_AGENT"])) {
                // Opera table displays don't work
                return "$button$myBRTag$newtext";
              } elseif ($javascript_on) {
                return "<table style=\"display:inline;\"><tr><td style=\"" .
                       "text-align:center;cursor:hand;border:1px;padding:1px;\" " .
                       "onclick=\"document.location='$base_uri$args[1]';\" " .
                       "onmouseover=\"javascript:this.style.backgroundColor='" .
                       "$color[9]';this.style.border='1px solid $color[8]';" .
                       "this.style.padding='1px';\" onmouseout=\"javascript:" .
                       "this.style.backgroundColor='$color[4]';" .
                       "this.style.border='1px';this.style.padding='1px';\">" .
                       "$button$myBRTag$newtext</td></tr></table>";  
              } elseif (! preg_match('/^Mozilla.4.0 .compatible; MSIE/', $_SERVER["HTTP_USER_AGENT"])) {
                return "<table style=\"display:inline;\"><tr><td style=\"" .
                       "text-align:center;cursor:hand;border:1px;padding:1px;\">" .
                       "$button$myBRTag$newtext</td></tr></table>";
              } else {
                // IE doesn't work unless JavaScripting is enabled
                return "$button$myBRTag$newtext";
              }
            }
        } else {
          return "$button";
        }
    } else {
        if (is_array($args)) {
            return $args[0];
        } else {
            return $args;
        }
    }
}

/**
 * Register optpage_data for display options page.
 */
function image_buttons_loadhook_display_do() {
    global $optpage_data, $image_buttons_cacheoption, $javascript_on;
    global $image_buttons_type;

    bindtextdomain('image_buttons', SM_PATH . 'plugins/image_buttons/locale');
    textdomain('image_buttons');

    $optpage_data['grps']['image_buttons'] = _("Graphical Menu Bar");
    $optionValues = array();

    // select image_buttons type
    $optionValues[] = array(
        'name'    => 'image_buttons_type',
        'caption' => _("Type of Images"),
        'type'    => SMOPT_TYPE_STRLIST,
        'refresh' => SMOPT_REFRESH_ALL,
        'posvals' => array('plain'     => _("None (text only)"),
                           'icons'     => _("Icons"),
                           'texticons' => _("Icons with Text"),
                           'buttons'   => _("Buttons")),
        );

    // Centers the text below the icons. Depends on JavaScript if running IE
    if (($javascript_on == 1) ||
        (! preg_match('/^Mozilla.4.0 .compatible; MSIE/', $_SERVER["HTTP_USER_AGENT"]))) {
        $optionValues[] = array(
            'name'    => 'image_buttons_verticle',
            'caption' => _("Text alignment for <b>Icons with Text</b>"),
            'type'    => SMOPT_TYPE_STRLIST,
            'refresh' => SMOPT_REFRESH_ALL,
            'posvals' => array('textafter' => _("After icon"),
                               'textbelow' => _("Below icon"))
            );
    }

    $optionValues[] = array(
        'name'    => 'image_buttons_size',
        'caption' => _("Text Size"),
        'type'    => SMOPT_TYPE_STRLIST,
        'refresh' => SMOPT_REFRESH_ALL,
        'posvals' => array('theme'  => _("Default"),
                           'small'  => _("Small"),
                           'medium' => _("Medium"),
                           'large'  => _("Large"))
        );

    if ($image_buttons_cacheoption > 0) {
        $optionValues[] = array(
            'name'    => 'image_buttons_cache',
            'caption' =>  _("Cache Buttons locally"),
            'type'    => SMOPT_TYPE_BOOLEAN,
            'refresh' => SMOPT_REFRESH_ALL
            );
    }

    $optpage_data['vals']['image_buttons'] = $optionValues;
    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
}

function image_buttons_prefs() {
    global $username, $data_dir, $image_buttons_type, $image_buttons_size,
           $image_buttons_cache, $image_buttons_verticle;

    $image_buttons_type = getPref($data_dir, $username, 'image_buttons_type');
    $image_buttons_size = getPref($data_dir, $username, 'image_buttons_size');
    $image_buttons_cache = getPref($data_dir, $username, 'image_buttons_cache');
    $image_buttons_verticle = getPref($data_dir, $username, 'image_buttons_verticle');
}
?>
