<?php


   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');




/** 
  * Inserts controls on the compose page that let the user
  * switch between HTML and text on the fly.
  *
  */
function html_mail_choose_type_on_the_fly()
{

   if (html_area_is_on_and_is_supported_by_users_browser())
   {
      bindtextdomain('html_mail', SM_PATH . 'locale');
      textdomain('html_mail');

      echo '<input type="radio" name="strip_html_send_plain" id="strip_html_send_plain_html" CHECKED value="0" /><label for="strip_html_send_plain_html">' . _("HTML")
         . '</label><input type="radio" onClick="if (!confirm(\'' . _("Warning: all special formatting will be lost.  Are you sure you want to send your message in plain text format?") . '\')) document.compose.strip_html_send_plain[0].checked = true;" name="strip_html_send_plain" id="strip_html_send_plain_plain" value="1" /><label for="strip_html_send_plain_plain">' . _("Plain Text") . '</label>';

      bindtextdomain ('squirrelmail', SM_PATH . 'locale');
      textdomain ('squirrelmail');
   }

}


/**
  * "Turns on" this plugin if the compose page is currently
  * being shown
  *
  */
function html_mail_header_do()
{

   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4,1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }

   if (stristr($_SERVER['SCRIPT_NAME'], 'compose.php'))
      html_mail_turn_on_htmlarea();

}


/** 
  * Do the actual insertion of the enhanced text editor
  *
  * Also check that this plugin is in the correct order in $plugins array
  *
  */
function html_mail_turn_on_htmlarea() 
{

   global $plugins, $color, $customStyle, $use_spell_checker, 
          $editor_style, $fully_loaded;


   // list of plugins that should come BEFORE this plugin (any that will
   // modify outgoing messages on the compose_send hook)
   //
   $check_for_previous_plugins = array(
      'gpg',    // is this one necessary?  oh well, no reason we can't play it safe
      'hancock', 
      'taglines',
      'quote_tools',
      'email_footer',
// nope... does not add after sending; adds using compose_form hook:      'sigtag',
   );


   // now just make sure html_mail comes after all those plugins listed above
   //
   $my_plugin_index = array_search('html_mail', $plugins);
   foreach ($check_for_previous_plugins as $plug)
   {
      $i = array_search($plug, $plugins);
      if (is_numeric($i) && $i > $my_plugin_index) // array_search returns NULL before PHP 4.2.0, FALSE after that
      {
         bindtextdomain('html_mail', SM_PATH . 'locale');
         textdomain('html_mail');

         echo "\n\n<html><body><h2><font color='red'>" 
            . sprintf(_("FATAL: HTML_Mail plugin must come AFTER %s in plugins array.  Please modify plugin order using conf.pl or by editing config/config.php"), $plug)
            . '</font></h2></body></html>';
         exit;
      }

   }


   include_once (SM_PATH . 'plugins/html_mail/config.php');


   // turn it on if supported/turned on
   //
   if (html_area_is_on_and_is_supported_by_users_browser())
   {

   // FCKeditor
   //
   if ($editor_style == 1)
   {

      echo '<script type="text/javascript" src="' . SM_PATH . 'plugins/html_mail/fckeditor/fckeditor.js"></script>';

   }


   // HTMLArea editor
   //
   else if ($editor_style == 2)
   {

      global $squirrelmail_language;
      $htmlarea_language = substr($squirrelmail_language, 0, strpos($squirrelmail_language, '_'));
      if (!file_exists(SM_PATH . 'plugins/html_mail/htmlarea/lang/' . $htmlarea_language . '.js'))
         $htmlarea_language = 'en';

      echo '<script language="javascript" type="text/javascript">' 
         . "\n<!--\n"
         . 'var _editor_url = "' . SM_PATH . 'plugins/html_mail/htmlarea/";' . "\n"
         . 'var _editor_lang = "' . $htmlarea_language . '";' 
         . "\n// -->\n</script>\n"
         . '<script type="text/javascript" src="' . SM_PATH . 'plugins/html_mail/htmlarea/htmlarea.js"></script>'
         . '<script language="javascript" type="text/javascript">' 
         . "\n<!--\n";


      if ($use_spell_checker)
      {
         echo 'HTMLArea.loadPlugin("SpellChecker");';
      }

      if ($fully_loaded)
      {
         echo 'HTMLArea.loadPlugin("TableOperations");';
         echo 'HTMLArea.loadPlugin("FullPage");';
         echo 'HTMLArea.loadPlugin("CSS");';
         echo 'HTMLArea.loadPlugin("ContextMenu");';
         //echo 'HTMLArea.loadPlugin("HtmlTidy");';
         echo 'HTMLArea.loadPlugin("ListType");';
         echo 'HTMLArea.loadPlugin("CharacterMap");';
         echo 'HTMLArea.loadPlugin("DynamicCSS");';
      }


      ?>

         var editor = null;
         function initEditor() 
         {

            var config = new HTMLArea.Config();

            //=================================================
            // any other editor customizations here...
            //=================================================
            <?php 
               if (!empty($customStyle)) 
                  echo 'config.pageStyle = "' . $customStyle . '";';
            ?>



// NOTE: ideally, this requires change to src/compose.php --> textarea needs an "id" (this should be in SM 1.4.2)
//       attribute called "body", but this will work in most cases without it
            editor = new HTMLArea("body", config);
// without CSS:
//            editor = new HTMLArea("body");


      <?php if ($use_spell_checker) { ?>

            // register the SpellChecker plugin
            //
            editor.registerPlugin("SpellChecker");

      <?php } ?>

      <?php if ($fully_loaded) { ?>

            // register other plugins
            //
            editor.registerPlugin("TableOperations");
            editor.registerPlugin("FullPage");
            editor.registerPlugin("CSS", {
    combos : [
      { label: "Syntax:",
                   // menu text       // CSS class
        options: { "None"           : "",
                   "Code" : "code",
                   "String" : "string",
                   "Comment" : "comment",
                   "Variable name" : "variable-name",
                   "Type" : "type",
                   "Reference" : "reference",
                   "Preprocessor" : "preprocessor",
                   "Keyword" : "keyword",
                   "Function name" : "function-name",
                   "Html tag" : "html-tag",
                   "Html italic" : "html-helper-italic",
                   "Warning" : "warning",
                   "Html bold" : "html-helper-bold"
                 },
        context: "pre"
      },
      { label: "Info:",
        options: { "None"           : "",
                   "Quote"          : "quote",
                   "Highlight"      : "highlight",
                   "Deprecated"     : "deprecated"
                 }
      }
    ]
  });
            editor.config.pageStyle = "@import url(custom.css);";

            editor.registerPlugin("ContextMenu");
            //editor.registerPlugin("HtmlTidy");
            editor.registerPlugin("ListType");
            //editor.registerPlugin("CharacterMap");
            editor.registerPlugin("DynamicCSS");

      <?php } ?>

            editor.generate();
            return false;

         }

         HTMLArea.onload = initEditor;

         //-->
         </script>

      <?php


   }  // End Added For htmlarea

   }

}



/**
  * Inserts extra JavaScript at bottom of compose page
  * that is needed by the enhanced editor
  *
  */
function html_mail_footer() 
{

   global $editor_style;
   include_once (SM_PATH . 'plugins/html_mail/config.php');


   // insert javascript that actually replaces the text area, but only if supported/turned on
   //
   if (html_area_is_on_and_is_supported_by_users_browser())
   {

      // replace newlines with <br>'s in body
      // (comment out these three lines if you 
      // want to do this in html_mail_disable_squirrelspell_do()
      // and miss automated signatures)
      //
      echo '<script language="javascript" type="text/javascript">' . "\n<!--\n"
         . 'document.compose.body.value = document.compose.body.value.replace(/\n/g, "<br />");'
         . "\n// -->\n</script>";


   // FCKeditor
   //
   if ($editor_style == 1)
   {

      global $squirrelmail_language;
      $fckeditor_language = substr($squirrelmail_language, 0, strpos($squirrelmail_language, '_'));
      if (!file_exists(SM_PATH . 'plugins/html_mail/fckeditor/editor/lang/' . $fckeditor_language . '.js'))
         $fckeditor_language = 'en';

      echo '<script DEFER language="javascript" type="text/javascript">'
         . "\n<!--\n"
         . 'var oFCKeditor = new FCKeditor( "body" );'
         . 'oFCKeditor.BasePath	= "' . SM_PATH . 'plugins/html_mail/fckeditor/";'
         . 'oFCKeditor.Config["AutoDetectLanguage"] = false;'
         . 'oFCKeditor.Config["DefaultLanguage"] = "' . $fckeditor_language . '";';


      // set right spell checker
      //
      global $fck_spell_checker;
      if ($fck_spell_checker == 1) 
         echo 'oFCKeditor.Config["SpellChecker"] = "SpellerPages";';
      else if ($fck_spell_checker == 2) 
         echo 'oFCKeditor.Config["SpellChecker"] = "ieSpell";';


      // attempt to focus correctly
      //
      global $reply_focus;
      if ($reply_focus == 'select') 
         echo 'oFCKeditor.Config["StartupFocus"] = "true";';
      else if ($reply_focus == 'focus') 
         echo 'oFCKeditor.Config["StartupFocus"] = "true";';
      else if ($reply_focus == 'none') 
         echo 'oFCKeditor.Config["StartupFocus"] = "false";';


      echo 'oFCKeditor.ReplaceTextarea();'
         . "\n// -->\n</script>";

   }


   // HTMLArea editor
   //
   else if ($editor_style == 2)
   {

      // actually replace the regular text area 
      //
      echo '<script DEFER language="javascript" type="text/javascript">HTMLArea.init();</script>' . "\n";
// the following replaces all textareas on the page w/out needing to know any IDs
//      echo '<script DEFER language="javascript" type="text/javascript">HTMLArea.replaceAll();</script>' . "\n";
// alternative way to replace just one known textarea, but our way is better cuz we get a 
// local variable with a reference to it
// i think this is wrong, isn't the function called replace() in this case?
//      echo '<script DEFER language="javascript" type="text/javascript">HTMLArea.replaceAll("body");</script>' . "\n";


/* wishful thinking.... doesnt' work:
      // attempt to focus correctly
      //
      global $reply_focus;
      echo '<script DEFER language="javascript" type="text/javascript">' 
         . "\n<!--\n";

      if ($reply_focus == 'select') 
         echo 'HTMLArea.focusEditor();';
         ///echo 'editor.focusEditor();';
      else if ($reply_focus == 'focus') 
         echo 'editor.focusEditor();';
         ///echo 'HTMLArea.focusEditor();';
         ///echo 'document.frames[0].document.forms["compose"].body.focus();';
      else if ($reply_focus == 'none')
         echo 'document.forms["compose"].send_to.focus();';

      echo "\n// -->\n</script>";
*/


//DEBUGGING
//sm_print_r($_SERVER, $_POST, $_GET, $_FILES);
   }

   }

}


/**
  * Enables display of emoticons on compose screen if possible
  *
  */
function html_mail_emoticons_do()
{

   global $username, $data_dir, $allowEmoticons, $use_emoticons, $editor_style;

   include_once (SM_PATH . 'plugins/html_mail/config.php');

   if ($editor_style == 2 && $allowEmoticons && html_area_is_on_and_is_supported_by_users_browser())
   {

      $use_emoticons = getPref($data_dir, $username, 'compose_window_use_emoticons', '');

      if ($use_emoticons)
         insert_emoticons();

   }

}


/**
  * Turns off squirrelspell when the user is composing 
  * HTML-formatted email, since squirrelspell will
  * choke on the HTML
  *
  */
function html_mail_disable_squirrelspell_do()
{

   global $squirrelmail_plugin_hooks;

   if (html_area_is_on_and_is_supported_by_users_browser())
   {

      if (!empty($squirrelmail_plugin_hooks['compose_button_row']['squirrelspell']))
         unset($squirrelmail_plugin_hooks['compose_button_row']['squirrelspell']);


      // get global variables for versions of PHP < 4.1
      //
      if (!compatibility_check_php_version(4, 1)) {
         global $HTTP_POST_FILES;
         $_FILES = $HTTP_POST_FILES;
      }


      // need to encode body text so > signs and other stuff don't 
      // get interpreted incorrectly as HTML entities
      //
      // but only need to do this once; don't repeat if user just
      // clicked to add a signature or upload a file or add addresses, etc
      //
      global $sigappend, $from_htmladdr_search, $restrict_senders_error_no_to_recipients,
             $restrict_senders_error_too_many_recipients;
      compatibility_sqextractGlobalVar('sigappend');
      compatibility_sqextractGlobalVar('from_htmladdr_search');
      compatibility_sqextractGlobalVar('restrict_senders_error_too_many_recipients');
      compatibility_sqextractGlobalVar('restrict_senders_error_no_to_recipients');
      if ($sigappend != 'Signature'
       && $from_htmladdr_search != 'true'
       && $restrict_senders_error_no_to_recipients != 1
       && $restrict_senders_error_too_many_recipients != 1
       && empty($_FILES['attachfile']))
      {

         global $body;

         // NOTE: don't bind text domain to html_mail because the Subject
         //       translations below have to be from SM core

         // also, for some strange reason, the subject line
         // doesn't get a <br> before it in the forward header
         // unless there is a space after the newline.  
         // argh!
         //
         ///$body = str_replace("-----\n" . _("Subject"), "-----\n " . _("Subject"), $body);
         // 
         // in fact, it's not seen as a newline... why??
         //
         $body = preg_replace('/-----\s' . _("Subject") . '/', "-----\n " . _("Subject"), $body);
   

         // email addresses in the form "name" <address> in 
         // the original message lose the address since it
         // is mistaken for a HTML tag
         //
         // ... sigh... have to encode twice...
         //
         // Update: WHY?  I can't reproduce the need for the second round
         // of encoding; I may have fixed that by adding the detection 
         // code for adding signatures, addresses, uploading files, etc. 
         // just above
         // 
         $body = htmlspecialchars($body);
         //$body = htmlspecialchars(htmlspecialchars($body));
   

         // this is faster than inserting line breaks using 
         // javascript (see html_mail_footer()) but it doesn't 
         // get the signature when "use signature" is turned
         // on, and the javascript method has been immensely
         // improved in HTML_Mail v2.1
         //
//         $body = nl2br($body);


      }

   }

}


function html_area_is_on_and_is_supported_by_users_browser()
{

   global $username, $data_dir;

   $type = getPref($data_dir, $username, 'compose_window_type');

   list($browser, $browserVersion) = getBrowserType();

   // NOTE: htmlarea 3 supports mozilla 1.4 and up... we'll 
   //       assume they meant gecko and not just mozilla
   //
   //       and also note that although "rv:1.4" is in the
   //       user agent string, the gecko engine 20030624
   //       should correspond to the correct version
   //
   return ($type == 'html' && (($browser == 'Explorer' && $browserVersion >= 5.5)
     || ($browser == 'Gecko' && $browserVersion >= 20030624)
   ));

}


// this function can figure things out on its own
// or use the "Browser_Info" plugin if it is coded
// up to SM standards...
//
function getBrowserType()
{

   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4,1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }

   $userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);


   if (preg_match('/opera[\s\/](\d+\.\d+)/', $userAgent, $version))
      $browser = 'Opera';
   else if (preg_match('/msie (\d+\.\d+)/', $userAgent, $version))
      $browser = 'Explorer';
   else if (preg_match('/gecko\/(\d+)/', $userAgent, $version))
      $browser = 'Gecko';

// Mozilla should be identified as Gecko above, and never get to this
// part... that's OK for our purposes, but if this causes problems,
// can push this else if above the Gecko lines above
   else if (preg_match('/mozilla\/(\d+\.\d+)/', $userAgent, $version))
      $browser = 'Mozilla';
   

//echo "$userAgent<hr><hr>$browser<br>" . $version[1];
   return array($browser, $version[1]);


// Example User Agent strings:
//
// MSIE 6 in Avant shell
// mozilla/4.0 (compatible; msie 6.0; windows nt 5.1; avant browser [avantbrowser.com]; .net clr 1.1.4322)
//
// Netscape 7
// mozilla/5.0 (windows; u; windows nt 5.1; en-us; rv:1.0.2) gecko/20030208 netscape/7.02
//
// Mozilla 1.1 (htmlarea doesn't work)
// mozilla/5.0 (windows; u; windows nt 5.1; en-us; rv:1.1) gecko/20020826
//
// Mozilla 1.4 (htmlarea does work!) 
// Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4) Gecko/20030624             (on linux)
// Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.4) Gecko/20030624     (on win2k)
// mozilla/5.0 (windows; u; windows nt 5.1; en-us; rv:1.4) gecko/20030624     (on winxp)
//
}


/**
  * Show user configuration items
  *
  */
function html_mail_display() 
{

   global $username, $data_dir, $email_type, $allowEmoticons, $use_emoticons,
          $editor_style;

   include_once (SM_PATH . 'plugins/html_mail/config.php');

   $email_type = getPref($data_dir, $username, 'compose_window_type', '');

   bindtextdomain('html_mail', SM_PATH . 'locale');
   textdomain('html_mail');

   echo '<tr><td align=right valign=top>'
      . _("Default Email Composition Format:") . "</td>\n"
      . '<td><input type="radio" value="plain" name="email_type" id="compInPlain" ';

   if ($email_type == 'plain' || $email_type == '') echo 'CHECKED';

   echo '><label for="compInPlain">&nbsp;' . _("Plain Text") . "</label>\n"
      . '&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" value="html" id="compInHTML" name="email_type" ';

   if ($email_type == 'html') echo 'CHECKED';

   echo '><label for="compInHTML">&nbsp;' . _("HTML") . "</label>\n".
      '</td></tr>' . "\n";


   if ($allowEmoticons && $editor_style == 2)
   {

      $use_emoticons = getPref($data_dir, $username, 'compose_window_use_emoticons', '');

      echo '<tr><td align=right valign=top>'
         . _("Use Emoticons:") . "</td>\n"
         . '<td><input type="radio" value="1" name="use_emoticons" id="yesEmot" ';

      if ($use_emoticons) echo 'CHECKED';

      echo '><label for="yesEmot">&nbsp;' . _("Yes") . "</label>\n"
         . '&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" value="0" name="use_emoticons" id="noEmot" ';

      if (!$use_emoticons) echo 'CHECKED';

      echo '><label for="noEmot">&nbsp;' . _("No") . "</label>\n".
         '</td></tr>' . "\n";

   }

   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



/**
  * Save user configuration items
  *
  */
function html_mail_save() 
{

   global $username, $data_dir, $email_type, $use_emoticons;

   compatibility_sqextractGlobalVar('email_type');
   compatibility_sqextractGlobalVar('use_emoticons');

   setPref($data_dir, $username, 'compose_window_type', $email_type);
   if (strlen($use_emoticons) > 0) 
      setPref($data_dir, $username, 'compose_window_use_emoticons', $use_emoticons);

}



/**
  * Load user configuration items
  *
  */
function html_mail_prefs_load() 
{

   global $username, $data_dir, $email_type, $use_emoticons;

   $email_type = getPref($data_dir, $username, 'compose_window_type');
   //$use_emoticons = getPref($data_dir, $username, 'compose_window_use_emoticons');

}


/**
  * Changes outgoing message format to include multipart
  * html and text parts if needed
  *
  */
function html_mail_alter_type_do(&$argv)
{

   // change outgoing encoding if supported/turned on
   //
   if (html_area_is_on_and_is_supported_by_users_browser())
   {

      $message = &$argv[1];
//echo "<hr>";sm_print_r($message);echo "<hr>";exit;


      global $strip_html_send_plain;
      compatibility_sqextractGlobalVar('strip_html_send_plain');


      // user wants to send this one in plain text,
      // so we have to:
      // 1) convert <p> and <br> into newlines
      // 2) strip the HTML out
      // 3) drop comments generated by html-stripping mechanism
      //
      if ($strip_html_send_plain)
      {

         if (is_array($message->entities) && sizeof($message->entities) > 0)
         {
            $msg = str_replace(array('<!-- begin sanitized html -->', '<!-- end sanitized html -->'), '', sq_sanitize( preg_replace('/(<br\s*\/?\s*>|<p\s*>)/i', "\n", $message->entities[0]->body_part), array(TRUE), array(), array(), array(), array(), array(), array(), array(), array(), array()));

            // need to decode special chars..
            //
            $message->entities[0]->body_part = my_html_entity_decode($msg);
         }
         else
         {
            $msg = str_replace(array('<!-- begin sanitized html -->', '<!-- end sanitized html -->'), '', sq_sanitize( preg_replace('/(<br\s*\/?\s*>|<p\s*>)/i', "\n", $message->body_part), array(TRUE), array(), array(), array(), array(), array(), array(), array(), array(), array()));

            // need to decode special chars..
            //
            $message->body_part = my_html_entity_decode($msg);
         }

      }


      // otherwise, set the outgoing content type correctly and add a 
      // text/plain mime part, which means non-multipart messages 
      // need to be converted to multipart...
      //
      else
      {

         // already multipart; change original message part to 
         // multipart/alternative and add a plain text and html
         // part therein 
         //
         if (is_array($message->entities) && sizeof($message->entities) > 0)
         {
            $plainText = str_replace(array('<!-- begin sanitized html -->', '<!-- end sanitized html -->'), '', sq_sanitize( preg_replace('/(<br\s*\/?\s*>|<p\s*>)/i', "\n", $message->entities[0]->body_part), array(TRUE), array(), array(), array(), array(), array(), array(), array(), array(), array()));
            $plainText = my_html_entity_decode($plainText);

            $message->entities[0]->mime_header->type1 = 'html';
            $htmlTextPart = $message->entities[0];

            $plainTextPart = new Message();
            $plainTextPart->body_part = $plainText;
            $mime_header = new MessageHeader;
            $mime_header->type0 = 'text';
            $mime_header->type1 = 'plain';
            $mime_header->encoding = $message->entities[0]->mime_header->encoding;
            $mime_header->parameters = $message->entities[0]->mime_header->parameters;
            $plainTextPart->mime_header = $mime_header;

            $message->entities[0]->mime_header->type0 = 'multipart';
            $message->entities[0]->mime_header->type1 = 'alternative';
            $message->entities[0]->mime_header->encoding = '';
            $message->entities[0]->mime_header->parameters = array();
            $message->entities[0]->body_part = '';

            // gets us a different message boundary 
            $message->entities[0]->entity_id = 'usf' . mt_rand(1000, 9999);


            $message->entities[0]->entities = array($plainTextPart, $htmlTextPart);
//echo "<hr>";sm_print_r($message);echo "<hr>";exit;
         }

         // not multipart; convert to multipart, change original message
         // to html and add text/plain part
         //
         else
         {
            $plainText = str_replace(array('<!-- begin sanitized html -->', '<!-- end sanitized html -->'), '', sq_sanitize( preg_replace('/(<br\s*\/?\s*>|<p\s*>)/i', "\n", $message->body_part), array(TRUE), array(), array(), array(), array(), array(), array(), array(), array(), array()));
            $plainText = my_html_entity_decode($plainText);

            $htmlTextPart = new Message();
            $htmlTextPart->body_part = $message->body_part;
            $htmlPartMime_header = new MessageHeader;
            $htmlPartMime_header->type0 = 'text';
            $htmlPartMime_header->type1 = 'html';
            $htmlPartMime_header->encoding = $message->rfc822_header->encoding;
            $htmlPartMime_header->parameters = $message->rfc822_header->content_type->properties;
            $htmlTextPart->mime_header = $htmlPartMime_header;

            $plainTextPart = new Message();
            $plainTextPart->body_part = $plainText;
            $plainPartMime_header = new MessageHeader;
            $plainPartMime_header->type0 = 'text';
            $plainPartMime_header->type1 = 'plain';
            $plainPartMime_header->encoding = $message->rfc822_header->encoding;
            $plainPartMime_header->parameters = $message->rfc822_header->content_type->properties;
            $plainTextPart->mime_header = $plainPartMime_header;

            // clear out some parts of the original non-multipart message
            //
            $message->rfc822_header->encoding = '';
            $message->rfc822_header->content_type->type0 = 'multipart';
            $message->rfc822_header->content_type->type1 = 'alternative';
            $message->rfc822_header->content_type->properties = array();
            $message->body_part = '';

            $message->entities = array($plainTextPart, $htmlTextPart);
//echo "<hr>";sm_print_r($message);echo "<hr>";exit;
 
         }
      }

      return $message;

   }

}


/**
  * Show emoticons on screen
  *
  */
function insert_emoticons()
{

   echo '<TR><TD colspan="2"><BR />';


   echo '

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/regular_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/regular_smile.gif" border="0" ALT="Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/teeth_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/teeth_smile.gif" border="0" ALT="Open-Mouthed Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/wink_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/wink_smile.gif" border="0" ALT="Winking Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/omg_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/omg_smile.gif" border="0" ALT="Surprised Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/tounge_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/tounge_smile.gif" border="0" ALT="Tounge-Out Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/shades_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/shades_smile.gif" border="0" ALT="Cool Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/angry_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/angry_smile.gif" border="0" ALT="Angry Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/confused_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/confused_smile.gif" border="0" ALT="Confused Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/embaressed_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/embaressed_smile.gif" border="0" ALT="Embarassed Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/sad_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/sad_smile.gif" border="0" ALT="Sad Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/cry_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/cry_smile.gif" border="0" ALT="Crying Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/whatchutalkingabout_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/whatchutalkingabout_smile.gif" border="0" ALT="Disappointed Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/angel_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/angel_smile.gif" border="0" ALT="Innocent Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/undecided.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/undecided.gif" border="0" ALT="Undecided Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/dude_hug.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/dude_hug.gif" border="0" ALT="Male Hug"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/girl_hug.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/girl_hug.gif" border="0" ALT="Female Hug"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/girl_handsacrossamerica.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/girl_handsacrossamerica.gif" border="0" ALT="Girl"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/guy_handsacrossamerica.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/guy_handsacrossamerica.gif" border="0" ALT="Boy"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/heart.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/heart.gif" border="0" ALT="Red Heart"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/broken_heart.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/broken_heart.gif" border="0" ALT="Broken Heart"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/rose.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/rose.gif" border="0" ALT="Red Rose"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/wilted_rose.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/wilted_rose.gif" border="0" ALT="Wilted Rose"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/kiss.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/kiss.gif" border="0" ALT="Kiss"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/beer_yum.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/beer_yum.gif" border="0" ALT="Beer"></a>

<BR>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/martini_shaken.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/martini_shaken.gif" border="0" ALT="Martini"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/coffee.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/coffee.gif" border="0" ALT="Coffee"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/bat.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/bat.gif" border="0" ALT="Bat"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/bowwow.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/bowwow.gif" border="0" ALT="Dog"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/kittykay.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/kittykay.gif" border="0" ALT="Cat"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/cake.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/cake.gif" border="0" ALT="Cake"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/present.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/present.gif" border="0" ALT="Gift"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/clock.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/clock.gif" border="0" ALT="Clock"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/devil_smile.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/devil_smile.gif" border="0" ALT="Devil Smiley"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/envelope.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/envelope.gif" border="0" ALT="Email"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/messenger.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/messenger.gif" border="0" ALT="MSN Messenger"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/phone.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/phone.gif" border="0" ALT="Phone Call"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/camera.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/camera.gif" border="0" ALT="Camera"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/film.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/film.gif" border="0" ALT="Movie"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/musical_note.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/musical_note.gif" border="0" ALT="Music"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/asl.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/asl.gif" border="0" ALT="Age/Sex/Location"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/handcuffs.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/handcuffs.gif" border="0" ALT="Handcuffs"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/sun.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/sun.gif" border="0" ALT="Sun"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/moon.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/moon.gif" border="0" ALT="Moon"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/lightbulb.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/lightbulb.gif" border="0" ALT="Light Bulb"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/star.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/star.gif" border="0" ALT="Star"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/thumbs_down.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/thumbs_down.gif" border="0" ALT="Thumbs Down"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/thumbs_up.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/thumbs_up.gif" border="0" ALT="Thumbs Up"></a>

<a href="javascript:editor.insertHTML(\'<img src=' . SM_PATH . 'plugins/html_mail/images/rainbow.gif>\');"><img src="' . SM_PATH . 'plugins/html_mail/images/rainbow.gif" border="0" ALT="Rainbow"></a>


   ';


   echo "</TD></TR>";

}



function my_html_entity_decode($text)
{

   if (function_exists('html_entity_decode'))
      return html_entity_decode($text);


   // copied from http://us3.php.net/preg-replace
   //
   $search = array ("'<script[^>]*?>.*?</script>'si",  // Strip out javascript
                    "'<[\/\!]*?[^<>]*?>'si",           // Strip out html tags
                    "'([\r\n])[\s]+'",                 // Strip out white space
                    "'&(quot|#34);'i",                 // Replace html entities
                    "'&(amp|#38);'i",
                    "'&(lt|#60);'i",
                    "'&(gt|#62);'i",
                    "'&(nbsp|#160);'i",
                    "'&(iexcl|#161);'i",
                    "'&(cent|#162);'i",
                    "'&(pound|#163);'i",
                    "'&(copy|#169);'i",
                    "'&#(\d+);'e");                    // evaluate as php

   $replace = array ("",
                     "",
                     "\\1",
                     "\"",
                     "&",
                     "<",
                     ">",
                     " ",
                     chr(161),
                     chr(162),
                     chr(163),
                     chr(169),
                     "chr(\\1)");

   return preg_replace ($search, $replace, $text);

}



?>
