<?php


   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');




function html_mail_header_do()
{

   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4,1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }

   if (stristr($_SERVER['SCRIPT_NAME'], 'compose.php'))
      html_mail_turn_on_htmlarea();

}


function html_mail_turn_on_htmlarea() 
{

   global $username,$data_dir;

   $type = getPref($data_dir, $username, 'compose_window_type');

   list($browser, $browserVersion) = getBrowserType();

   // TODO: htmlarea 3 supposedly supports mozilla (still might be buggy)
   //
   if ($type == 'html' && (($browser == 'Explorer' && $browserVersion >= 5.5)
     || ($browser == 'Mozilla' && $browserVersion >= 6.0)
   ))
   {

      if (compatibility_check_sm_version(1, 3))
      {
         echo '<script language="javascript" type="text/javascript" src="' . SM_PATH . 'plugins/html_mail/htmlarea/htmlarea.js"></script>'
            . '<script language="javascript" type="text/javascript" src="' . SM_PATH . 'plugins/html_mail/htmlarea/htmlarea-lang-en.js"></script>'
            . '<script language="javascript" type="text/javascript" src="' . SM_PATH . 'plugins/html_mail/htmlarea/dialog.js"></script>'
            . '<style type="text/css">@import url("' . SM_PATH . 'plugins/html_mail/htmlarea/htmlarea.css");</style>'
            . '<script language="javascript" type="text/javascript">' . "\n"
            . '<!--' . "\n"
            . 'var _editor_url = "' . SM_PATH . 'plugins/html_mail/htmlarea/"';
      }
      else
      {
         echo '<script language="javascript" type="text/javascript" src="../plugins/html_mail/htmlarea/htmlarea.js"></script>'
            . '<script language="javascript" type="text/javascript" src="../plugins/html_mail/htmlarea/htmlarea-lang-en.js"></script>'
            . '<script language="javascript" type="text/javascript" src="../plugins/html_mail/htmlarea/dialog.js"></script>'
            . '<style type="text/css">@import url("../plugins/html_mail/htmlarea/htmlarea.css");</style>'
            . '<script language="javascript" type="text/javascript">' . "\n"
            . '<!--' . "\n"
            . 'var _editor_url = "../plugins/html_mail/htmlarea/"';
      }

      ?>

         var editor = null;
         function initEditor() 
         {
// probably requires change to src/compose.php --> textarea needs an "id" attribute
//            editor = new HTMLArea("body");

            // other editor customizations here...

         }
         //-->
         </script>

      <?php

   }  // End Added For htmlarea

}


function html_mail_footer() 
{

   global $username, $data_dir;

   $type = getPref($data_dir, $username, 'compose_window_type');

   list($browser, $browserVersion) = getBrowserType();

   // TODO: htmlarea 3 supposedly supports mozilla (still might be buggy)
   //
   if ($type == 'html' && (($browser == 'Explorer' && $browserVersion >= 5.5)
     || ($browser == 'Mozilla' && $browserVersion >= 6.0)
   ))
//      echo '<script language="javascript" type="text/javascript">initEditor();</script>' . "\n";
      echo '<script DEFER language="javascript" type="text/javascript">HTMLArea.replaceAll();</script>' . "\n";
//      echo '<script DEFER language="javascript" type="text/javascript">HTMLArea.replaceAll("body");</script>' . "\n";

}


// this function can figure things out on its own
// or use the "Browser_Info" plugin if it is coded
// up to SM standards...
//
function getBrowserType()
{

   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4,1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }

   $userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);


   if (preg_match('/opera[\s\/](\d+\.\d+)/', $userAgent, $version))
      $browser = 'Opera';
   else if (preg_match('/msie (\d+\.\d+)/', $userAgent, $version))
      $browser = 'Explorer';
   else if (preg_match('/mozilla\/(\d+\.\d+)/', $userAgent, $version))
      $browser = 'Mozilla';
// will lose "Mozilla", oh well, not importnat here yet
   else if (preg_match('/gecko\/(\d+)/', $userAgent, $version))
      $browser = 'Gecko';
   

//echo "$userAgent<hr>$browser<hr>" . $version[1];
   return array($browser, $version[1]);


// Examples:
//
// MSIE 6 in Avant shell
// mozilla/4.0 (compatible; msie 6.0; windows nt 5.1; avant browser [avantbrowser.com]; .net clr 1.1.4322)
//
// Netscape 7
// mozilla/5.0 (windows; u; windows nt 5.1; en-us; rv:1.0.2) gecko/20030208 netscape/7.02
//
}


function html_mail_display() 
{

   global $username, $data_dir, $email_type;

   $email_type = getPref($data_dir, $username, 'compose_window_type', '');

   echo '<tr><td align=right valign=top>'
      . _("Email Composition Format:") . "</td>\n"
      . '<td><input type="radio" value="plain" name="email_type" ';

   if ($email_type == 'plain' || $email_type == '') echo 'CHECKED';

   echo '>&nbsp;' . _("Plain Text") . "\n"
      . '&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" value="html" name="email_type" ';

   if ($email_type == 'html') echo 'CHECKED';

   echo '>&nbsp;' . _("HTML") . "\n".
      '</td></tr>' . "\n";

}


function html_mail_save() 
{

   global $username, $data_dir, $email_type;

   compatibility_sqextractGlobalVar('email_type');

   setPref($data_dir, $username, 'compose_window_type', $email_type);

}


function html_mail_prefs_load() 
{

   global $username, $data_dir, $email_type;

   $email_type = getPref($data_dir, $username, 'compose_window_type');

}


function html_mail_alter_type_do(&$argv)
{

   global $username, $data_dir;

   $type = getPref($data_dir, $username, 'compose_window_type');

   list($browser, $browserVersion) = getBrowserType();

   // TODO: htmlarea 3 supposedly supports mozilla (still might be buggy)
   //
   if ($type == 'html' && (($browser == 'Explorer' && $browserVersion >= 5.5)
     || ($browser == 'Mozilla' && $browserVersion >= 6.0)
   ))
   {
      $message = &$argv[1];
      $message->rfc822_header->content_type->type1 = 'html';
      return $message;
   }

}


?>
