<?php
/**
 * gpgsign.mod
 * -----------
 * This is the code that actually takes the signed text and replaces
 * body in compose.php with what is found in cyphertext
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * Initial Author: Tyler Allison
 * $Id: gpgsign.mod,v 1.7 2003/04/01 07:11:42 brian Exp $
 *
 */
/*********************************************************************/
if (file_exists('gpg_sign_functions.php')){
	require_once('gpg_sign_functions.php');
} elseif (file_exists('../gpg_sign_functions.php')){
    require_once('../gpg_sign_functions.php');
} elseif (file_exists('../plugins/gpg/gpg_sign_functions.php')){
    require_once('../plugins/gpg/gpg_sign_functions.php');
} else echo "include file not found, exiting abnormally";

global $debug;
$body_text = $_POST['body_text'];
$passphrase = $_POST['passphrase'];
$return = gpg_sign_message($body_text,$passphrase,$debug);
$cyphertext_raw=$return['cyphertext'];
$cyphertext_exploded = explode("\n",$cyphertext_raw);

echo<<<TILLEND
<HTML>
<HEAD>
<script language="JavaScript" type="text/javascript">
<!--
function signCommitChanges() {

var cyphertext_lines=new Array();

TILLEND;

for ($i=0; $i<sizeof($cyphertext_exploded); $i++){
  echo "cyphertext_lines[$i] = \""
    . chop(addslashes($cyphertext_exploded[$i])) . "\";\n";
}

echo<<<TILLEND

newBody = "";
for (i=0; i<cyphertext_lines.length; i++) {
  if (i!=0) newBody+="\\r\\n";
  newBody += cyphertext_lines[i];
}

opener.document.forms[0].body.value=newBody;
TILLEND;
if (!$debug) {
echo "self.close();";
}
echo<<<TILLEND
}
// -->
</script>
</HEAD>
<BODY onload="signCommitChanges();">
<BODY>
</BODY>
</HTML>
TILLEND;
/*
 * $Log: gpgsign.mod,v $
 * Revision 1.7  2003/04/01 07:11:42  brian
 * fixed includes to reflect different calling directories
 *
 * Revision 1.6  2003/03/31 14:14:03  brian
 * added require_once statement to require signing functions file.
 * change needed to use generalized pop-up window function
 *
 * Revision 1.5  2003/03/12 19:08:33  tyler
 * - added footer section
 *
 */
?>

