<?php
/**
 * gpgdecrypt.mod
 * -----------
 * This is the code that actually takes the signed text and replaces
 * body in compose.php with what is found in cyphertext
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * $Id: gpgdecrypt.mod,v 1.20 2003/04/04 13:27:13 brian Exp $
 */
/*********************************************************************/
if (file_exists('gpg_encrypt_functions.php')){
	require_once('gpg_encrypt_functions.php');
    require_once('../../functions/imap.php');
    require_once('../../config/config.php');
} elseif (file_exists('../gpg_encrypt_functions.php')){
    require_once('../gpg_encrypt_functions.php');
    require_once('../../../functions/imap.php');
    require_once('../../../config/config.php');
} elseif (file_exists('../plugins/gpg/gpg_encrypt_functions.php')){
    require_once('../plugins/gpg/gpg_encrypt_functions.php');
    require_once('../functions/imap.php');
    require_once('../config/config.php');
} else echo "include file not found, exiting abnormally";

global $debug;
$body_text  = $_POST['body_text'];
$passphrase = $_POST['passphrase'];
$passed_id  = (int) $_POST['passed_id'];
$mailbox    = $_POST['mailbox'];
$username   = $_SESSION['username'];
$key        = $_COOKIE['key'];
$onetimepad = $_SESSION['onetimepad'];
$base_uri   = $_SESSION['base_uri'];
$delimiter  = $_SESSION['delimiter'];
if ($debug) {
    echo "<br>username = $username<br>"
         . "passed_id = $passed_id<br>"
         . "mailbox = $mailbox";
}

//initialize the display message
$msg='';

//resize the window to display the plaintext in it.
$msg= '<script language="javascript1.2" type="text/javascript1.2">' . "\n"
    . "<!--\n"
    . 'self.resizeTo(600, 400)'
    . "\n//-->\n"
    . '</script>';

//get the body text
global $uid_support;
$imapConnection = sqimap_login($username, $key, $imapServerAddress,
                               $imapPort, 0);
if ($imapConnection==false){
    echo 'Connection to Imap Server to retrieve message body failed<br>';
};

$read = sqimap_mailbox_select($imapConnection, $mailbox, false, false, true);
if ($debug) {
    echo "<br>Mailbox Select returned:$read<br>";
}
$body_text=sqimap_run_command ($imapConnection, "FETCH $passed_id BODY[]",
                              true, $a, $b, $uid_support);
if (is_array($body_text)) {
     $body_text = implode($body_text,'');
};
//now parse the return value to strip off the email headers
$sep = '-----BEGIN PGP MESSAGE-----';

list ($header, $cyphertext_tail) = explode ($sep, $body_text);

	if ($debug) {
		echo "<hr>Message Header: $header";
		echo "<br>Message Body: $cyphertext_tail";
	};

$body_text = "$sep$cyphertext_tail";


sqimap_logout($imapConnection);

if ($debug) {
    echo '<br>Body Text<br><pre>'
         .  "$body_text"
         .  '</pre>';
}

//now call decrypt
$return = gpg_decrypt($body_text,$passphrase,$debug);

$msg .= '<hr>';

//now parse the info, errors, and warnings.
$notclean=0;
$serious=0;
	//echo the errors and warning to this page before continuing.
        foreach ($return['warnings'] as $warning) {
    		$notclean=1;
    		$msg .= '<br>Warning: '. htmlspecialchars($warning);
		};
        foreach ($return['errors'] as $error) {
    		$notclean=1;
    		$serious=1;
	        $msg .= '<br>Error: '. htmlspecialchars($error);
		};
	    foreach ($return['info'] as $info){
	        $msg .= '<br> Info: '. htmlspecialchars($info);
	    };

//use htmlspecialchars on the plaintext, to allow the user to see things like <>
$plaintext = htmlspecialchars($return['plaintext']);

//put a header row here
$msg .='<center><strong>Decrypted Message</strong></center><hr>';
//display the plaintext
$msg .= '<small><pre>'. $plaintext .'</pre></small>';
//display a close window link/button/etc,
$msg .="<hr><center><input type='button' value='Close Window' onclick='window.close()'></center><hr>";

gpg_makePopWindow(_('GPG Decryption Results'),'', $msg);

/*
 * $Log: gpgdecrypt.mod,v $
 * Revision 1.20  2003/04/04 13:27:13  brian
 * add uid support to sqimap_run_copmmand
 *
 * Revision 1.19  2003/04/02 20:48:39  brian
 * fixed spelling errors using aspell
 * TODO - check grammer and sentence structure manually
 * Bug 18
 *
 * Revision 1.18  2003/04/02 19:13:58  brian
 * removed trailing line feeds
 *
 * Revision 1.17  2003/04/02 13:10:04  brian
 * use htmlspecialchars on plaintext
 *
 * Revision 1.16  2003/04/02 12:38:50  brian
 * added javascript to resize window to display decrypted message in.
 *
 * Revision 1.15  2003/04/01 17:53:14  brian
 * fixed includes to reflect different calling directories
 *
 * Revision 1.14  2003/04/01 16:06:44  brian
 * modified to use htmlspecialchars for info, warning, and error returns
 * Bug 8
 *
 * Revision 1.13  2003/04/01 05:28:03  brian
 * merged changes
 *
 * Revision 1.12  2003/04/01 05:07:42  joelm
 * Fixed some paths to included files. Also removed carriage returns from
 * cyphertext in the decrypt module
 *
 * Revision 1.11  2003/03/31 23:43:07  brian
 * modified to strip off the email headers
 *
 * Revision 1.10  2003/03/31 23:33:27  brian
 * modified to implode $body_text array
 *
 * Revision 1.9  2003/03/31 23:21:56  brian
 * added more debug lines
 *
 * Revision 1.8  2003/03/31 23:16:25  brian
 * added more debug lines
 *
 * Revision 1.7  2003/03/31 23:13:51  brian
 * added more debug lines
 *
 * Revision 1.6  2003/03/31 23:10:12  brian
 * - modified to include imap.php for all SM imap functions
 * - call smimap_mailbox_select to select mailbox to FETCH message from
 * Bug 8
 *
 * Revision 1.5  2003/03/31 23:05:22  brian
 * modified to use sqimap_run_command instead of calling sqimap_read_data directly
 * Bug 8
 *
 * Revision 1.4  2003/03/31 22:33:09  brian
 * added debug statements to make it easier to see what is going on here
 *
 * Revision 1.3  2003/03/31 22:16:48  brian
 * modified to make imap connection to grab body of email
 *
 * Revision 1.2  2003/03/31 14:59:54  brian
 * updated decryption modules to use standardized gpg_pop_init.php methods
 * Bug 8
 *
 * Revision 1.1  2003/03/29 23:03:21  brian
 * Initial revision
 * Preparation for decrypt functionality
 * Bug 8
 *
 *
 */
?>