<?php

/**
 * gpg_sign_message.php
 * -----------
 * GPG popup window base file
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * $Id: gpg_pop_init.php,v 1.1 2003/03/31 14:02:47 brian Exp $
 *
 */

require_once('gpg_functions.php');
require_once('gpg_pop_functions.php');
// require any other files needed in the pop-up module(s)

/**
 * $MOD is the name of the module to invoke.
 * If $MOD is undefined check for security
 * breaches.
 */
if(isset($_POST['MOD'])) {
  $MOD = $_POST['MOD'];
} elseif (isset($_GET['MOD'])) {
  $MOD = $_GET['MOD'];
}

/**
 * $MOD is the name of the module to invoke.
 * If $MOD is unspecified, check for security breach attempts.
 */
if (!isset($MOD) || !$MOD){
  gpg_ckMOD($MOD);
}

/**
 * Include the module.
 */
require_once("modules/$MOD.mod");

/************************************************************/
/*
 * $Log: gpg_pop_init.php,v $
 * Revision 1.1  2003/03/31 14:02:47  brian
 * Initial Revision
 * Created general file for use by all pop-up windows in the plugin.
 * TODO: modify signing and decryption features to use the general init file.
 *
 *
 */

?>
