<?php
/**
 * setup.php
 * -----------
 * GPG plugin setup file, as defined by the SquirrelMail-1.2 API.
 * Updated to account for SM 1.4 pathing issues
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * $Id: setup.php,v 1.32 2003/04/09 12:59:20 brian Exp $
 *
 */

require_once('gpg_pref_functions.php');

//hack this to account for the different places we can be called from.
if (file_exists('../functions/strings.php')){
	require_once('../functions/strings.php');
	require_once('../functions/prefs.php');
} elseif (file_exists('../../functions/strings.php')){
	require_once('../../functions/strings.php');
    require_once('../../functions/prefs.php');
} elseif (file_exists('../../../functions/strings.php')){
	require_once('../../../functions/strings.php');
    require_once('../../../functions/prefs.php');
};


$GLOBALS['GPG_SYSTEM_OPTIONS'][$matches[1]]= "";

if ( !check_php_version(4,1) ) {
    global $_SESSION;
}

$username = $_SESSION['username'];

/* Just for poor wretched souls with E_ALL. :) */
global $data_dir;

$gpg_key_dir ="$data_dir$username.gnupg";

/**
 * function squirrelmail_plugin_init_gpg
 *
 * Standard squirrelmail plugin initialization API.
 *
 * Called by the SM core on page load to see if there are
 * hooks that need to be registered and displayed.
 *
 * Format for registering a hook:
 *
 * $squirrelmail_plugin_hooks['sm_hook_name']['gpg'] = 'function_to_call';
 *
 * All function_to_call should be within the setup.php file
 * this file is called frequently by SM, so make it as tight
 * as possible.
 *
 * @return void
 */
function squirrelmail_plugin_init_gpg() {
  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks['compose_button_row']['gpg'] =
     'gpg_compose_row';

  $squirrelmail_plugin_hooks['optpage_register_block']['gpg'] =
     'gpg_optpage_register_block';

  $squirrelmail_plugin_hooks['options_link_and_description']['gpg'] =
     'gpg_options';

  $squirrelmail_plugin_hooks['read_body_header']['gpg'] =
     'gpg_read_body_header';
}

/*********************************************************************/
/**
 * function gpg_read_body_header
 *
 * this function is called by the main SM plugin_init (above)
 * to initialize our read_body_header functions
 *
 */
function gpg_read_body_header () {
    //pull in the globals we need from the read_body.php page
    global $imapConnection, $passed_id, $mailbox;
    //populate the message body
    $body = gpg_fetch_full_body ($imapConnection, $passed_id, $mailbox);
    //check to see if we need to verify a gpg signature
    gpg_check_sign ($body);
    //and then check to see if we should register the decrypt now link
    gpg_decrypt_link ($body);
}



/*********************************************************************/
/**
 * function gpg_fetch_full_body
 *
 * This function is called before
 * gpg_check_sign and gpg_decrypt_link
 * to retrieve the messge body for those functions
 *
 * @param $imapConnection, $passed_id, $mailbox
 * @return $body as string
 */
function gpg_fetch_full_body ($imapConnection, $passed_id, $mailbox) {
   //retrieve the message body
   global $uid_support;

   $body=sqimap_run_command ($imapConnection, "FETCH $passed_id BODY[]", true, $a, $b,$uid_support);
   if (is_array($body)) {
       $body = implode($body,'');
   };

   return ($body);
}

/*********************************************************************/
/**
 * function gpg_decrypt_link
 *
 * This function is called by the read_body hook (above)
 *
 * Use to see if the message contains an encrypted body
 * if the message contains encrypted text, display a link to the decrypt code.
 *
 * @param $body
 * @return
 */
function gpg_decrypt_link($body) {
  global $passed_id, $mailbox;
  global $data_dir;
  global $username;
  $gpg_key_dir ="$data_dir$username.gnupg";
  $sep = '-----BEGIN PGP MESSAGE-----';
  $pos = strpos($body,$sep);
  if ($pos !== false) {
  //display the Decrypt Now link
  echo<<<TILLEND
  <p align=center>
  <script type='text/javascript'>
  <!--
  document.write("<input type='button' value='Decrypt Message Now' onclick=\"window.open('../plugins/gpg/gpg_pop_init.php?MOD=decrypt_init\&passed_id=$passed_id\&mailbox=$mailbox','Decrypt_Now','status=yes,width=300,height=200,resizable=yes,scrollbars=yes')\"> ");
  //-->
  </script>
  </p>
TILLEND;
  }
}

/*********************************************************************/
/**
 * function gpg_check_sign
 *
 * This function is called by the read_body hook (above)
 *
 * @param $body
 * @return
 */
function gpg_check_sign($body) {
  $return=0;
  // attempt to check the signature if it looks like it has one
  global $data_dir;
  global $username;
  $gpg_key_dir ="$data_dir$username.gnupg";
  $sep = '-----BEGIN PGP SIGNED MESSAGE-----';
  $pos = strpos($body,$sep);
  if ($pos !== false) {
  	$return = 1;
    $body = escapeshellarg($body);
    // set this to 1 if you want to double check the prefs loading
    $debug=0;
    load_prefs_from_file('../plugins/gpg/gpg_system_defaults.txt',$debug);
    load_prefs_from_file('../plugins/gpg/gpg_local_prefs.txt',$debug);
    $path_to_gpg = $GLOBALS['GPG_SYSTEM_OPTIONS']['path_to_gpg'];

    $command = "echo $body | $path_to_gpg --batch --no-tty --homedir $gpg_key_dir --verify 2>&1";
    exec($command, $results, $returnval);
    print "<TR><TD colspan=30></SMALL>";
    if (is_array($results)) {
     $i=0;
      for ($i=0; $i<count($results); $i++) {
        $pos = strpos($results[$i],'gpg:');
        if ($pos !== false) {
           print $results[$i];
           print "<br>";
        }
      }
    }
    print "</SMALL></TD></TR>";
  }
  return ($return);
}

/*********************************************************************/
/**
 * function gpg_optpage_register_block ()
 *
 * This function formats and adds the plugin and its description to the
 * Options screen.
 *
 * @return void
 */
function gpg_optpage_register_block() {
  global $optpage_blocks;
  /**
   * soupNazi checks if this browser is capable of using the plugin.
   */
  if (!soupNazi()) {
    /**
     * The browser checks out.
     * Register Gpg with the $optionpages array.
     */
    $optpage_blocks[] =
       array(
	     'name' => _("G/PGP Encryption Options"),
	     'url'  => '../plugins/gpg/gpg_options.php',
	     'desc' => _("Here you may set up how your keys are stored, edit them, and how you will use the encryption plug-in."),
	     'js'   => TRUE);
  }
}

/*********************************************************************/
/**
 * function gpg_compose_row ()
 *
 * This function adds a "Encrypt Now" and "GPG Sign" link to the
 * "Compose" row during message composition.
 *
 * @return void
 */
function gpg_compose_row() {
  /**
   * Check if this browser is capable of displaying Gpg
   * correctly.
   */
  if (!soupNazi()) {
    /**
     * Check to see if the user has a key directory (and presumably keys)
     * before displaying the "Encrypt Now" button.
     * Assume that if the user has a .gnupg directory, they have a keyring.
     * This assumption is not foolproof, but should work
     * Extend this to include signing check once secret keys are supported.
     */
     global $data_dir;
     global $username;
     $gpg_key_dir ="$data_dir$username.gnupg";
     $pubring="$gpg_key_dir/pubring.gpg";
     $secring="$gpg_key_dir/secring.gpg";
     global $no_encrypt_on_setup;

// set this to 1 if you want to double check the prefs loading
$debug=0;

//load our system and local prefs files so we can figure out where things are
if (file_exists('../plugins/gpg/gpg_system_defaults.txt')){
	if ($debug) { echo '<br>Assuming we are one level up from main tree, loading from ../plugins/gpg/<br>';};
    load_prefs_from_file('../plugins/gpg/gpg_system_defaults.txt',$debug);
    load_prefs_from_file('../plugins/gpg/gpg_local_prefs.txt',$debug);
} elseif (file_exists('gpg_system_defaults.txt')){
	if ($debug) { echo '<br>Assuming we are in plugins/gpg, loading from ./<br>';};
    load_prefs_from_file('gpg_system_defaults.txt',$debug);
    load_prefs_from_file('gpg_local_prefs.txt',$debug);
} else {
    echo '<br> GPG Preference Path unknown, halting irregularly.<br>';
    exit;
};

/**
 * Some people may choose to disable javascript even though their
 * browser is capable of using it. So these folks don't complain,
 * use document.write() so the "Encrypt Now" and "GPG Sign"
 * buttons are not displayed if js is off in the browser.
 *
 * Also, check to make sure that the user has keyrings on the system before
 * displaying buttons for features they can't use.
 *
 * $no_encrypt_on_setup is a variable that is set to make sure that the
 * buttons don't display after we have already encrypted the message.
 * there is no point in displaying them after successful encryption.
 */
if ($chdir_first) {
    chdir ('../');
};

//add the "Encrypt Now" button
     if (file_exists($pubring)){


         if (!$no_encrypt_on_setup) {

            echo <<<TILLEND
<br>
<script type='text/javascript'>
<!--
document.write("<input type='submit' name='form' value='Encrypt Now' onclick=\"this.form.action='../plugins/gpg/gpg_encrypt.php'\"> ");
//-->
</script>
TILLEND;
		 } else {
            echo <<<TILLEND
<script type='text/javascript'>
<!--
document.compose.action= '../../src/compose.php';
//-->
</script>
TILLEND;
		 };

    }; //end "Encrypt Now" button setup

// add the "GPG Sign" Button

    if ((file_exists($secring)) and (filesize($secring)>0) and ($GLOBALS['GPG_SYSTEM_OPTIONS']['allowprivatekeys'])){
       if (!$no_encrypt_on_setup) echo<<<TILLEND
<script type='text/javascript'>
<!--
document.write("<input type='button' value='GPG Sign' onclick=\"window.open('../plugins/gpg/gpg_pop_init.php?MOD=sign_init','Secure_GPG_Signing','status=yes,width=300,height=200,resizable=yes')\"> ");
//-->
</script>
TILLEND;

   };
  };
};

/*********************************************************************/
/**
 *
 * $Log: setup.php,v $
 * Revision 1.32  2003/04/09 12:59:20  brian
 * single quote values in 'Encrypt Now' button
 *
 * Revision 1.31  2003/04/04 03:05:49  brian
 * added global $passed_id, $mailbox back into decrypt_link function -- needed for document.write
 *
 * Revision 1.30  2003/04/04 01:56:11  tyler
 * - added $uid_support to the sqimap_run_command query
 *
 * Revision 1.29  2003/04/04 00:09:48  brian
 * changed so that fetch_body function is called only once, so we only connect once to the imap stream
 *
 * Revision 1.28  2003/04/03 23:45:35  brian
 * changed check_sign and decrypt_link to use the standard SM core command of sqimap_run_command, rather that sqimap_read_data, becasue read_data didn't work the same under SM 1.4
 *
 * Revision 1.27  2003/04/03 02:32:22  brian
 * Decoupled signature verification and display of the decryption button.
 *
 * Revision 1.26  2003/04/02 12:25:42  brian
 * modified window.open function for decrypt to:
 * - make passphrase dialog smaller
 * - allow scrollbars
 *
 * Revision 1.25  2003/04/01 07:58:18  brian
 * corrected document .write link to work in SM 1.4
 *
 * Revision 1.24  2003/03/31 22:02:45  brian
 * modified _GET parameters for decrypt now button
 *
 * Revision 1.23  2003/03/31 21:57:31  brian
 * modified to add passed_value and mailbox to submit of decrypt now button
 *
 * Revision 1.22  2003/03/31 15:18:25  brian
 * modified gpg_decrypt_link function to use document,.write and window.open functions to create popup.
 *
 * Revision 1.21  2003/03/31 15:03:41  brian
 * - modified to remnove double declaration of gpg_check_sign
 * - file now correctly declares gpg_decrypt_link
 *
 * Revision 1.20  2003/03/31 14:57:38  brian
 * - modified signing link to use new gpg_pop_init.php file
 * - added link for decrypt now
 * - placed signing and decryption functions under read_body_header
 *   initialization function
 * Bug 8
 *
 * Revision 1.19  2003/03/25 21:43:23  brian
 * Bug 6
 * Slightly better handling of whether to display the buttons or not after encrypt.
 *
 * Revision 1.18  2003/03/17 18:55:41  brian
 * - progress towards SM v >=1.3.1 compatibility
 * - path selection for includes now works on both
 *   SM 1.2.x and SM >= 1.3.1
 *
 * Revision 1.17  2003/03/15 22:03:32  brian
 * moved strings.php include to outside of the SM version check
 * strings.php sets the SM version...
 *
 * Revision 1.16  2003/03/13 04:04:16  brian
 * modified GPG Sign button calling code.
 *
 * Revision 1.15  2003/03/12 15:00:16  brian
 * - added document action to change the document action after encrypting an email
 * - TODO make sure that it works even after unsuccessful submit
 * - TODO make syntax cross browser compatible
 *
 * Revision 1.14  2003/03/12 14:34:40  brian
 * - added function header comment blocks to all functions
 *
 * Revision 1.13  2003/03/12 05:02:58  tyler
 * - reduced the size of the message_sign popup window
 *
 * Revision 1.12  2003/03/12 01:43:58  tyler
 * - test for secring file now checks for zero length file
 *
 * Revision 1.11  2003/03/12 01:36:28  tyler
 * - Initial attempt at signature verification on read. New hook added.
 *
 * Revision 1.10  2003/03/11 21:25:18  tyler
 * - helps if you define $privatekeysallowed otherwise it's always 0 :)
 *
 * Revision 1.9  2003/03/11 19:22:08  tyler
 * - Modified to use $allowprivatekeys preference to decide if Sign button should be displayed
 *
 * Revision 1.8  2003/03/11 02:45:24  tyler
 * - modified code to only exclude encrypt now button after encryption routine
 *
 * Revision 1.7  2003/03/11 01:29:51  brian
 * fixed bug with pressing button twice by not showing buttons after the encryption routine has been run correctly
 *
 * Revision 1.6  2003/03/11 01:06:48  tyler
 * - renamed filename variable to pubring
 * - added secring variable
 * - rewrote the button building code to use document.write so folks with
 *   javascript turned off wont catch errors, buttons just wont get displayed
 * - rewrote the button building code to only display if ring file available
 * - converted 'Sign Now' button to 'GPG Sign' so as not to be confused with
 *   other "sign" buttons
 * - converted 'Encrypt Now' button to 'GPG Encrypt'
 * - converted code called by 'Sign Now' to pop a window
 *
 * Revision 1.5  2003/03/09 14:35:54  brian
 * Added Tyler's "Sign Now" button
 * TODO - only show button if user has a secret key
 *
 * Revision 1.4  2003/03/06 23:42:48  brian
 * Added check for SM ver > 1.3
 *
 * Revision 1.3  2003/02/26 17:07:55  brian
 * Added check so that the Encrypt Now button will only be displayed if the user has a keyring directory.
 *
 * Revision 1.2  2002/12/05 19:25:46  brian
 * Added ID and Log tags
 *
 *
 */

?>
