<?php
/**
 * options_main.mod
 * ----------------
 * GPG module
 * Copyright (c) 1999-2002 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Default page called when accessing GPG plugin options.
 *
 *  $Id: options_main.mod,v 1.15 2003/04/02 22:12:23 brian Exp $
 *
 * $Author: brian $
 * $Date: 2003/04/02 22:12:23 $
 */

/**
 * assume that system prefs and user prefs have already been loaded
 * we'll use variables from these to set the defaults
 *
 */

global $GPG_APP;
$msg = '<p>'
  . _("Please choose which GPG Plugin options you wish to set up:")
  . '</p>'
  . '<ul>'
  . '<li><a href="gpg_options.php?MOD=general">'
  . _("General Options about how the plugin works") . '</a></li>'
  . '<li><a href="gpg_options.php?MOD=trustedkey">'
  . _("Configure a Trusted Key ID - IMPORTANT") . '</a></li>'
  . '<li><a href="gpg_options.php?MOD=key">'
  . _("Import a gpg/pgp key or keyring to your server keyring") . '</a></li>'
  . '<li><a href="gpg_options.php?MOD=keyserver">'
  . _("Look up public key(s) on a keyserver") . '</a></li>'
  . '<li><a href="gpg_options.php?MOD=signingkey">'
  . _("Select a Signing key for signing messages") . '</a></li>';

/**
 * See if MCRYPT is available.
 * If so, check to see if the sysadmin has allowed private keyrings
 * and display the key management options.
 */
if (function_exists("mcrypt_generic")) {
  $msg .= '<li><a href="gpg_options.php?MOD=enc_setup">'
    . _("Private Key Management Text Here")
    . "</a></li>\n";
} else {
  $msg .= '<li>'
    . _("Private Key Management text here") . ' <em>('
    . _("not available") . ')</em></li>';
}

$msg .= '<p>'
  . '<li><a href="README.txt">'
  . _("View README file - includes Troubleshooting and contact information") . '</a></li>';

$msg .= "</ul>\n";

/**
 *
 * Before Calling gpg_makePage, add a link to save the preferences
 *
 * we may even want to put  a check in here to force a save if
 * options change before going to any other page
 *
 */


gpg_makePage( _("GPG Options Menu"), null, $msg);



/**
 * For Emacs weenies:
 * Local variables:
 * mode: php
 * End:
 */

/**
 *
 * $Log: options_main.mod,v $
 * Revision 1.15  2003/04/02 22:12:23  brian
 * fixed grammer error
 * Bug 18
 *
 * Revision 1.14  2003/04/02 20:48:39  brian
 * fixed spelling errors using aspell
 * TODO - check grammer and sentence structure manually
 * Bug 18
 *
 * Revision 1.13  2003/04/02 15:03:36  brian
 * fixed typo and removed public key reference from key upload link
 *
 * Revision 1.12  2003/04/02 14:39:02  brian
 * added README link to options screen
 *
 * Revision 1.11  2003/03/12 18:26:04  brian
 * rearranged and reworded items
 *
 * Revision 1.10  2003/03/12 03:57:58  tyler
 * - added signingkey.mod
 * - add the signingkey.mod to the options window
 * - converted gpgsign.mod to honor the preferences
 *
 * Revision 1.9  2003/02/22 20:11:40  brian
 * Fixed typo in option list
 *
 * Revision 1.8  2003/02/20 00:24:27  brian
 * added module link for trusted key id
 *
 * Revision 1.7  2003/01/24 16:49:22  brian
 * Fixed Typos
 *
 * Revision 1.6  2003/01/22 23:17:33  brian
 * Added general options link to main options  page.
 *
 * Revision 1.5  2002/12/06 19:43:18  brian
 * added keyring link to options page
 *
 * Revision 1.4  2002/12/05 21:11:33  brian
 * cleaned up template display and fixed $log entry, manually appended log history
 *
 *
 * ----------------------------
 * revision 1.3
 * date: 2002/12/05 20:28:09;  author: brian;  state: Exp;  lines: +26 -6
 * added comments to make more clear what the next steps are, cleaned up the formatting
 * ----------------------------
 * revision 1.2
 * date: 2002/12/05 19:51:48;  author: brian;  state: Exp;  lines: +10 -3
 * added log tag
 * ----------------------------
 * revision 1.1
 * date: 2002/12/05 16:47:55;  author: brian;  state: Exp;
 * branches:  1.1.1;
 * Initial revision
 * ----------------------------
 *
 */

?>
