<?php


/**
 * keyserver.mod
 * ----------------
 * GPG module
 * Copyright (c) 1999-2002 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Key Server lookup screen
 *
 *  $Id: keyserver.mod,v 1.14 2003/04/07 22:21:59 brian Exp $
 *
 * $Author: brian $
 * $Date: 2003/04/07 22:21:59 $
 */

//make the global $debug setting available here
global $debug;

$GPG_DIR="gpg";
if (file_exists('gpg_key_functions.php')){
	require_once('gpg_key_functions.php');
} elseif (file_exists('../gpg_key_functions.php')){
    require_once('../gpg_key_functions.php');
} elseif (file_exists('../plugins/gpg/gpg_key_functions.php')){
    require_once('../plugins/gpg/gpg_key_functions.php');
} else echo "include file not found, exiting abnormally";

//extract necessary variables from the $_POST
$search = $_POST['search'];
$keyID  = $_POST['keyID'];

if (!$search and !$keyID) {
	$id=0;
	$msg =  '<p>'
	  . '<FORM METHOD="POST">'
	  . '<input type="hidden" name="MAX_FILE_SIZE" value="100000">'
	  . '<input type="hidden" name="MOD" value="keyserver" >'
	  . _("Choose your Default Keyserver")
	  . '<select name=keyserver>';

        $defaultkeyserver = getPref($data_dir,$username,'keyserver');
        if ($defaultkeyserver)
        $msg .= "<option value=$defaultkeyserver>$defaultkeyserver</option>\n";

        for ($i = 0; $i < $GLOBALS['GPG_SYSTEM_OPTIONS']['keyservers']; $i++) {
                $keyserver = $GLOBALS['GPG_SYSTEM_OPTIONS']['keyserver' . $i];
        	$msg .= "<option value=$keyserver>$keyserver</option>\n";
    	};

	$msg .= '</select>'
	  . '<input type=checkbox name=default value=1>'
	  . 'Make this my default keyserver'
 	  . '<hr>'
	  . _("Enter Search text below to search for a key to import")
	  . _("<br>search text may be an email id or a G/PGP KeyID")
	  . '<FORM METHOD="POST">'
	  . '<BR><INPUT TYPE=TEXT NAME="search_keyid" size=60>'
          . '<input type=hidden name=search value=1>'
	  . '<br><input name=search type=submit value="Go">'
	  . '</form>';

	gpg_makePage( _("Keyserver Options"), null, $msg);
	exit();
}

if ($search) {
   //extract necessary variables from the $_POST
   $keyserver    = $_POST['keyserver'];
   $default      = $_POST['default'];
   $search_keyid = $_POST['search_keyid'];
   $msg='';
   if ($default) {
      setPref($data_dir,$username,'keyserver',$keyserver);
      $msg .= "Default Keyserver set to: $keyserver";
   };

      $default_keyserver = getPref($data_dir,$username,'keyserver',$keyserver);
      if ($debug) {
         echo "Using keyserver: $keyserver<br>";
      };
	$msg .= '<p>'
	  . '<input type="hidden" name="MAX_FILE_SIZE" value="100000">'
	  . '<input type="hidden" name="MOD" value="keyserver" >';
        $msg .= "<br>Default Keyserver: $default_keyserver";
        $msg .= "<br>Using Keyserver: $keyserver<hr>";

	if ($search_keyid!="") {
		$foundkeys = array();
		$foundkeys = gpg_keyserver_findkey($search_keyid,$debug);
ob_start();
echo '<FORM METHOD="POST">';
echo "<input type=\"hidden\" name=\"keyserver\" value=\"$keyserver\">";
echo "<table border=0> ";
foreach ($foundkeys as $keyID) {
echo '<tr>',
'<td>', $keyID['lastkey'], '</td>',
'<td>', $keyID['tmpname'], '</td>',
'<td>', $keyID['tmpemail'], '</td>',
'<td><input type=radio name=keyID value=', $keyID['lastkey'], '>', $keyID['lastkey'], '</td>',
'<td>', $keyID['lastdate'], '</td></tr>';
};
echo "</table><input  name=loadkey type=submit value='Go'></form>";
$msg .= ob_get_contents();
ob_end_clean();
	};

	gpg_makePage( _("Choose a Key to Import"), null, $msg);
  	exit();
};

if ($keyID) {
  if ($debug){
     echo "Using keyserver: $keyserver";
  };
  $msg .= '<br>Importing key with KeyID: ' . $keyID;

  $return = gpg_recv_key($keyID,$debug,$keyserver);
  $msg .= "<BR> $return";

  gpg_makePage( _("Import Key"), null, $msg);
};

/**
 *
 * $Log: keyserver.mod,v $
 * Revision 1.14  2003/04/07 22:21:59  brian
 * modified files to not use extract $_POST
 * Bug 5
 *
 * Revision 1.13  2003/04/02 20:48:39  brian
 * fixed spelling errors using aspell
 * TODO - check grammer and sentence structure manually
 * Bug 18
 *
 * Revision 1.12  2003/04/01 18:04:06  brian
 * fixed includes to reflect different calling directories
 *
 * Revision 1.11  2003/03/12 22:14:12  tyler
 * - default keyserver now only used to pre-pick your preferred keyserver
 * - you can pick a different keyserver to search on the fly
 *
 * Revision 1.10  2003/03/12 21:59:26  tyler
 * - Fixed a bug where you could not have a default keyserver set yet still
 * - be able to search, but results would be unusable on later screens for
 * - input. Now you can search without a default and still import.
 *
 * Revision 1.9  2003/03/12 02:01:18  tyler
 * - $key looks to be set as a global so changed it to $keyID
 *
 * Revision 1.8  2003/03/11 23:29:15  tyler
 * - modified to use the new broken out *_function.php files
 *
 * Revision 1.7  2003/03/07 15:54:40  brian
 * Removed enctype=multipart/form-data - not needed for this form
 *
 * Revision 1.6  2003/03/07 00:10:39  brian
 * Removed superfluous includes.
 *
 * Revision 1.5  2002/12/10 21:52:27  vinay
 * now can fetch keys from keyservers
 *
 * Revision 1.4  2002/12/10 14:33:37  brian
 * edited to use global \$debug, rather than a local code
 *
 * Revision 1.3  2002/12/09 03:48:59  vinay
 * added support for system preferences
 *
 * Revision 1.2  2002/12/06 22:32:13  vinay
 * initial revision +1
 *
 * Revision 1.1  2002/12/06 22:30:20  vinay
 * initial revision
 *
 *
 *
 */

?>
