/**
 * gpgsign_init.js
 * GPG plugin message signing javascript
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * Initial Author: Tyler Allison
 * $Id: gpgsign_init.js,v 1.4 2003/03/28 13:44:51 brian Exp $
 *
 */

function gpg_placeFocus() {
   if (document.forms.length > 0) {
      var field = document.forms[0];
      for (i = 0; i < field.length; i++) {
         if (field.elements[i].type == "password") {
              document.forms[0].elements[i].focus();
              break;
         }
      }
   }
}


function gpg_pop_init(){
  bodyText = opener.document.forms[0].body.value;
  document.forms[0].body_text.value = bodyText;
}

function gpg_pop_submit () {
  bodyText = opener.document.forms[0].body.value;
  document.forms[0].body_text.value = bodyText;
  document.forms[0].submit();
}

/*
 * $Log: gpgsign_init.js,v $
 * Revision 1.4  2003/03/28 13:44:51  brian
 * - changed functions from gpgsignsubmit and gpgsigninit to
 *   gpg_pop_init and gpg_pop_submit
 *   to better abstract them for use in decryption
 * - manually added header block and Log: entries to file
 * Bug 8
 *
 *
 * Manually added log entries
 *
 * Revision : 1.3
 * Date : 2003/3/14 0:55:2
 * Author : 'tyler'
 * - added the placeFocus() function
 * 
 * Revision : 1.2
 * Date : 2003/3/13 4:7:42
 * Author : 'brian'
 * - modified to correctly accept passphrase for message signing
 * - added function which does not autosubmit,
 *   this function is called when the signing key needs a passphrase.
 * 
 * Revision : 1.1
 * Date : 2003/3/11 4:14:36
 * Author : 'tyler'
 * - javascript function we use to grab body off of compose.php and stick it
 *   into a form, and then submit it to a php for processing
 */