<?php
/**
 * gpg_encrypt.php
 * --------------------
 * Called from compose to encrypt a message.
 *
 * Copyright (c) 1999-2002 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002 Braverock Ventures
 *
 * $Id: gpg_encrypt.php,v 1.23 2003/04/07 01:42:57 brian Exp $
 *
 */
$no_encrypt_on_setup = 0;
$chdir_first = 0;

// load the functions files
require_once('./gpg_encrypt_functions.php');
require_once('./gpg_functions.php');

/*
 * Let's assume that we get the followign from a submit
 *        <INPUT TYPE=text NAME="send_to"
 *        <INPUT TYPE=text NAME="send_to_cc"
 *        <INPUT TYPE=text NAME="send_to_bcc"
 *        <INPUT TYPE=text NAME=subject
 *        <TEXTAREA NAME=body
 *
 * All of these fields are in the compose.php page.
 * Double check that they haven't changed in SM v1.4
 *
 */
global $body;
global $subject;
$body = $_POST['body'];
$form = $_POST['form'];
$send_to = $_POST['send_to'];
$send_to_cc = $_POST['send_to_cc'];
$send_to_bcc = $_POST['send_to_bcc'];
$subject = $_POST['subject'];

if ($form) {

    //call the address parsing function to return an array of addresses
    $valid_addresses = gpg_parse_address ($send_to, $send_to_cc, $send_to_bcc, $debug);

	// create the recipientlist string from the $valid_addresses array
	$recipientlist = join (" -r ", $valid_addresses);
	$recipientlist = $recipientlist;

	if ($debug){
		echo "<br>Parsed Recipient List";
		echo "<br>Recipient List: $recipientlist";
	};

	//call gpg_encrypt with the recipient list
	$return = gpg_encrypt($body, $recipientlist ,$debug);
	$cyphertext=$return['cyphertext'];
	if ($debug) {
		echo '<hr><br>Cyphertext after return from gpg_encrypt function';
		echo '<pre>'.$cyphertext.'</pre>';
	};

	$notclean=0;
	$serious=0;
	//echo the errors and warning to this page before continuing.
        foreach ($return['warnings'] as $warning) {
    		$notclean=1;
    		echo "<br>Warnings $warning";
		};
        foreach ($return['errors'] as $errors) {
    		$notclean=1;
    		$serious=1;
	        echo "<br>Errors $errors";
		};
        $already_printed = 0;
        foreach ($return['skipped_keys'] as $errors) {
    		$notclean=1;
    		if (!$already_printed) {
          		echo '<br>You do not have a public key for the following email addresses and so your message will NOT be readable by these recipients.';
          		echo '<br>Here are the keys which GPG reported as missing:<br>';
            	$already_printed = 1;
    	  	};
          echo "<br> $errors";
	    };

	/* if we have an error, gpg probably didn't create the cyphertext.
	 * we need to return gracefully back to the compose page with the plaintext
	 * intact.
     *
     * We should probably also always check to make sure that the cyphertext
     * has something in it. (not just the -----Begin... line that we insert)
     * if the cyphertext is empty we should display an error and return the plaintext.
     */
	if (!$cyphertext) {
		$serious = 1;
		if ($debug){
			echo "<br>Cyphertext is empty, setting serious to 1 to preserve plaintext";
		};
	};


    // put in the link to take us back to compose
    // fix this so that it uses a button (submit?)to call the compose page
    // check the session for the base url to call to form the response page link.
    if (isset($_SESSION['base_uri'])) {
	        $base_uri = $_SESSION['base_uri'];
	    }
	    else {
	        global $base_uri;
    };

	if ($debug){
		echo "<br>Clean Flag   =" .$notclean;
		echo "<br>Serious Flag =" .$serious;
	};

	//set our variables before returning
	//gpg_setglobal ($label, $value);
	gpg_setglobal ('subject' ,$subject);
	gpg_setglobal ('action' ,'');
	gpg_setglobal ('smaction' ,'');
	gpg_setglobal ('passed_id' ,'');
	gpg_setglobal ('reply_id' ,'');
	//set the body to be the cyphertext
	gpg_setglobal ('body' ,$cyphertext);
	

	if ($notclean){
		if ($serious){
			//make sure the buttons will display on the compose page.
			$no_encrypt_on_setup = 1;
			$chdir_first = 0;
			echo "<br>Cyphertext is empty due to errors. Your plaintext has been preserved.<br>";
			//preserve the plaintext
			gpg_setglobal ('body' ,$body);
		    //then include compose.php
		    if (file_exists('../src/compose.php')){
		        include('../src/compose.php'); exit;
		    } elseif (file_exists('../../src/compose.php')) {
		        include('../../src/compose.php'); exit;
		    };
	    } else {
			//turn off the encrypt and sign buttons.
			$no_encrypt_on_setup = 1;
		    //then include compose.php
		    if (file_exists('../src/compose.php')){
		        include('../src/compose.php'); exit;
		    } elseif (file_exists('../../src/compose.php')) {
		        include('../../src/compose.php'); exit;
		    };
		};

	};

    /*
     * If the $notclean flag isn't set, we should return directly
     * to the compose page with the cyphertext.
     */

    // turn off the encrypt and sign buttons on the compose page.
    $no_encrypt_on_setup = 1;

    //then include compose.php
    if (file_exists('../src/compose.php')){
        include('../src/compose.php'); exit;
    } elseif (file_exists('../../src/compose.php')) {
        include('../../src/compose.php'); exit;
    } else echo '<br>Unable to include compose page, Exiting Abnormally.';

};
/**
 *
 * $Log: gpg_encrypt.php,v $
 * Revision 1.23  2003/04/07 01:42:57  brian
 * modified to clear sm global variable reply_id for SM 1.2.x compatibility on Encrypt on Reply
 * Bug 22
 *
 * Revision 1.22  2003/04/06 23:32:45  brian
 * added steglobal to clear passed_id
 * Bug 21
 *
 * Revision 1.21  2003/04/06 20:47:47  brian
 * - create gpg_setglobal to get around SM's getglobal function
 * - update gpg_encrypt to use ne gpg_setglobal function
 * Bug 22
 *
 * Revision 1.20  2003/04/06 18:37:01  brian
 * - set to modify global $body, $subject
 *
 * Revision 1.19  2003/04/06 17:58:33  brian
 * - improve $debug formatting
 * - set _POST action and smaction to '' (null) to clear compose.php special processing.
 *
 * Revision 1.18  2003/04/06 17:53:25  brian
 * - improve $debug formatting
 * - set _POST action and smaction to '' (null) to clear compose.php special processing.
 *
 * Revision 1.17  2003/04/02 13:31:00  brian
 * modified to extract only the variables we need from $_POST
 * Bug 5
 *
 * Revision 1.16  2003/03/25 17:57:53  brian
 * Bug 6
 * Slightly better handling of whether to display the buttons or not after encrypt.
 *
 * Revision 1.15  2003/03/17 18:56:56  brian
 * - progress towards SM v >=1.3.1 compatibility
 * - path selection for includes now works on both
 *   SM 1.2.x and SM >= 1.3.1
 *
 * Revision 1.14  2003/03/15 20:51:04  brian
 * changed to call gpg_parse_address function
 *
 * Revision 1.13  2003/03/11 23:29:15  tyler
 * - modified to use the new broken out *_function.php files
 *
 * Revision 1.12  2003/03/11 02:45:50  tyler
 * - modified code to only exclude encrypt now button after encryption routine
 *
 * Revision 1.11  2003/03/11 01:14:25  brian
 * Fixed inclusion of compose.php so that it:
 *  - correctly sets the $body varialbe in $_POST before including
 *  - chooses correctly between plaintext and cyphertext return
 *  - sets up to handle button display correctly
 *
 * Revision 1.10  2003/03/10 23:01:34  brian
 * Fixed comments to be more descriptive.
 *
 * Revision 1.9  2003/03/09 17:02:04  brian
 * Reintegrate code to include compose php page
 * Removes problems with long cyphertext.
 * Still needs to be cleaned up to improve integration.
 *
 * Revision 1.8  2003/01/07 12:52:07  brian
 * Updated errors handling if encrypt generates warnings or errors to give the user more choices.
 *
 * Revision 1.7  2003/01/05 21:53:58  brian
 * tweaked redirect to compose without creating intermediary page if there are no errors.
 *
 * Revision 1.6  2003/01/05 18:46:46  brian
 * Changed to redirect to compose without creating intermediary page if there are no errors.
 *
 * Revision 1.5  2003/01/05 15:07:23  brian
 * fixed usage of the error arrays
 *
 * Revision 1.4  2002/12/10 03:31:40  brian
 * added file header block and cvs log tag
 *
 *
 * Revision 1.2  2002/12/10 02:29:08  brian
 * removed references to gpg_set variables, it has been deprecated
 *
 * Revision 1.1  2002/12/05 16:47:55  brian
 * Initial revision
 *
 */

?>
