<?php

  /* SquirrelMail gotmail (HotMail fetcher) plugin
   *
   * Copyright (c) 1999-2003 The SquirrelMail Project Team
   * Licensed under the GNU GPL. For full terms see the file COPYING.
   *
   * This is my first attempt at a plugin.  I wanted a way to fetch
   * my hotmail so I'd only need one interface.  Of course I don't
   * like to reinvent the wheel so this just gets options for gotmail
   * and runs gotmail with cmd line params to fetch the mail.  Kinda
   * hackish but it's better then parsing and ever changing interface
   * coded by M$ techs.
   */

  define('SM_PATH','../../');

  require_once(SM_PATH . 'include/validate.php');
  require_once(SM_PATH . 'functions/page_header.php');
  require_once(SM_PATH . 'include/load_prefs.php');
  require_once(SM_PATH . 'plugins/got_hotmail/functions.php');

  /* globals */
  if(isset($_POST['gm_number'])) {
    $gm_number = $_POST['gm_number'];
  }
  if(isset($_POST['gm_only_new'])) {
    $gm_only_new = $_POST['gm_only_new'];
  }
  if(isset($_POST['gm_mark_read'])) {
    $gm_mark_read = $_POST['gm_mark_read'];
  }
  if(isset($_POST['gm_delete'])) {
    $gm_delete = $_POST['gm_delete'];
  }
  if(isset($_POST['gm_folder_list'])) {
    $gm_folder_list = $_POST['gm_folder_list'];
  }
  if(isset($_POST['gm_username'])) {
    $gm_username = $_POST['gm_username'];
  }
  if(isset($_POST['gm_password'])) {
    $gm_password = $_POST['gm_password'];
  }
  if(isset($_POST['gm_domain'])) {
    $gm_domain = $_POST['gm_domain'];
  }
  if(isset($_POST['gm_forward'])) {
    $gm_forward = $_POST['gm_forward'];
  }
  if(isset($_POST['gm_cklogin'])) {
    $gm_cklogin = $_POST['gm_cklogin'];
  }
  if(isset($_POST['gm_ckfolder'])) {
    $gm_ckfolder = $_POST['gm_ckfolder'];
  }
  if(isset($_POST['submit_got_hotmail'])) {
    $submit_got_hotmail = $_POST['submit_got_hotmail'];
  }
  /* end globals */

  displayPageHeader($color, 'None');

  //if dosen't select any option
  if(!isset($_POST['gm_action'])) {
    $gm_action = 'config';
  } else {
    $gm_action = $_POST['gm_action'];
  }

  switch($gm_action) {
  case 'add':
    // can't have a negative here
    if ($gm_number < 1) $gm_number=0;
    // check required fields
    if (!isset($gm_username)) return;
    if (!isset($gm_forward)) return;
    setPref($data_dir,$username,"gm_only_new$gm_number",
            (isset($gm_only_new)?$gm_only_new:"off"));
    setPref($data_dir,$username,"gm_mark_read$gm_number",
            (isset($gm_mark_read)?$gm_mark_read:"off"));
    setPref($data_dir,$username,"gm_delete$gm_number",
            (isset($gm_delete)?$gm_delete:"off"));
    setPref($data_dir,$username,"gm_folder_list$gm_number",
            (isset($gm_folder_list)?$gm_folder_list:"Inbox"));
    setPref($data_dir,$username,"gm_username$gm_number",
            (isset($gm_username)?$gm_username:""));
    setPref($data_dir,$username,"gm_password$gm_number",
            (isset($gm_password)?gm_encrypt($gm_password):""));
    setPref($data_dir,$username,"gm_domain$gm_number",
            (isset($gm_domain)?$gm_domain:"hotmail.com"));
    setPref($data_dir,$username,"gm_forward$gm_number",
            (isset($gm_forward)?$gm_forward:""));
    setPref($data_dir,$username,"gm_cklogin$gm_number",
            (isset($gm_cklogin)?$gm_cklogin:"off"));
    setPref($data_dir,$username,"gm_ckfolder$gm_number",
           (isset($gm_ckfolder)?$gm_ckfolder:"off"));
    $gm_number++;
    setPref($data_dir,$username,'gm_number', $gm_number);
    $gm_action = 'config';
    break;
  // apply changes to an account
  case 'confirm_modify':
    // check required fields
    if (!isset($gm_username)) return;
    if (!isset($gm_forward)) return;
    setPref($data_dir,$username,"gm_only_new$gm_number",
            (isset($gm_only_new)?$gm_only_new:"off"));
    setPref($data_dir,$username,"gm_mark_read$gm_number",
            (isset($gm_mark_read)?$gm_mark_read:"off"));
    setPref($data_dir,$username,"gm_delete$gm_number",
            (isset($gm_delete)?$gm_delete:"off"));
    setPref($data_dir,$username,"gm_folder_list$gm_number",
            (isset($gm_folder_list)?$gm_folder_list:"Inbox"));
    setPref($data_dir,$username,"gm_username$gm_number",
            (isset($gm_username)?$gm_username:""));
    setPref($data_dir,$username,"gm_password$gm_number",
            (isset($gm_password)?gm_encrypt($gm_password):""));
    setPref($data_dir,$username,"gm_domain$gm_number",
            (isset($gm_domain)?$gm_domain:"hotmail.com"));
    setPref($data_dir,$username,"gm_forward$gm_number",
            (isset($gm_forward)?$gm_forward:""));
    setPref($data_dir,$username,"gm_cklogin$gm_number",
            (isset($gm_cklogin)?$gm_cklogin:"off"));
    setPref($data_dir,$username,"gm_ckfolder$gm_number",
            (isset($gm_ckfolder)?$gm_ckfolder:"off"));
    $gm_action = 'config';
    break;
  // delete an account
  case 'confirm_delete':
    $gm_c_number = getPref($data_dir, $username, "gm_number");
    if($gm_number+1 == $gm_c_number) {
      // if the last entry, then backup
      $gm_c_number--;
      setPref($data_dir,$username,"gm_number", $gm_c_number);
    } else {
      // else, start to renumber the other accounts
      $gm_c_number--;
      for ($i = $gm_number; $i < $gm_c_number; $i++) {
        $tmp = $i+1;
        setPref($data_dir,$username,"gm_only_new$i",
          getPref($data_dir, $username, "gm_only_new$tmp"));
        setPref($data_dir,$username,"gm_mark_read$i",
          getPref($data_dir,$username, "gm_mark_read$tmp"));
        setPref($data_dir,$username,"gm_delete$i",
          getPref($data_dir, $username, "gm_delete$tmp"));
        setPref($data_dir,$username,"gm_folder_list$i",
          getPref($data_dir, $username, "gm_folder_list$tmp"));
        setPref($data_dir,$username,"gm_username$i",
          getPref($data_dir, $username, "gm_username$tmp"));
        setPref($data_dir,$username,"gm_password$i",
          (isset($gm_password)?gm_encrypt($gm_password):""));
        setPref($data_dir,$username,"gm_domain$i",
          getPref($data_dir, $username, "gm_domain$tmp"));
        setPref($data_dir,$username,"gm_forward$i",
          getPref($data_dir, $username, "gm_forward$tmp"));
        setPref($data_dir,$username,"gm_cklogin$i",
          getPref($data_dir, $username, "gm_cklogin$tmp"));
        setPref($data_dir,$username,"gm_ckfolder$i",
          getPref($data_dir, $username, "gm_ckfolder$tmp"));
      }
      setPref($data_dir,$username,"gm_number", $gm_c_number);
    }
    $gm_action = 'config';
    break;
  }

  // display start
  $gm_c_number = getPref($data_dir, $username, 'gm_number', 0);
  // can't have a negative here
  if ($gm_c_number < 1) {
    $gm_c_number=0;
  }
  // get list of accounts
  for ($i = 0; $i < $gm_c_number; $i++) {
    $gm_only_new[$i]	= getPref($data_dir, $username, "gm_only_new$i");
    $gm_mark_read[$i]	= getPref($data_dir, $username, "gm_mark_read$i");
    $gm_delete[$i]	= getPref($data_dir, $username, "gm_delete$i");
    $gm_folder_list[$i]	= getPref($data_dir, $username, "gm_folder_list$i");
    $gm_username[$i]	= getPref($data_dir, $username, "gm_username$i");
    $gm_password[$i]	= getPref($data_dir, $username, "gm_password$i");
    $gm_domain[$i]	= getPref($data_dir, $username, "gm_domain$i");
    $gm_forward[$i]     = getPref($data_dir, $username, "gm_forward$i");
    $gm_cklogin[$i]     = getPref($data_dir, $username, "gm_cklogin$i");
    $gm_ckfolder[$i]    = getPref($data_dir, $username, "gm_ckfolder$i");
    // decrypt password
    $gm_password[$i]	= gm_decrypt($gm_password[$i]);
  }


  echo '<BR><form method=post action="'.$PHP_SELF.'">' .
    html_tag( 'table',
      html_tag( 'tr',
        html_tag( 'td',
          '<b>' . _("Got HotMail account settings") . '</b>',
          'center', $color[0] )
      ),
    'center', '', 'width="95%" cols="1"' ) .
    html_tag( 'table',
      html_tag( 'tr',
        html_tag( 'td',
          _("You should be aware that the encryption used to store your " .
            "password is not perfectly secure.  Additionally, the " .
            "encryption that we do to save it on the server can be undone " .
            "by a hacker reading the source to this file." ) ,
          'left' )
      ) .
      html_tag( 'tr',
        html_tag( 'td',
          _("If you leave password empty, it will be required when " .
            "SquirrelMail  tries to fetch your Hotmail.") ,
          'left' )
      ) ,
    'center', '', 'width="95%" cols="1"' );
 
    switch($gm_action) {
    case 'config':
      echo html_tag( 'table', '', 'center', '',
                     'width="70%" cols="1" cellpadding="5" cellspacing="1"' ) .
        html_tag( 'tr',
          html_tag( 'td', '<b>' . _("Add Account") .
                    '</b>', 'center', $color[9] )
        ) .
        html_tag( 'tr' ) .
          html_tag( 'td', '', 'center', $color[0] ) .
            "<INPUT TYPE=\"hidden\" NAME=\"gm_number\" VALUE=\"$gm_c_number\">" .
            '<INPUT TYPE="hidden" NAME="gm_action" VALUE="add">' .
            html_tag( 'table' ) .
              html_tag( 'tr',
                html_tag( 'th', _("Account:"), 'right' ) .
                html_tag( 'td', '<input type=text name=gm_username value="" size=20>@<select name=gm_domain><option value="hotmail.com" selected>hotmail.com<option value="msn.com">msn.com</select>', 'left' )
              ) .
              html_tag( 'tr',
                html_tag( 'th', _("Password:"), 'right' ) .
                html_tag( 'td', '<input type=password name=gm_password value="" size=20>', 'left' )
              ) .
              html_tag( 'tr',
                html_tag( 'th', _("Account to send mail to:"), 'right' ) .
                html_tag( 'td', '<input type=text name=gm_forward value="" size=20>', 'left' )
              ) .
              html_tag( 'tr',
                html_tag( 'th', _("Folders:"), 'right' ) .
                html_tag( 'td', '<input type=text name=gm_folder_list value="Inbox" size=20>', 'left' )
              ) .
              html_tag( 'tr',
                html_tag( 'th', "&nbsp;", 'right' ) .
                html_tag( 'td', 'Comma delimeter list without spaces <b>ie.</b> (Inbox,Sent,foo)', 'left' )
              ).
              html_tag( 'tr',
                html_tag( 'th', "&nbsp;", 'right' ) .
                html_tag( 'td', '<input type="checkbox" name="gm_delete">' . _("Delete from Hotmail after pick up"), 'left' )
              ) .
              html_tag( 'tr',
                html_tag( 'th', "&nbsp;", 'right' ) .
                html_tag( 'td', '<input type="checkbox" name="gm_mark_read">' . _("Mark as read on Hotmail after pick up"), 'left' )
              ) .
              html_tag( 'tr',
                html_tag( 'th', "&nbsp;", 'right' ) .
                html_tag( 'td', '<input type="checkbox" name="gm_only_new" checked>' . _("Pick up only new mail from Hotmail"), 'left' )
              ) .
              html_tag( 'tr',
                html_tag( 'th', "&nbsp;", 'right' ) .
                html_tag( 'td', '<input type="checkbox" name="gm_cklogin" checked>' . _("Check this account for mail at login"), 'left' )
              ) .
              html_tag( 'tr',
                html_tag( 'th', "&nbsp;", 'right' ) .
                html_tag( 'td', '<input type="checkbox" name="gm_ckfolder" checked>' . _("Check this account for mail during folder refresh"), 'left' )
              ) .
              html_tag( 'tr',
                html_tag( 'td',
                  '<input type=submit name="submit_got_hotmail" value="' . _("Add Account") . '">',
                  'center', '', 'colspan="2"' )
              ) .
        '</table></form></td></tr></table>';

        // Modify Account area of Add Account display
        echo '<font size=-5><BR></font>' .
          html_tag( 'table', '', 'center', '', 'width="70%" cols="1" cellpadding="5" cellspacing="1"' ) .
            html_tag( 'tr',
              html_tag( 'td', '<b>' . _("Modify Account") . '</b>', 'center', $color[9] )
              ) .
              html_tag( 'tr' ) .
                html_tag( 'td', '', 'center', $color[0] );
                  if ($gm_c_number > 0) {
                    echo "<form action=\"$PHP_SELF\" method=\"post\" target=\"_self\">";
                    echo '<b>' . _("Account:") . '</b> <select name="gm_number">';
                    for ($i = 0; $i < $gm_c_number; $i++) {
                      echo "<option value=\"$i\">" .
                        htmlspecialchars(getPref($data_dir, $username, "gm_username$i")."@".getPref($data_dir, $username, "gm_domain$i"));
                    }
                    echo '</select>'.
                    '&nbsp;&nbsp;<INPUT TYPE=submit name=gm_action value="' . _("Modify") . '">'.
                    '&nbsp;&nbsp;<INPUT TYPE=submit name=gm_action value="' . _("Delete") . '">'.
                    '</form>';
                  } else {
            echo _("No accounts in use. Try adding.");
        }
        echo '</td></tr></table>';
        break;
    // Remove an Account
    case _("Delete"):
      echo html_tag( 'table',
        html_tag( 'tr',
          html_tag( 'td', '<b>' . _("Retreving Accounts") . '</b>', 'center', $color[0] )
        ) ,
      'center', '', 'width="95%" cols="1" cellpadding="5" cellspacing="1"' ) .
      '<br>' .
      html_tag( 'table',
        html_tag( 'tr',
          html_tag( 'td', '<b>' . _("Confirm Deletion of an Account") . '</b>', 'center', $color[9] )
        ) .
        html_tag( 'tr',
          html_tag( 'td',
            "<INPUT TYPE=\"hidden\" NAME=\"gm_number\" VALUE=\"$gm_number\">" .
            '<INPUT TYPE="hidden" NAME="gm_action" VALUE="confirm_delete">' .
            '<br>' . _("Selected Account:") . " <b>" . htmlentities($gm_username[$gm_number]."@".$gm_domain[$gm_number]) . "</b><br>" .
            _("Confirm deletion of selected account?") . '<br><br>' .
            '<input type=submit name=submit_got_hotmail value="' . _("Confirm Delete") . '">' .
            '<br></form>' ,
          'center', $color[9] )
        ) ,
      'center', '', 'width="70%" cols="1" cellpadding="5" cellspacing="1"' );
      break;
    // Modify an Account
    case _("Modify"):
      echo html_tag( 'table',
        html_tag( 'tr',
          html_tag( 'td', '<b>' . _("Retreving Accounts") . '</b>', 'center', $color[0] )
        ) ,
      'center', '', 'width="95%" cols="1" cellpadding="5" cellspacing="1"' ) .
      '<br>' .
      html_tag( 'table', '', 'center', '', 'width="70%" cols="1" cellpadding="5" cellspacing="1"' ) .
        html_tag( 'tr',
          html_tag( 'td', '<b>' . _("Modify an Account") . '</b>', 'center', $color[9] )
        ) .
        html_tag( 'tr' ) .
          html_tag( 'td', '', 'center', $color[0] ) .
            "<INPUT TYPE=\"hidden\" NAME=\"gm_number\" VALUE=\"$gm_number\">" .
            '<INPUT TYPE="hidden" NAME="gm_action" VALUE="confirm_modify">' .
            html_tag( 'table' ) .
               html_tag( 'tr' ) .
                 html_tag( 'th', _("Account:"), 'right' ) .
                 html_tag( 'td', '', 'left' );
                 echo '<input type="text" name="gm_username" value="' . htmlentities($gm_username[$gm_number]) . '" size="20">@<select name=gm_domain>';
                 $selected = $gm_domain[$gm_number];
                 if($selected == 'msn.com') {
                   echo '<option value="hotmail.com">hotmail.com';
		   echo '<option value="msn.com" selected>msn.com';
                 } else {
		   echo '<option value="hotmail.com" selected>hotmail.com';
		   echo '<option value="msn.com">msn.com';
                 }
                 echo '</select></td></tr>'.
               html_tag( 'tr',
                 html_tag( 'th', _("Password:"), 'right' ) .
                 html_tag( 'td', '<input type="password" name="gm_password" value="' . htmlentities($gm_password[$gm_number]) . '" size="20">', 'left' )
               ) .
               html_tag( 'tr',
                 html_tag( 'th', _("Account to send mail to:"), 'right' ) .
                 html_tag( 'td', '<input type="text" name="gm_forward" value="' . htmlentities($gm_forward[$gm_number]) . '" size="20">', 'left' )
               ) .
               html_tag( 'tr',
                 html_tag( 'th', _("Folders:"), 'right' ) .
                 html_tag( 'td', '<input type="text" name="gm_folder_list" value="' . htmlentities($gm_folder_list[$gm_number]) . '" size="20">', 'left' )
               ) .
               html_tag( 'tr',
                 html_tag( 'th', "&nbsp;", 'right' ) .
                 html_tag( 'td', 'Comma delimeter list without spaces <b>ie.</b> (Inbox,Sent,foo)', 'left' )
               ).
               html_tag( 'tr',
                 html_tag( 'th', "&nbsp;", 'right' ) .
                 html_tag( 'td',
                   '<input type=checkbox name=gm_delete ' . (($gm_delete[$gm_number] == 'on')?'checked':'') .
		   '>' . _("Delete from Hotmail after pick up") ,
                   'left' )
               ) .
               html_tag( 'tr',
                 html_tag( 'th', "&nbsp;", 'right' ) .
                 html_tag( 'td',
                   '<input type=checkbox name=gm_mark_read ' . (($gm_mark_read[$gm_number] == 'on')?'checked':'') .
                   '>' . _("Mark as read on Hotmail after pick up") ,
                   'left' )
               ) .
               html_tag( 'tr',
                 html_tag( 'th', "&nbsp;", 'right' ) .
                 html_tag( 'td',
                   '<input type=checkbox name=gm_only_new ' . (($gm_only_new[$gm_number] == 'on')?'checked':'') .
                   '>' . _("Pick up only new mail from Hotmail") ,
                   'left' )
               ) .
               html_tag( 'tr',
                 html_tag( 'th', "&nbsp;", 'right' ) .
                 html_tag( 'td',
                   '<input type=checkbox name=gm_cklogin ' . (($gm_cklogin[$gm_number] == 'on')?'checked':'') .
                   '>' . _("Check this account for mail at login") ,
                   'left' )
               ) .
               html_tag( 'tr',
                 html_tag( 'th', "&nbsp;", 'right' ) .
                 html_tag( 'td',
                   '<input type=checkbox name=gm_ckfolder ' . (($gm_ckfolder[$gm_number] == 'on')?'checked':'') .
                   '>' . _("Check this account for mail during folder refresh") ,
                   'left' )
               ) .
               html_tag( 'tr',
                 html_tag( 'td',
                   '<input type=submit name="submit_got_hotmail" value="' . _("Modify Account") . '">',
                 'center', '', 'colspan="2"' )
               ) .
            '</table></form></td></tr></table>';
        break;
    // anything else
    default:
      echo '</form>' .
      html_tag( 'table',
        html_tag( 'tr',
          html_tag( 'td', '<b>' . _("Retreving Accounts") . '</b>', 'center', $color[0] )
        ) ,
      'center', '', 'width="95%" cols="1"' ) .
      '<br>' .
      html_tag( 'table',
        html_tag( 'tr',
          html_tag( 'td', '<b>' . _("Undefined Function") . '</b>', 'center', $color[9] ) .
          html_tag( 'td', '<b>' . _("Something went wrong!!  Women and children first!!  Abandon SHIP!!!") . '</b>', 'center', $color[0] )
        ) ,
      'center', '', 'width="70%" cols="1"' );
  }
?>
</body></html>
