<?php

  /* SquirrelMail gotmail (HotMail fetcher) plugin
   *
   * Copyright (c) 1999-2003 The SquirrelMail Project Team
   * Licensed under the GNU GPL. For full terms see the file COPYING.
   *
   * This is my first attempt at a plugin.  I wanted a way to fetch
   * my hotmail so I'd only need one interface.  Of course I don't
   * like to reinvent the wheel so this just gets options for gotmail
   * and runs gotmail with cmd line params to fetch the mail.  Kinda
   * hackish but it's better then parsing and ever changing interface
   * coded by M$ techs.
   */

  
  function squirrelmail_plugin_init_got_hotmail() {
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['menuline']['got_hotmail'] =
        'got_hotmail_link';
    $squirrelmail_plugin_hooks['optpage_register_block']['got_hotmail'] =
        'got_hotmail_register';
    $squirrelmail_plugin_hooks['login_verified']['got_hotmail'] =
        'got_hotmail_login';
    $squirrelmail_plugin_hooks['left_main_before']['got_hotmail'] =
        'got_hotmail_check';
  }

  function got_hotmail_register() {
    // Gets added to the user's OPTIONS page.
    global $optpage_blocks;

    if ( !soupNazi() ) {
      // Register Squirrelspell with the $optionpages array.
      $optpage_blocks[] = array(
                 'name' => _("Got Hotmail Options"),
                 'url'  => '../plugins/got_hotmail/options.php',
                 'desc' => _("This configures settings for retrieving mail from hotmail and/or MSN accounts to your current mailbox."),
                 'js'   => false
      );
    }
  }

  function got_hotmail_link() {
    // Create top link to check hotmail accounts
    displayInternalLink('plugins/got_hotmail/gothotmail.php', _("Hotmail"), '');
    echo '&nbsp;&nbsp;';
  }

  function got_hotmail_login() {
    global $username, $data_dir;

    setPref($data_dir, $username, "gm_login", 1);
  }

  function got_hotmail_check() {
    global $username, $data_dir;

    $gm_login = getPref($data_dir, $username, "gm_login");

    if($gm_login != 1) {
      $account_to_fetch = 'refresh';
    } else {
      $account_to_fetch = 'login';
      setPref($data_dir, $username, "gm_login", 0);
    }
    require_once(SM_PATH.'plugins/got_hotmail/gothotmail.php');
  }
?>
