<?php
/*
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * $Id: functions.php,v 1.5 2010/01/30 05:05:43 indiri69 Exp $
 */
include_once(SM_PATH . 'functions/global.php');

function get_uuencode_info_real() {
    return array(
        'english_name' => 'Get UUencode',
        'authors'      => array(
            'Seth Randall' => array(
                'email' => 'indiri69@users.sourceforge.net',
                'sm_site_username' => 'randall',
            ),
        ),
        'version' => '3.2',
        'required_sm_version' => '1.4.0',
        'requires_configuration' => 0,
        'requires_source_patch'  => 0,
        'required_plugins'       => array(),
        'per_version_requirements' => array(
            '1.4.0' => array(
                'required_plugins' => array()
            ),
        ),
        'summary' => 'Decodes and downloads uuencoded attachments',
        'details' => 'Decodes and downloads uuencoded attachments. Works for both inline and attached uuencode files.'
    );
}

function start_sort($a, $b) {
    if ($a['start'] == $b['start']) {
        return strcmp($a['filename'], $b['filename']);
    }
    return ($a['start'] < $b['start']) ? -1 : 1;
}

function get_uuencode_stats($data) {
    $header_match = '/^(begin|begin-base64)\s+[0-7]{3}\s+([^\n]+)/sm';

    $stats = array();
    $count = preg_match_all($header_match, $data, $uu_data);
    if($count !== FALSE && $count > 0) {
        $last_end = 0;
        for($i = 0; $i < $count; $i++) {
            $results = array();
            $results['encoding'] = $uu_data[1][$i];
            if($results['encoding'] == 'begin') {
                $results['enc_end'] = "end";
            } else {
                $results['enc_end'] = "====";
            }
            $results['filename']     = $uu_data[2][$i];
            $results['start']        = strpos($data, $uu_data[0][$i], $last_end);
            $results['body_start']   = $results['start'] + strlen($uu_data[0][$i]);
            $results['body_end']     = strpos($data, $results['enc_end'], $results['body_start']);
            if($results['body_end'] !== False) {
                $results['end']      = $results['body_end'] + strlen($results['enc_end']);
                $results['body_len'] = $results['body_end'] - $results['body_start'];
                $results['length']   = $results['body_end'] - $results['start'] + strlen($results['enc_end']);
            }
            $last_end = $results['start'] + 1;

            if(isset($results['end'])) {
                $stats[$i] = $results;
            }
        }
        $count = count($stats);
        usort($stats, 'start_sort');
        for($i = 0; $i < $count-1; $i++) {
            if($stats[$i]['end'] > $stats[$i+1]['start']) {
                unset($stats[$i]);
            }
        }
        usort($stats, 'start_sort');
    }
    return $stats;
}

function get_uuencode_decode($data) {
    /* Convert uuencoded text to base64
       It's faster to have PHP run two functions than to
       parse it ourselves */
    $b64chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/A';
    $uudchars = '`!"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_ ';

    $uu_data = get_uuencode_stats($data);
    if(count($uu_data) > 0) {
        $uu_data = $uu_data[0];
        $uu_body = substr($data, $uu_data['body_start'], $uu_data['body_len']);
        if($uu_data['encoding'] == 'begin') {
            $lines = preg_split('/\n/', $uu_body);
            $uu_body = '';
            $length = 0;
            foreach ($lines as $line) {
                if($line != '') {
                    $count    = (ord($line[0])-32)%64;
                    $count    = ceil(($count*4)/3);
                    $uu_body .= substr(ltrim($line), 1, $count);
                    $length  += $count;
                }
            }
            $uu_body = strtr($uu_body, $uudchars, $b64chars);
            while($length % 4) {
                $uu_body .= '=';
                $length++;
            }
        }
        return base64_decode($uu_body);
    } else {
        return null;
    }
}

function get_uuencode_body(&$data) {
    global $get_uuencode_data, $get_uuencode_count;

    sqgetGlobalVar('startMessage',  $startMessage);
    sqgetGlobalVar('passed_id',     $passed_id);
    sqgetGlobalVar('passed_ent_id', $passed_ent_id);
    sqgetGlobalVar('mailbox',       $mailbox);

    $done   = False;
    $body   = $data[1];
    $output = '';
    $get_uuencode_count = 0;

    $results = get_uuencode_stats($body);
    $result_count = count($results);
    if($result_count > 0) {
        $last_end = 0;
        for($i = 0; $i < $result_count; $i++) {
            $attach = $results[$i];
            if($attach['body_len'] > 0) {
                $get_uuencode_count++;
                $output  .= substr($body, $last_end, $attach['start'] - $last_end);
                $output  .= '<UUEncoded ' . _("Attachment") . ' ' . $get_uuencode_count . ': ' . $attach['filename'] . '>';
                $last_end = $attach['end'];
                $link  = sqm_baseuri() . 'plugins/get_uuencode/get_uuencode.php?start_message=' . $startMessage .
                        '&amp;passed_id=' . $passed_id . '&amp;mailbox=' . $mailbox .
                        '&amp;get_uuencode_file=' . $get_uuencode_count;
                if(isset($passed_ent_id)) {
                    $link .= 'passed_ent_id=' . $passed_ent_id;
                }
                $get_uuencode_data[$get_uuencode_count]['link']     = '<a href="' . $link . '">' . $attach['filename'] . '</a>';
                $get_uuencode_data[$get_uuencode_count]['filename'] = $attach['filename'];
                $get_uuencode_data[$get_uuencode_count]['size']     = show_readable_size($attach['body_len']/1.35);
            }
        }
        $data[1] = $output . substr($body, $last_end);
    }
}

function get_uuencode_link () {
    global $color, $get_uuencode_data, $get_uuencode_count;

    for ($i=1; $i <= $get_uuencode_count; $i++) {
        if (isset($get_uuencode_data[$i]['link'])) {
            echo '<table cols=1 cellspacing=0 width=100% border=0 cellpadding=2 bgcolor="' . $color[0] . '">';
            echo '<tr><td>';
            echo '&nbsp;&nbsp;'     . $get_uuencode_data[$i]['link'];
            echo '&nbsp;<small><b>' . $get_uuencode_data[$i]['size'] . '</b>&nbsp;&nbsp</small>';
            echo '</td></tr></table>';
        }
    }
}

function get_uuencode_check_encoding ($encoding) {
    if($encoding == 'x-uuencode') {
        return 'get_uuencode_x_uuencode_handler';
    }
}

function get_uuencode_x_uuencode_handler($action, $body) {
    if ($action == 'decode') {
        $body = get_uuencode_decode($body);
    }
    return $body;
}
