<?php
    /*
     * $Id: get_uuencode.php,v 1.8 2010/01/30 05:06:18 indiri69 Exp $
     */
    define('SM_PATH', '../../');
    include_once(SM_PATH . 'include/validate.php'); //verify login
    include_once(SM_PATH . 'functions/imap.php');   //sqimap_login, sqimap_mailbox, sqimap_get_message
    include_once(SM_PATH . 'functions/mime.php');   //mime_fetch_body, decodeBody
    include_once(SM_PATH . 'functions/global.php'); //sqgetGlobalVar
    include_once(SM_PATH . 'plugins/get_uuencode/functions.php');

    global $plugins;
    if (!in_array('get_uuencode', $plugins)) {
        exit;
    }

    sqgetGlobalVar('key',        $key,        SQ_COOKIE);
    sqgetGlobalVar('username',   $username,   SQ_SESSION);
    sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);
    sqgetGlobalVar('mailbox',    $mailbox,    SQ_GET);
    sqgetGlobalVar('passed_id',  $passed_id,  SQ_GET);

    if(!sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_GET)) {
        $passed_ent_id = 1;
    }
    if(!sqgetGlobalVar('get_uuencode_file', $get_uuencode_file, SQ_GET)) {
        $get_uuencode_file = 1;
    }
    $get_uuencode_file--;

    $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
    sqimap_mailbox_select($imapConnection, $mailbox);
    $message = sqimap_get_message($imapConnection, $passed_id, $mailbox);

    $body = decodeBody(mime_fetch_body($imapConnection, $passed_id, $passed_ent_id), $message->header->encoding);

    // Find the file that was requested
    $all_stats = get_uuencode_stats($body);
    if(isset($all_stats[$get_uuencode_file])) {
        $stats = $all_stats[$get_uuencode_file];
        $data = get_uuencode_decode(substr($body, $stats['start'], $stats['length']));

        $uu_filename = ereg_replace('[\\/:\*\?"<>\|;]', '_', str_replace('&nbsp;', ' ', $stats['filename']));

        header('Pragma: ');
        header('Cache-Control: cache');
        header("Content-Disposition: attachment; filename=\"$uu_filename\"");
        header("Content-type: application/octet-stream; name=\"$uu_filename\"");
        echo $data;
    }
