<?php
    /*
     * $Id: get_uuencode.php,v 1.5 2004/09/24 14:57:03 indiri69 Exp $
     */
    include_once(SM_PATH . 'functions/global.php');

    function get_uuencode_decode($data) {
        /* Convert uuencoded text to base64
           It's faster to have PHP run two functions than to
           parse it ourselves */
        $b64chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/A';
        $uudchars = '`!"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_ ';

        if(preg_match('/(begin|begin-base64)\s[^\n]*\n(.*?)\n(end|====)/s', $data, $uu_data)) {
            $uu_type = $uu_data[1];
            $uu_body = $uu_data[2];
            if($uu_type == 'begin') {
                $lines = preg_split('/\n/', $uu_body);
                $uu_body = "";
                foreach ($lines as $line) {
                    if($line != '') {
                        $count    = (ord($line[0])-32)%64;
                        $count    = ceil(($count*4)/3);
                        $uu_body .= substr(ltrim($line), 1, $count);
                    }
                }
                $uu_body = strtr($uu_body, $uudchars, $b64chars);
                while(strlen($uu_body) % 4) {
                    $uu_body .= '=';
                }
            }
            return base64_decode($uu_body);
        } else {
            return null;
        }
    }

    function get_uuencode_body(&$data) {
        global $get_uuencode_data, $get_uuencode_count;

        sqgetGlobalVar('startMessage',  $startMessage);
        sqgetGlobalVar('passed_id',     $passed_id);
        sqgetGlobalVar('passed_ent_id', $passed_ent_id);
        sqgetGlobalVar('mailbox',       $mailbox);

        $done   = False;
        $body   = $data[1];
        $output = '';
        $get_uuencode_count = 0;
        $uu_file = '/((begin|begin-base64)' . '\s+' . '[0-7]{3}' . '\s+' .
                   '([^\n]+))' . '\n' . '(.+?)' . '\n' . '(end|====)' . '/s';
        do {
            if(preg_match($uu_file, $body, $uu_data)) {
                $uu_complete  = $uu_data[0];
                $uu_match     = $uu_data[1];
                $uu_type      = $uu_data[2];
                $uu_filename  = $uu_data[3];
                $uu_body      = $uu_data[4];
                $uu_end       = $uu_data[5];

                $bodyhead  = strpos($body, $uu_match);
                $bodystart = $bodyhead + strlen($uu_match);
                $bodyend   = strpos($body, $uu_end, $bodystart);
                if ($bodyend) {
                    $get_uuencode_count++;
                    $bodyend += strlen($uu_end);
                    $output  .= substr($body, 0, $bodyhead);
                    $output  .= '<uuencoded file: ' . $uu_filename . '>';
                    $body     = substr($body, $bodyend);
                    $link  = SM_PATH . 'plugins/get_uuencode/read_uuencode.php?start_message=' . $startMessage .
                            '&amp;passed_id=' . $passed_id . '&amp;mailbox=' . $mailbox .
                            '&amp;get_uuencode_file=' . $get_uuencode_count;
                    if(isset($passed_ent_id)) {
                        $link .= 'passed_ent_id=' . $passed_ent_id;
                    }
                    $get_uuencode_data[$get_uuencode_count]['link']     = '<a href="' . $link . '">' . $uu_filename . '</a>';
                    $get_uuencode_data[$get_uuencode_count]['filename'] = $uu_filename;
                    $get_uuencode_data[$get_uuencode_count]['size']     = show_readable_size((strlen($uu_body))/1.35);
                }
            } else {
                $output .= $body;
                $done = True;
            }
        } while (!$done);
        $data[1] = $output;
    }

    function get_uuencode_link () {
        global $color, $get_uuencode_data, $get_uuencode_count;

        for ($i=1; $i <= $get_uuencode_count; $i++) {
            if (isset($get_uuencode_data[$i]['link'])) {
                echo '<table cols=1 cellspacing=0 width=100% border=0 cellpadding=2 bgcolor="' . $color[0] . '">';
                echo '<tr><td>';
                echo '&nbsp;&nbsp;'     . $get_uuencode_data[$i]['link'];
                echo '&nbsp;<small><b>' . $get_uuencode_data[$i]['size'] . '</b>&nbsp;&nbsp</small>';
                echo '</td></tr></table>';
            }
        }
    }

    function get_uuencode_check_encoding ($encoding) {
        if($encoding == 'x-uuencode') {
            return 'get_uuencode_x_uuencode_handler';
        }
    }

    function get_uuencode_x_uuencode_handler($action, $body) {
        if ($action == 'decode') {
            $body = get_uuencode_decode($body);
        }
        return $body;
    }
?>
