<?php
    chdir('..');
    define('SM_PATH', '../');
    require_once(SM_PATH . 'src/validate.php');
    require_once(SM_PATH . 'functions/strings.php');
    require_once(SM_PATH . 'config/config.php');
    require_once(SM_PATH . 'functions/imap.php');
    require_once(SM_PATH . 'functions/mime.php');
    require_once(SM_PATH . 'functions/prefs.php');
    require_once(SM_PATH . 'src/global.php');

    function uudecode($data) {
        $b64chars='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/A';
        $uudchars='`!"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_ ';
        $lines = preg_split('/\n/',$data);
        $encode = "";
        foreach ($lines as $line) {
            $count   = (ord($line[0])-32)%64;
            $count   = ceil(($count*4)/3);
            $encode .= substr(ltrim($line), 1, $count);
        }
        $encode = strtr($encode, $uudchars, $b64chars);
        while(strlen($encode) % 4) {
            $encode .= '=';
        }
        return $encode;
    }

    if(isset($_COOKIE['key'])) {
        $key = $_COOKIE['key'];
    }
    if(isset($_GET['mailbox'])) {
        $mailbox = $_GET['mailbox'];
    }
    if(isset($_GET['passed_id'])) {
        $passed_id = $_GET['passed_id'];
    }
    if(isset($_GET['passed_ent_id'])) {
        $passed_ent_id = $_GET['passed_ent_id'];
    }
    if(isset($_GET['get_uuencode_file'])) {
        $get_uuencode_file = $_GET['get_uuencode_file'];
    } else {
        $get_uuencode_file = 1;
    }
    if(isset($_SESSION['username'])) {
        $username = $_SESSION['username'];
    }
    if(isset($_SESSION['onetimepad'])) {
        $onetimepad = $_SESSION['onetimepad'];
    }
    $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
    sqimap_mailbox_select($imapConnection, $mailbox);
    $message = sqimap_get_message($imapConnection, $passed_id, $mailbox);

    if ($passed_ent_id) {
        $body = decodeBody(mime_fetch_body($imapConnection, $passed_id, $passed_ent_id), $message->header->encoding);
    } else {
        $body = decodeBody(mime_fetch_body($imapConnection, $passed_id, 1), $message->header->encoding);
    }
    $space    = "[[:space:]]+";
    $mode     = "[0-7]{3}";
    $filename = "([^\n]+)";
    $uuheader = "(begin|begin-base64)".$space.$mode.$space.$filename.$space;

    for ($i = 1; $i <= $get_uuencode_file; $i++) {
        ereg($uuheader,$body,$uu_body) or
            die ('get_uudecode: Message doesn\'t contain a uuencoded message.');
        $uu_match    = $uu_body[0];
        $uu_type     = $uu_body[1];
        $uu_filename = $uu_body[2];
        if ($uu_type == 'begin') {
            $end_tag = 'end';
        }
        else if ($uu_type == 'begin-base64') {
            $end_tag = '====';
        }
        else {
            break;
        }
        $bodyhead  = strpos($body, $uu_match);
        $bodystart = $bodyhead + strlen($uu_match);
        $bodyend   = strpos($body, $end_tag, $bodystart);
        if ($bodyend) {
            $uu_data = substr($body, $bodystart, $bodyend - $bodystart);
            $body = substr($body, $bodyend + strlen($end_tag));
        }
        else {
            $body = substr($body, $bodystart);
        }
    }
    if ($uu_type == 'begin') {
        $uu_data = uudecode($uu_data);
    }
    $data = base64_decode($uu_data);

    header('Pragma: ');
    header('Cache-Control: cache');
    header("Content-Disposition: attachment; filename=$uu_filename");
    header("Content-type: application/octet-stream; name=$uu_filename");
    echo $data;
?>
