<?php
/**
 * SquirrelMail Forced Prefs Plugin -- Sample configuration
 * Copyright (C) 2004-2007 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail forced_prefs plugin.
 *
 * This plugin is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This plugin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * plugin; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * array that allows adding missing values
 */
$fp_added_settings = array(
    'hour_format'   => '1',
    'show_num'      => '20'
);

/**
 * array that allows adding enforced values
 */
$fp_forced_settings = array(
    'show_html_default' => '1'
);
/**
 * array that stores disabled hook function calls
 */
$fp_disabled_hooks = array('fortune_options','abook_take_options','bug_report_options');

/**
 * Array with urls that should be removed from option blocks. Other option block
 * array keys can't be used because they contain translatable data and strings
 * are not static.
 *
 * This option can be used to strip standard SquirrelMail option pages that
 * don't use plugin hooks. You can use regular expression instead of URL. Plugin
 * uses case insensitive POSIX regexps (http://www.php.net/eregi). If you make
 * regexp error, warning message won't be displayed and option block is not removed.
 */
$fp_removed_optpage_urls=array('options_order.php');

/**
 * Displays debug information
 * (calls sm_print_r() function in order to display processed data)
 * Requires squirrelmail 1.4.1 or newer.
 */
$fp_debug=false;

/**
 * Overrides interface defaults without saving them in user preferences
 *
 * Setting requires preference backend with get_pref hook support. Due to
 * implementation specifics, you can't override defaults with zero, empty or any
 * other values that are evaluated as boolean false in PHP.
 * @global array $fp_dynamic_defaults
 * @since 1.4
 */
$fp_dynamic_defaults=array('search_memory' => '9');

/**
 * Overrides settings without saving them in user preferences
 *
 * Setting requires preference backend with get_pref_override hook support. Due
 * to implementation specifics, you can't override defaults with zero, empty or
 * any other values that are evaluated as boolean false in PHP. Overrides are
 * filtered in option pages same way as overrides in $fp_forced_settings.
 * @global array $fp_dynamic_overrides
 * @since 1.4
 */
$fp_dynamic_overrides=array('attachment_common_show_images' => 1);