<?php
	global $folder_synch_opt_right, $folder_synch_opt_left, $imapConnection, $mailbox;

	// if mailbox isn't set, then there is no information we can provide
	// also we would probably get an error retreiving the status for a mailbox of ''
	if ($mailbox == '')
	{
		return;
	}

	// get number of new messages in our current folder
	$status = sqimap_status_messages( $imapConnection, "$mailbox");
	$message_count = $status['UNSEEN'];

	// if we want to update the right side, we need to have message variables
	// on this page
	if ($folder_synch_opt_right && $print_form)
	{
		// put in arbitrary method & action so it is technically valid html,
		// even though we won't use it
		echo "\n<form name=\"message_count\" method=\"post\" action=\"index.php\">\n";
		echo "\t<input type=\"hidden\" name=\"mailbox\" value=\"$mailbox\">\n";
		echo "\t<input type=\"hidden\" name=\"new_messages\" value=\"$message_count\">\n";
		echo "</form>\n";
	}

	// if we want to update the left side, we need to have a script
	// on this page
	if ($folder_synch_opt_left)
	{
		// this script gets the number of messages in the other frame
		// and compares it to what we have in this frame
		// only if they are different is the other frame reloaded
		echo "\n<script>\n";

		// put in this if statement so we get rid of js errors that happen
		// when the form doesn't exist on the other frame
		echo "\tif (window.parent.frames['left'].document.forms['message_count'])\n";
		echo "\t{\n";
		echo "\t\tnew_messages=window.parent.frames['left'].document.forms['message_count'].elements['$mailbox'].value;\n";
		echo "\t\tleft=window.parent.frames['left'].location;\n\n";
		echo "\t\tif (new_messages != $message_count)\n";
		echo "\t\t{\n";
		echo "\t\t\tleft.replace(left.href);\n";
		echo "\t\t}\n";
		echo "\t}\n";
		echo "</script>\n";
	}
?>