<?php
   /*
    *  Folder Synch Plugin
    *  By Jay Guerette <JayGuerette@pobox.com>
    *  v0.5 (c) 2002 (GNU GPL - see ../../COPYING)
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    */

   function squirrelmail_plugin_init_folder_synch() {
	global $squirrelmail_plugin_hooks, $username, $data_dir;

	// generally convenient places to refresh folder list
	$squirrelmail_plugin_hooks['options_display_inside']['folder_synch'] = 'folder_synch_display_inside';
	$squirrelmail_plugin_hooks['options_display_save']['folder_synch'] = 'folder_synch_display_save';
	$squirrelmail_plugin_hooks['options_link_and_description']['folder_synch'] = 'folder_synch_left';

	// otherwise, only do our business for left_main and right_main
	$context=basename($GLOBALS['PHP_SELF']);
	if (!strstr($context,'t_main.php')) return;

	// absorb 1st 2 calls to prevent double paint on startup
	// 1st call, register session var
	if (!session_is_registered('folder_synch_flags')) {
		global $folder_synch_flags;
		session_register('folder_synch_flags');
		return;
	}

	global $folder_synch_flags;

	// 2nd call, set session var from config
	if (!$folder_synch_flags) {
		$right=0+getPref($data_dir, $username, 'folder_synch_opt_right');
		$left=0+getPref($data_dir, $username, 'folder_synch_opt_left');
		$read=0+getPref($data_dir, $username, 'folder_synch_opt_read');
		$folder_synch_flags=1+(($right*2)|($left*4)|($read*8));
		return;
	}

	// 3rd and subsequent call, register hooks based on config
	if ($folder_synch_flags & 2)
		$squirrelmail_plugin_hooks['right_main_after_header']['folder_synch'] = 'folder_synch_left';
	if ($folder_synch_flags & 4)
		$squirrelmail_plugin_hooks['left_main_after']['folder_synch'] = 'folder_synch_right';
	if ($folder_synch_flags & 8)
		$squirrelmail_plugin_hooks['right_main_after_header']['folder_synch'] = 'folder_synch_left';

	error_log($context,0);
   }

   function folder_synch_display_inside() {
	global $username, $data_dir;

	print "
	<tr><td align=right valign=top>Folder Synchronization:</td>
	<td><input type=checkbox name=folder_synch_cbx_right".
	((getPref($data_dir, $username, 'folder_synch_opt_right'))?' checked>':'>')."
	Folder list update forces message list update
	<br><input type=checkbox name=folder_synch_cbx_left".
	((getPref($data_dir, $username, 'folder_synch_opt_left'))?' checked>':'>')."
	Message list update forces folder list update
	<br><input type=checkbox name=folder_synch_cbx_read".
	((getPref($data_dir, $username, 'folder_synch_opt_read'))?' checked>':'>')."
	Message body read forces folder list update
	</td></tr>
	";
   }

   function folder_synch_display_save() {
	global $folder_synch_flags, $username, $data_dir;
	global $folder_synch_cbx_left, $folder_synch_cbx_right, $folder_synch_cbx_read;

	setPref($data_dir, $username, 'folder_synch_opt_left', (isset($folder_synch_cbx_left))?1:0);
	setPref($data_dir, $username, 'folder_synch_opt_right', (isset($folder_synch_cbx_right))?1:0);
	setPref($data_dir, $username, 'folder_synch_opt_read', (isset($folder_synch_cbx_read))?1:0);

	$folder_synch_flags=0;
   }

   function folder_synch_left() {
	// other frame already refreshed, don't refresh it after this one
	if (isset($GLOBALS['no_folder_synch'])) return;
	
	print "\n<script>\n\tleft=window.parent.frames['left'].location;
	if (left && left.href.search('left_main.php')>=0) {
		if (left.href.search('no_folder_synch')>=0) left.replace(left.href);
		else left.replace(left.href+((left.href.indexOf('?')>=0)?'&':'?')+'no_folder_synch=');
	}\n</script>\n\n";
   }

   function folder_synch_right() {
	global $HTTP_USER_AGENT;
	global $lastId;
	global $left_refresh;

	// the wierd indenting style is to maintain readability in the rendered page
	// refresh reduction by detection of new mail display in folder list works only
	// for IE 5+, NS 6+, and other Gecko-based 4+ ( Opera 6 ... almost )
	if ($left_refresh>0 && (int)substr($HTTP_USER_AGENT,8)>3 && 
		(stristr($HTTP_USER_AGENT,'GECKO') || stristr($HTTP_USER_AGENT,'MSIE'))) {

		print "\n<script>
	lastId='$lastId';
	thisId='';
	tags=document.body.getElementsByTagName('SMALL');
	for (i=0;i<tags.length;i++) {
		tag=tags[i].childNodes.item(0).nodeValue;
		idVal=parseInt(tag.substring(1));
		if (!idVal>0) idVal=0;
		thisId=thisId+''+idVal;
	}
	setTimeout(\"location.replace('left_main.php?lastId='+thisId);\",".(($left_refresh-5)*1000).");
	if (".((!isset($GLOBALS['no_folder_synch']))?'':"lastId!='' && ")."thisId==lastId) right=null;
	else ";

	// other frame already refreshed, don't refresh it after this one
	}
	elseif (isset($GLOBALS['no_folder_synch'])) return;
	else print "\n<script>\n\t";

	// reload other frame, add a 'no_folder_synch' flag if not already present
	print "right=window.parent.frames['right'].location;
	if (right && right.href.search('right_main.php')>=0) {
		if (right.href.search('no_folder_synch')>=0) right.replace(right.href);
		else right.replace(right.href+((right.href.indexOf('?')>=0)?'&':'?')+'no_folder_synch=');
	}\n</script>\n\n";
   }
?>
