<?php

	function squirrelmail_plugin_init_folder_settings() {
		global $squirrelmail_plugin_hooks;

		$squirrelmail_plugin_hooks['options_folder_inside']['folder_settings'] = 'folderSettingsOptions';
		$squirrelmail_plugin_hooks['options_folder_save']['folder_settings'] = 'folderSettingsSave';
		$squirrelmail_plugin_hooks['right_main_after_header']['folder_settings'] = 'folderSettings';
	}	


	function fs_option($var, $value, $name) {
		return "<option value='$value'".
			(($var == $value) ? ' selected="selected"' : '').
			">$name</option>";
	}

	function folderSettingsOptions() {
		global $data_dir, $username;

		$sort_on = getPref($data_dir, $username, 'perfolder_sort')
			? ' checked=\'checked\'' : '';
		$default = getPref($data_dir, $username, 'default_sort', '0');

		print '<tr><th colspan=\'2\'>Folder Sorting Options</th></tr>'.
			'<tr><td align=\'right\'>Enable per-folder sorting</td><td>'.
			"<input type='checkbox' name='perfolder_sort'$sort_on>".
			'</td></tr>'.
			'<tr><td align=\'right\'>Default sort_order:</td><td>'.
			'<select name=\'default_sort\'>'.
			fs_option($default, '0', 'Date (descending)').
			fs_option($default, '1', 'Date (ascending)').
			fs_option($default, '2', 'From (descending)').
			fs_option($default, '3', 'From (ascending)').
			fs_option($default, '4', 'Subject (descending)').
			fs_option($default, '5', 'Subject (ascending)').
			fs_option($default, '6', 'Unsorted').
			'</select></td></tr>';
	}

	function folderSettingsSave() {
		global $data_dir, $username;

		setPref($data_dir, $username, 'perfolder_sort', 
			isset($_POST['perfolder_sort']) ? '1' : '0');
		setPref($data_dir, $username, 'default_sort',
			$_POST['default_sort']);
	}

	function folderSettings() {
		global $data_dir, $username, $mailbox, $sort;

		if (!getPref($datadir, $username, 'perfolder_sort'))
			return;

		$default = getPref($data_dir, $username, 'default_sort', '0');

		if (isset($GLOBALS['newsort'])) {
			if ($GLOBALS['newsort'] == $default)
				removePref($datadir, $username, "fsort_$mailbox");
			else 
				setPref($data_dir, $username, "fsort_$mailbox", $GLOBALS['newsort']);
			$sort = $GLOBALS['newsort'];
			unset($GLOBALS['newsort']);
		} else {
			$sortpref = getPref($data_dir, $username, "fsort_$mailbox");
			$sort = (($sortpref) || ($sortpref === '0')) ? $sortpref : $default;
		}
	}

?>
