<?php
/* ----- Uncompressing .Tar Class by Jimmy Conner (jimmy@advcs.org) ----- */

class untar {
   var $dir = array ();

   var $file = Array ('os' => '',
                      'compression' => '',
                      'flags' => '',
                      'xflags' => '',
                      'filename' => '',
                      'date' => '',
                      'size' => '',
                      'comment' => '',
                      files => array()
                     );

   function uncompressfile ($file) {
      if (!$f = fopen($file,'rb')) die('Could not open file!');
      $data = '';
      while (!FEOF($f))
         $data .= fread($f, 1024*8);
      fclose($f);
      $this->uncompress($data, $file);
   }

   function uncompress ($tar, $fn) {
         // give us plenty of time to get done
      if (!ini_get('safe_mode')) {
         set_time_limit(180);
         set_magic_quotes_runtime(0);
      }
      if (strlen($tar) < 1) die ('Zero Length file passed!');
      if ($fn)
         $this->file['filename'] = basename($fn);
         // Loop through the file and simply grab what we need
      while (strlen($tar) > 0) {
         $name = trim($this->getit($tar, 100));
         $mode = trim($this->getit($tar, 8));
         $uid = trim($this->getit($tar, 8));
         $gid = trim($this->getit($tar, 8));
         $size = octdec(trim($this->getit($tar, 12)));
         $time = octdec(trim($this->getit($tar, 12)));
         $crc = octdec($this->getit($tar, 4));
         $garbage = $this->getit($tar, 360);
         if ($size > 0) {
            $gsize = 0;
            if ((int)($size / 512) != ($size / 512))
               $gsize = ((((int)($size / 512)) + 1) * 512) - $size;
            $file = $this->getit($tar, $size);
            $garbage = $this->getit($tar, $gsize);
            $this->file['files'][]= array('name' => $name,
                                          'time' => $time,
                                          'size' => $size,
                                          'mode' => $mode,
                                          'gid' => $gid,
                                          'uid' => $uid,
                                          'body' => $file);
            $this->parsedir($name);
         } else {
            // Possible directory name
            if ($name != '' && !in_array($name, $this->dir))
               $this->dir[] = $name;
         }
         unset($name, $mode, $uid, $gid, $size, $time, $crc, $garbage, $gsize, $file);
      }
   }

   function getit (&$tar, $size) {
      // We just basically grab our stuff, return it, and chop the part we grabbed off
      $t = substr($tar, 0, $size);
      $tar = substr($tar, $size);
      return $t;
   }

   /*   Path = path to extract to (blank is current dir)
        Sub  = whether to extract to a directory if some of the files aren't set for a directory in the file
        Dir  = Directory name if no directory in file (if not supplied, and sub=1, a name is derived from the file name)

   */
   function extract ($path = '', $sub = 1, $dir='',$skip='') {
      if ($sub && in_array('/',$this->dir)) {
         if ($dir)
            $path = $dir;
         else {
            if ($this->file['filename'] == '')
               $path = 'temp';
            else {
               $path = $this->file['filename'];
               if (strlen($path)-strrpos($path, '.') < 6 && strlen($path)-strrpos($path, '.') > 1)
                  $path = substr($path,0,strrpos($path, '.'));
            }
         }
      }
      $str = '/';
      if ($path != '' && substr($path,strlen($path),1) != $str)
         $path .= $str;
      if (!is_dir($path))
         mkdir ($path, 0774); 
      for ($a = 0; $a < count($this->dir); $a++) {
         $f = trim($path . $this->dir[$a]);
         if (!is_dir($f)) {
            mkdir ($f, 0774); 
         }
      }
      for ($a = 0; $a < count($this->file['files']); $a++) {
         $skipme = false;
         if ($skip != '') {
            if (strpos(strtolower($this->file['files'][$a]['name']),strtolower($skip)) !== false)
               $skipme = true;
         }
         if (!$skipme) {
            $file = fopen ($path . $this->file['files'][$a]['name'],'w');
            fwrite($file, $this->file['files'][$a]['body']);
            fclose($file);
         }
      }
   }

   function extractfile ($fn = '', $path = '', $sub = 1, $dir='') {
      if ($fn == '' || $fn < 0) return 1;
      if ($sub && in_array('/',$this->dir)) {
         if ($dir)
            $path = $dir;
         else {
            if ($this->file['filename'] == '')
               $path = 'temp';
            else {
               $path = $this->file['filename'];
               if (strlen($path)-strrpos($path, '.') < 6 && strlen($path)-strrpos($path, '.') > 1)
                  $path = substr($path,0,strrpos($path, '.'));
            }
         }
      }
      $str = '/';
      if ($path != '' && substr($path,strlen($path),1) != $str)
         $path .= $str;
      if (!is_dir($path))
         mkdir ($path, 0774); 
      $f = $this->file['files'][$fn]['name'];
      if (strpos($f, "\\") !== false || strpos($f, "/") !== false) {
         $f = substr($f,0,strrpos($f, $str));
         if (!is_dir($path . $f))
            mkdir ($path . $f, 0774); 
      }
      $file = fopen ($path . $this->file['files'][$fn]['name'],'w');
      fwrite($file, $this->file['files'][$fn]['body']);
      fclose($file);
   }

   function getfile ($fn = '') {
      if ($fn == '' || $fn < 0) return '';
      return $this->file['files'][$fn];
   }

   function parsedir($name) {
      if (strpos($name,'/') !== false)
         $str = '/';
      else if (strpos($name,'\\') !== false)
         $str = '\\';
      else if (!in_array('/', $this->dir)) {
            $this->dir[] = '/';
            return;
      } else return;
      $x = strrpos($name, $str);
      $name = substr($name, 0, $x);
      if (strpos($name,":\\") !== false)
         $name = substr($name, strpos($name,":\\")+1);
      while (strlen($name) > 0) {
         if ($name != '' && !in_array($name, $this->dir) && !in_array($name . $str, $this->dir))
            $this->dir[] = $name;
         $name = substr($name, 0, strrpos($name, $str));
      }
   }

   function debug($show = 0) {
      print "<pre>";
      if (count($this->dir)>0) {
         print "<b>Directory structure</b>\n";
         print_r($this->dir);
         print "\n";
      } else print "Directory structure is empty\n"; 
      if (count($this->file['files'])>0) {
         if (!$show) {
            for ($a=0;$a<count($this->file['files']);$a++)
               $this->file['files'][$a]['body'] = 'Removed for debug';
         }
         print "<b>File Structure</b>\n";
         print_r($this->file);
         print "</pre>";
      } else print "File structure is empty\n"; 
   }

   function downloadfile ($fn) {
      if ($fn == '' || $fn < 0) return '';
      $name = $this->file['files'][$fn]['name'];
      if (strrpos($name, "\\") !== false)
         $name = substr($name, strrpos($name, "\\")+1);
      if (strrpos($name, "/") !== false)
         $name = substr($name, strrpos($name, "/")+1);
      $this->sendheader($name);
      header("Content-Length: " . $this->file['files'][$fn]['size']);
      echo $this->file['files'][$fn]['body'];
   }

   function sendheader ($filename) {
      header('Content-Type: application/octet');
      if (USR_BROWSER_AGENT == 'IE') {
         header('Content-Disposition: inline; filename="' . $filename . '"');
         header('Expires: 0');
         header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
         header('Pragma: public');
      } else {
         header('Content-Disposition: attachment; filename="' . $filename . '"');
         header('Expires: 0');
         header('Pragma: no-cache');
      }
   }
}

?>