<?php
/* ----- Uncompressing .Zip Class by Jimmy Conner (jimmy@advcs.org) ----- */

class unzip {
   var $dir = array ();

   var $file = Array (files => array());

   var $oses = Array ('FAT filesystem',
                      'Amiga',
                      'OpenVMS',
                      'Unix',
                      'VM/CMS',
                      'Atari TOS',
                      'OS/2 HPFS',
                      'Macintosh',
                      'Z-System',
                      'CP/M',
                      'TOPS-20',
                      'NTFS filesystem',
                      'QDOS',
                      'Acorn RISCOS',
                      'VFat',
                      'Alternative MVS',
                      'BeOS',
                      'Tandem',
                      'Unknown');

   function uncompressfile ($file) {
      if (!$f = fopen($file,'rb')) die('Could not open file!');
      $data = '';
      while (!FEOF($f))
         $data .= fread($f, 1024*8);
      fclose($f);
      $this->uncompress($data, $file);
   }

   function uncompress ($zip, $fn = '') {
         // give us plenty of time to get done
      if (!ini_get('safe_mode')) {
         set_time_limit(180);
         set_magic_quotes_runtime(0);
      }
      if (strlen($zip) < 1) die ('Zero Length file passed!');

         // We don't care about the filename (not .zip), as long as the headers are right
      $this->file['filename'] = $fn;      
      while (strlen($zip) > 0) {
         $header = $this->getit($zip,4);
         if ($header == "\x50\x4b\x03\x04") 
            $this->getlocalfileheader ($zip);
         if ($header == "\x50\x4b\x01\x02") break;
//            $this->getcentraldirheader ($zip);
      }
      sort($this->dir);
      sort($this->file['files']);
   }

   function os($os) {
      if ($os > 17) $os = 18;
      return $this->oses[$os];
   }

   function getit (&$zip, $size) {
      // We just basically grab our stuff, return it, and chop the part we grabbed off
      $t = substr($zip, 0, $size);
      $zip = substr($zip, $size);
      return $t;
   }

   function getcentraldirheader (&$zip) {

   }

   function getlocalfileheader (&$zip) {
      $versione = implode('',unpack('v', $this->getit($zip,2)));
      $bitflag = $this->getit($zip,2);
      $compression = $this->getit($zip,2);
      $compression = ord($compression);
      $time = implode('',unpack('v', $this->getit($zip,2)));
      $date = implode('',unpack('v', $this->getit($zip,2)));
      $crc = implode('',unpack('V', $this->getit($zip,4)));
      $c_len = implode('',unpack('V',$this->getit($zip,4)));
      $unc_len = implode('',unpack('V',$this->getit($zip,4)));
      $nlen = implode('',unpack('v',$this->getit($zip,2)));
      $extralen = implode('',unpack('v', $this->getit($zip,2)));
      if ($nlen > 0)
      $name = $this->getit($zip,$nlen);
      if ($extralen > 0)
         $extra = $this->getit($zip,$extralen);
      if ($c_len > 0 && $unc_len > 0) {
         $zdata = $this->getit($zip, $c_len);
         if ($compression == 0)
            $data = $zdata;
         else if ($compression == 8)
            $data = gzinflate($zdata);
         else die("Compression of $compression not supported!");
         if ($crc != crc32($data)) die('Checksum Error! Old Checksum and new checksum from data doesn\'t match. Possible cause.... corrupt data.');
         $this->file['files'][]= array('name' => $name,
                                       'time' => $time,
                                       'date' => $date,
                                       'size' => $unc_len,
                                       'compression' => $compression,
                                       'version' => $versione,
                                       'bitflag' => $bitflag,
                                       'body' => $data);
      } else {
         // Possible directory name
            if ($name != '' && !in_array($name, $this->dir))
               $this->dir[] = $name;
      }
      $this->parsedir($name);
   }

   /*   Path = path to extract to (blank is current dir)
        Sub  = whether to extract to a directory if some of the files aren't set for a directory in the file
        Dir  = Directory name if no directory in file (if not supplied, and sub=1, a name is derived from the file name)

   */
   function extract ($path = '', $sub = 1, $dir='',$skip='') {
      if ($sub && in_array('/',$this->dir)) {
         if ($dir)
            $path = $dir;
         else {
            if ($this->file['filename'] == '')
               $path = 'temp';
            else {
               $path = $this->file['filename'];
               if (strlen($path)-strrpos($path, '.') < 6 && strlen($path)-strrpos($path, '.') > 1)
                  $path = substr($path,0,strrpos($path, '.'));
            }
         }
      }
      $str = '/';
      if ($path != '' && substr($path,strlen($path),1) != $str)
         $path .= $str;
      if (!is_dir($path))
         mkdir ($path, 0774); 
      for ($a = 0; $a < count($this->dir); $a++) {
         $f = trim($path . $this->dir[$a]);
         if (!is_dir($f)) {
            mkdir ($f, 0774); 
         }
      }
      for ($a = 0; $a < count($this->file['files']); $a++) {
         $skipme = false;
         if ($skip != '') {
            if (strpos(strtolower($this->file['files'][$a]['name']),strtolower($skip)) !== false)
               $skipme = true;
         }
         if (!$skipme) {
            $file = fopen ($path . $this->file['files'][$a]['name'],'w');
            fwrite($file, $this->file['files'][$a]['body']);
            fclose($file);
         }
      }
   }

   function extractfile ($fn = '', $path = '', $sub = 1, $dir='') {
      if ($fn == '' || $fn < 0) return 1;
      if ($sub && in_array('/',$this->dir)) {
         if ($dir)
            $path = $dir;
         else {
            if ($this->file['filename'] == '')
               $path = 'temp';
            else {
               $path = $this->file['filename'];
               if (strlen($path)-strrpos($path, '.') < 6 && strlen($path)-strrpos($path, '.') > 1)
                  $path = substr($path,0,strrpos($path, '.'));
            }
         }
      }
      $str = '/';
      if ($path != '' && substr($path,strlen($path),1) != $str)
         $path .= $str;
      if (!is_dir($path))
         mkdir ($path, 0774); 
      $f = $this->file['files'][$fn]['name'];
      if (strpos($f, "\\") !== false || strpos($f, "/") !== false) {
         $f = substr($f,0,strrpos($f, $str));
         if (!is_dir($path . $f))
            mkdir ($path . $f, 0774); 
      }
      $file = fopen ($path . $this->file['files'][$fn]['name'],'w');
      fwrite($file, $this->file['files'][$fn]['body']);
      fclose($file);
   }

   function getfile ($fn = '') {
      if ($fn == '' || $fn < 0) return '';
      return $this->file['files'][$fn];
   }

   function parsedir($name) {
      if (strpos($name,'/') !== false)
         $str = '/';
      else if (strpos($name,'\\') !== false)
         $str = '\\';
      else if (!in_array('/', $this->dir)) {
            $this->dir[] = '/';
            return;
      } else return;
      $x = strrpos($name, $str);
      $name = substr($name, 0, $x);
      if (strpos($name,":\\") !== false)
         $name = substr($name, strpos($name,":\\")+1);
      while (strlen($name) > 0) {
         if ($name != '' && !in_array($name, $this->dir) && !in_array($name . $str, $this->dir))
            $this->dir[] = $name;
         $name = substr($name, 0, strrpos($name, $str));
      }
   }

   function debug($show = 0) {
      print "<pre>";
      if (count($this->dir)>0) {
         print "<b>Directory structure</b>\n";
         print_r($this->dir);
         print "\n";
      } else print "Directory structure is empty\n"; 
      if (count($this->file['files'])>0) {
         if (!$show) {
            for ($a=0;$a<count($this->file['files']);$a++)
               $this->file['files'][$a]['body'] = 'Removed for debug';
         }
         print "<b>File Structure</b>\n";
         print_r($this->file);
         print "</pre>";
      } else print "File structure is empty\n"; 
   }

   function downloadfile ($fn) {
      if ($fn == '' || $fn < 0) return '';
      $name = $this->file['files'][$fn]['name'];
      if (strrpos($name, "\\") !== false)
         $name = substr($name, strrpos($name, "\\")+1);
      if (strrpos($name, "/") !== false)
         $name = substr($name, strrpos($name, "/")+1);
      $this->sendheader($name);
      header("Content-Length: " . $this->file['files'][$fn]['size']);
      echo $this->file['files'][$fn]['body'];
   }

   function sendheader ($filename) {
      header('Content-Type: application/octet');
      if (USR_BROWSER_AGENT == 'IE') {
         header('Content-Disposition: inline; filename="' . $filename . '"');
         header('Expires: 0');
         header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
         header('Pragma: public');
      } else {
         header('Content-Disposition: attachment; filename="' . $filename . '"');
         header('Expires: 0');
         header('Pragma: no-cache');
      }
   }
}

?>