<?php

/*
* Mail expiration plugin
* Copyright 2005-2006 Florian Daeumling <jam@qv90.de>, Jaballa Software
* Licensed under the GNU GPL. For full terms see the file COPYING.
*/

if (!defined('SM_PATH')) {
    define( 'SM_PATH' , '../../');
}

include_once(SM_PATH . 'include/validate.php');

function expire_get_config()
{
   $one = @include_once(SM_PATH . 'plugins/expire/config.php.sample');
   $two = @include_once(SM_PATH . 'plugins/expire/config.php');
   if (!$one && !$two) {
        echo sprintf(_("ERROR (%s): Can't load config file"), 'expire');
        exit(1);
   }
}

function expire_defaults() {
    global $expire_defaults, $expire_dir, $color, $username;

    expire_get_config();
    
    $opts = $expire_dir . $username;
    
    if (file_exists ($opts)) {
	return;
    }

    bindtextdomain('expire', SM_PATH . 'locale');
    textdomain('expire');

    if (!is_dir($expire_dir . ".")) {
        if(!@mkdir($expire_dir, 07777)) {
    	    error_box(_("Cannot create option directory!") . " " .
       	    	      _("Please contact system administrator."), $color);
    	    return;
        }
    }
    
    if (!@touch($opts)) {
        error_box(_("Cannot create option file!") . " " .
       	    	  _("Please contact system administrator."), $color);
        return;
    }
    
    if (!($fp = @fopen($opts, 'w+'))) {
        error_box(_("Cannot create temporary file!") . " " .
    	          _("Please contact system administrator."), $color);
        return;
    }

    foreach ($expire_defaults as $mbox => $data) {
        fputs($fp, sprintf("%s %s\n", $mbox, $data[0]));
    }

    fclose($fp);
}

function expire_menu() {
    global $color, $username, $expire_dir;

    expire_get_config();
    
    $opts = $expire_dir . $username;

    $mbox = array();
    $age  = array();
    
    bindtextdomain('expire', SM_PATH . 'locale');
    textdomain('expire');

    if(($fp = @fopen($opts, 'r'))) {
     while ($line = fgets ($fp, 1024)) {
         list($box, $exp) = split(' ', $line);
 	 array_push($mbox, $box);
         array_push($age, $exp);
     }
     fclose($fp);
    }
    
    // show header
    echo "\n" . 
	 html_tag( 'table', '', 'center', '', 'width="70%" cellpadding="4" cellspacing="0" border="0"' ) .
         html_tag( 'tr',
         html_tag( 'td', '<b>' . _("Expiration") . '</b>', 'center', $color[9], 'width="50%"' ));
    echo html_tag( 'tr' ) .
         html_tag( 'td', '', 'center', $color[0] );

    // folder list
    echo addForm(SM_PATH . 'plugins/expire/options.php?task=set')
	. _("Expire emails in folder") . ' '
        . "<tt><select name=\"mboxset\">\n"
	. '<option value="">[ ' . _("Select a folder") . " ]</option>\n";
    // system provides list of mail boxes... ;-)
    echo sqimap_mailbox_option_list(NULL, 0, 0, NULL, 'noselect', false);
    echo '</select></tt>'
	.  ' ' . _("after") . ' '
	. addInputField('text','expiration', '30', 'size="2"')
	. ' ' . _("days") . ' ';
    
    // show button
    echo "</select></tt>\n"
	. addSubmit(_("Define"))
       . "</form></td></tr>\n";

    // show existing expirations
    echo html_tag( 'tr' )
        . html_tag( 'td', '', 'center', $color[0])
        . addForm(SM_PATH . 'plugins/expire/options.php?task=del')
	. _("Expire emails in folder") . ' '
        . '<tt><select name="mboxdel">\n'
        . '<option value="">[ ' . _("Select a folder") . ' ]</option>\n';
    for ($n=0; $mbox[$n] != ""; $n++) {
     echo '<option value="' . $mbox[$n] . '">'
        . sprintf(_("%s after %s days"), htmlspecialchars($mbox[$n]), $age[$n])
	. '</option>\n';
    }
    // show button
    echo "</select></tt>\n"
	. addSubmit(_("Delete"))
       . "</form></td></tr>\n";
    
    // check for global message
    sqgetGlobalVar('exp_msg', $exp_msg, SQ_SESSION);
    if ($exp_msg != '') {
	sqgetGlobalVar('exp_msg_col', $exp_msg_col, SQ_SESSION);
        if ($exp_msg_col == $color[2]) {
    	    $exp_msg = _("Error") . ': ' . $exp_msg;
        }
        echo html_tag('tr',
	     html_tag( 'td', '<b>'
	     . $exp_msg
	     . '</b>', 'center', $exp_msg_col, 'width="50%"' ));
        sqsession_register( '', 'exp_msg');
    }
    echo html_tag( 'tr',
            html_tag( 'td', '&nbsp;', 'left', $color[4] )
        ) ."</table>\n";
}

function  expire_write($box, $exp, $msg) {
    global $attachment_dir, $username, $expire_dir, 
	   $expire_defaults, $color;

    expire_get_config();
    bindtextdomain('expire', SM_PATH . 'locale');
    textdomain('expire');

    foreach ($expire_defaults as $mbox => $data) {
        if ($box == $mbox) {
	    if ($data[1] == 1) {
    		sqsession_register($color[9], 'exp_msg_col');
    		sqsession_register(_("This folder definition cannot be modified"), 'exp_msg');
		return 0;
	    }
	    break;
        }
    }
        
    $opts = $expire_dir . $username;
    $tmp  = $attachment_dir . $username . '.expire';
    $old  = -1;

    if(!($fpi = @fopen($opts, 'r'))) {
        error_box(_("Cannot read option file!") . " " .
    	          _("Please contact system administrator."), $color);
        return 0;
    }
    
    if (!($fpo = @fopen($tmp, 'w+'))) {
        error_box(_("Cannot create temporary file!") . " " .
    	          _("Please contact system administrator."), $color);
        return 0;
    }
    
    while ($line = fgets ($fpi, 1024)) {
        if (!strstr($line, $box)) {
    	    fputs($fpo, $line);
        } else {
	    sscanf($line, "%s %d", $obox, $old);
	    if ($msg == true) {
    		sqsession_register($color[9], 'exp_msg_col');
    		sqsession_register(sprintf(_("Expiration modified successfully for folder %s."),  
    		                   htmlspecialchars($box)), 'exp_msg');
	    }
	}
    }  
    
    if ($exp == 0) {
	if ($old < 0) {
	    $old = 0;
	} else {
	    $exp = $old;
	    if ($msg == true) {
		sqsession_register($color[9], 'exp_msg_col');
    		sqsession_register(sprintf(_("Expiration deleted successfully for folder %s."),  
    	    	        	   htmlspecialchars($box)), 'exp_msg');
	    }
	}
    } else {
	$old = $exp;
        fputs($fpo, sprintf("%s %s\n", $box, $exp));
        if ($msg == true) {
	    sqsession_register($color[9], 'exp_msg_col');
    	    sqsession_register(sprintf(_("Expiration set successfully for folder %s."),  
        	    	       htmlspecialchars($box)), 'exp_msg');
	}
    }
    
    fclose($fpi);
    fclose($fpo);

    if (!(@copy($tmp, $opts))) {
        error_box(_("Cannot replace option file!") . " " .
    	          _("Please contact system administrator."), $color);
        return 0;
    }

    return $old;
}

function expire_folder($parms) {

    list($obox, $mod, $nbox) = $parms;

    if ($mod == "rename") {
	$exp = expire_write($obox, 0, false);
	expire_write($nbox, $exp, false);
    } 
    
    if ($mod == "delete") {
    	expire_write($obox, 0, false);	
    }
}

?>
