<?php
/*
   Empty Trash - A Plugin for SqurrelMail
   Version: 1.1 
   Version Date: 03-Nov-2002
   Author: Derek Battams <derek@battams.ca>
   Please see the README file for further information

   File: setup.php

DATE          AUTHOR   CHANGE
=============================================================================
17-Apr-2002   ddb      Completion of original version
03-Nov-2002   ddb      Bug fixes; audit for SM >= 1.2.8 compatibility

*/

// Required for installation of hook into SM
function squirrelmail_plugin_init_empty_trash()
{
   global $squirrelmail_plugin_hooks;
   $squirrelmail_plugin_hooks['login_verified']['empty_trash'] = 'incCounter';
   $squirrelmail_plugin_hooks['left_main_before']['empty_trash'] = 'do_delete';
}

// Increment a counter each time a user signs into SM 
function incCounter()
{
   global $data_dir, $username;

   $logins = getPref($data_dir, $username, 'logins');
   setPref($data_dir, $username, 'logins', ++$logins);
   setPref($data_dir, $username, 'doEmpty', 1);
}

// Delete a user's trash folder.  Use JavaScript to redirect a user to the SM
// empty_trash script, which does the dirty work for us.
function delTrash()
{
   echo "<script language=\"javaScript\">\n";
   echo "window.location=\"empty_trash.php\"\n";
   echo "</script>\n";
}

// Given a date, calculate the week number of the year, using the ISO method.
//
// Though this is available from the date() function, it's only available in 
// PHP >= 4.1.0.  At the time I'm writing this I'm not using 4.1.0 so I've wrote
// it myself (with some help from the web, of course)!
function isoWeekNum($yr, $mth, $day)
{
   $j = julianDay($yr, $mth, $day);
   $x = ($j + 31741 - ($j % 7)) % 146097 % 36524 % 1461;
   $y = (int) ($x / 1460);
   $z = (($x - $y) % 365) + $y;
   $weekNum = (int) ($z / 7 + 1);
   if($weekNum == 1 && $mth != 1)
      return 53;
   if($weekNum >= 52 && $mth != 12)
      return 1;
   return (int) ($z / 7 + 1);
}

// Given a date, calculate the Julian Day value, which is used in the ISO week
// number calculation.
function julianDay($yr, $mth, $day)
{
   $a = floor((14-$mth) / 12);
   $y = $yr + 4800 - $a;
   $m = $mth + 12 * $a - 3;

   return $day + floor((153*$m+2)/5) + (365*$y) + floor($y/4) - floor($y/100) + floor($y/400) - 32045;
}

// Decide if it's time to delete the user's trash folder and if it is then do
// it!  In this version of the plugin, a user's trash folder is deleted under
// any of the following circumstances:
//
// * Every 10th login
// * Once a week
function do_delete()
{
global $data_dir, $username;

   $yr = date("Y");
   $mth = date("m");
   $day = date("d");
   $curWeek = isoWeekNum($yr, $mth, $day);

   $lastDel = getPref($data_dir, $username, 'lastDel');
   if($lastDel == '')
      $lastDel = $yr * 100 + $curWeek;

   $lastDelWk = $lastDel % 100;
   $lastDelYr = ($lastDel - $lastDelWk) / 100;
   $doEmpty = getPref($data_dir, $username, 'doEmpty');
   $logins = getPref($data_dir, $username, 'logins');

   if($doEmpty && (!($logins % 10) || ($lastDelYr < $yr || $lastDelWk < $curWeek)))
   {
      setPref($data_dir, $username, 'doEmpty', 0);
      $lastDel = date("Y") * 100 + $curWeek;
      setPref($data_dir, $username, 'lastDel', $lastDel);
      delTrash();
   }
}
