<?php

/*
   Empty Trash - A Plugin for SqurrelMail
   Version: 1.3
   Version Date: 29-Jun-2004
   Authors: Derek Battams <derek@battams.ca>
            Paul Lesneiwski <pdontthink@angrynerds.com>

   Please see the README file for further information

   File: setup.php

DATE          AUTHOR   CHANGE
=============================================================================
17-Apr-2002   ddb      Completion of original version
03-Nov-2002   ddb      Bug fixes; audit for SM >= 1.2.8 compatibility
04-Jul-2003   pl       New setup.php format for faster overall SM performance
                       Updated for SM version reporting API
29-Jun-2004   pl       Created config file to allow administrative control over
                       deletion criteria.
                       Fixed time-based criteria to measure days instead of weeks
                       (which had an inadvertent bug)

*/

// Required for installation of hook into SM
function squirrelmail_plugin_init_empty_trash()
{
   global $squirrelmail_plugin_hooks;
   $squirrelmail_plugin_hooks['login_verified']['empty_trash'] = 'incCounter';
   $squirrelmail_plugin_hooks['left_main_before']['empty_trash'] = 'do_delete';
}

function empty_trash_version()
{
   return '1.3';
}

function incCounter()
{
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/empty_trash/functions.php');
   else
      include_once('../plugins/empty_trash/functions.php');

   incCounter_do();
}

function do_delete()
{
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/empty_trash/functions.php');
   else
      include_once('../plugins/empty_trash/functions.php');

   do_delete_do();
}

?>
