<?php

/*
   Empty Trash - A Plugin for SqurrelMail
   Version: 1.3
   Version Date: 29-Jun-2004
   Authors: Derek Battams <derek@battams.ca>
            Paul Lesneiwski <pdontthink@angrynerds.com>

   Please see the README file for further information

   File: setup.php

DATE          AUTHOR   CHANGE
=============================================================================
17-Apr-2002   ddb      Completion of original version
03-Nov-2002   ddb      Bug fixes; audit for SM >= 1.2.8 compatibility
04-Jul-2003   pl       New setup.php format for faster overall SM performance
                       Updated for SM version reporting API
29-Jun-2004   pl       Created config file to allow administrative control over
                       deletion criteria.
                       Fixed time-based criteria to measure days instead of weeks
                       (which had an inadvertent bug)

*/


// Increment a counter each time a user signs into SM 
function incCounter_do()
{
   global $data_dir, $username;

   $logins = getPref($data_dir, $username, 'logins');
   setPref($data_dir, $username, 'logins', ++$logins);
   setPref($data_dir, $username, 'doEmpty', 1);
}

// Delete a user's trash folder.  Use JavaScript to redirect a user to the SM
// empty_trash script, which does the dirty work for us.
function delTrash()
{
   echo "<script language=\"javaScript\">\n";
   echo "window.location=\"empty_trash.php\"\n";
   echo "</script>\n";
}

// Decide if it's time to delete the user's trash folder and if it is then do
// it!  In this version of the plugin, a user's trash folder is deleted under
// any of the following circumstances:
//
function do_delete_do()
{
global $data_dir, $username;

   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/empty_trash/config.php');
   else
      include_once('../plugins/empty_trash/config.php');

   $now = time();
 
   $lastDel = getPref($data_dir, $username, 'lastDel');
   if($lastDel == '')
      $lastDel = $now;

   $sec_in_a_day = 60*60*24;
   $diff = $now - $lastDel;
   for ($daysDiff = 0; $diff >= $sec_in_a_day; $diff -= $sec_in_a_day)
      $daysDiff++; 

   $doEmpty = getPref($data_dir, $username, 'doEmpty');
   $logins = getPref($data_dir, $username, 'logins');

   global $loginLimit, $dayLimit;
   $overLoginLimit = ($loginLimit > 0 && ($logins % $loginLimit) === 0);
   $overDayLimit = ($dayLimit > 0 && $daysDiff > $dayLimit);

   if($doEmpty && ($overLoginLimit || $overDayLimit))
   {
      setPref($data_dir, $username, 'doEmpty', 0);
      $lastDel = time();
      setPref($data_dir, $username, 'lastDel', $lastDel);
      delTrash();
   }
}

?>
