<?php

/**
  * empty_folders_options.tpl
  *
  * Template for showing user-configurable options on the folder page
  * for the Empty Folders plugin.
  *
  * The following variables are available in this template:
  *
  * boolean $show_purge_link_allow_override   Whether or not users are allowed
  *                                           to change the folders that purge
  *                                           links are shown next to.
  * boolean $confirm_purge_link               Whether or not purge link actions
  *                                           are to be confirmed first.
  * boolean $show_empty_link_allow_override   Whether or not users are allowed
  *                                           to change the folders that empty
  *                                           links are shown next to.
  * boolean $confirm_empty_link               Whether or not empty link actions
  *                                           are to be confirmed first.
  * boolean $show_purge_button_allow_override Whether or not users are allowed
  *                                           to change the folders that purge
  *                                           buttons are shown on.
  * boolean $confirm_purge_button             Whether or not purge button actions
  *                                           are to be confirmed first.
  * boolean $show_delete_all_button_allow_override Whether or not users are allowed
  *                                                to change the folders that delete
  *                                                all buttons are shown on.
  * boolean $confirm_delete_all_button        Whether or not delete button actions
  *                                           are to be confirmed first.
  * array   $ef_folder_listing   An array where each entry is a seven-element
  *                              array keyed by "displayable", "option_value",
  *                              "show_empty_link", "show_purge_link",
  *                              "show_purge_button", "show_delete_all_button"
  *                              and "is_special", where the last five are boolean
  *                              values.
  * boolean $show_purge_trash_button Whether or not a purge button is to be shown
  *                                  on the trash folder mailbox list
  * boolean $show_purge_trash_button_allow_override Determines if users are allowed
  *                                                 to control if the purge button
  *                                                 is shown on the trash page, ala
  *                                                 $show_purge_trash_button
  * boolean $javascript_on       Whether or not JavaScript is supported/enabled.
FIXME: sync the $color array with 1.5.2 if it is no longer available(?)
  * array   $color               The SquirrelMail colors array.
  *
  * Copyright (c) 2003-2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage empty_folders
  *
  */


// retrieve the template vars
//
extract($t);


if (($show_purge_link_allow_override || $show_empty_link_allow_override)
 && ($show_purge_button_allow_override || $show_delete_all_button_allow_override))
   $title = _("Links/Buttons That Empty Folders");
else if ($show_purge_link_allow_override || $show_empty_link_allow_override)
   $title = _("Links That Empty Folders");
else if ($show_purge_button_allow_override || $show_delete_all_button_allow_override)
   $title = _("Buttons That Empty Folders");
else
   $title = 'Empty Folders CONFIGURATION ERROR';


$form_index = 1;


?>
<form style="display:inline; margin:0" method="post" name="empty_folders_links_form">
  <input type="hidden" value="1" name="empty_folders_form">
    <table width="70%" cols="1" align="center" cellpadding="4" cellspacing="0" border="0">
      <?php if (!check_sm_version(1, 4, 10)) echo "<tr><td bgcolor=\"$color[4]\">&nbsp;</td></tr>\n"; ?>
      <tr>
        <td bgcolor="<?php echo $color[9]; ?>" align="center"><strong><?php echo $title; ?></strong></td>
      </tr>
      <tr>
        <td bgcolor="<?php echo $color[0]; ?>" align="center"><?php



// where to show empty links?
//
if ($show_empty_link_allow_override) { ?><table width="100%" border="0">
            <tr>
              <td width="60%" align="right">
                <select name="empty_folders_show_empty_link[]" multiple size="8">
                  <?php foreach ($ef_folder_listing as $folder_info) { ?>
                    <option value="<?php echo $folder_info['option_value']; if ($folder_info['show_empty_link']) echo '" selected="selected'; ?>"><?php echo $folder_info['displayable']; ?></option>
                  <?php } ?>
                </select>
              </td>
              <td valign="bottom">
                <table cellpadding="0" cellspacing="5" border="0">
                  <tr>
                    <td><?php echo _("Empty links next to the folder name move all messages in the folder to the trash.") . '<br /><br />'; if ($javascript_on) { ?>
                <input type="checkbox" name="confirm_empty_link" id="confirm_empty_link" value="1"<?php if ($confirm_empty_link) echo ' checked="checked"'; ?> /><label for="confirm_empty_link">
                <?php echo _("Confirm empty"); /* "elements[x] below because javascript can't reference element names with brackets in them */ ?>
                </label>
                <br />
                <br />
                <a href="#" onClick="list = document.empty_folders_links_form.elements[<?php echo $form_index; ?>]; for (i = 0; i < list.length; i++) if (<?php
                   $first = TRUE;
                   foreach ($ef_folder_listing as $folder_info)
                   {
                      if (!$folder_info['is_special']) continue;
                      if (!$first) echo ' || ';
                      else $first = FALSE;
                      echo 'list.options[i].value==\'' . $folder_info['option_value'] . '\'';
                   }
                ?>) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle Special Folders"); ?></a>
                <br />
                <br />
                <a href="#" onClick="list = document.empty_folders_links_form.elements[<?php echo $form_index; $form_index += 2; ?>]; for (i = 0; i < list.length; i++) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle All"); ?></a>
              <?php } ?></td></tr></table></td>
            </tr>
          </table>


<?php }


// where to show purge links?
//
if ($show_purge_link_allow_override) {

   if ($show_empty_link_allow_override)
      echo '<hr width="75%" />';

        ?><table width="100%" border="0">
            <tr>
              <td width="60%" align="right">
                <select name="empty_folders_show_purge_link[]" multiple size="8">
                  <?php foreach ($ef_folder_listing as $folder_info) { ?>
                    <option value="<?php echo $folder_info['option_value']; if ($folder_info['show_purge_link']) echo '" selected="selected'; ?>"><?php echo $folder_info['displayable']; ?></option>
                  <?php } ?>
                </select>
              </td>
              <td valign="bottom">
                <table cellpadding="0" cellspacing="5" border="0">
                  <tr>
                    <td><?php echo _("Purge links next to the folder name remove all messages from the folder permanently.") . '<br /><br />'; if ($javascript_on) { ?>
                <input type="checkbox" name="confirm_purge_link" id="confirm_purge_link" value="1"<?php if ($confirm_purge_link) echo ' checked="checked"'; ?> /><label for="confirm_purge_link">
                <?php echo _("Confirm purge"); /* "elements[x] below because javascript can't reference element names with brackets in them */ ?>
                </label>
                <br />
                <br />
                <a href="#" onClick="list = document.empty_folders_links_form.elements[<?php echo $form_index; ?>]; for (i = 0; i < list.length; i++) if (<?php
                   $first = TRUE;
                   foreach ($ef_folder_listing as $folder_info)
                   {
                      if (!$folder_info['is_special']) continue;
                      if (!$first) echo ' || ';
                      else $first = FALSE;
                      echo 'list.options[i].value==\'' . $folder_info['option_value'] . '\'';
                   }
                ?>) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle Special Folders"); ?></a>
                <br />
                <br />
                <a href="#" onClick="list = document.empty_folders_links_form.elements[<?php echo $form_index; $form_index += 2; ?>]; for (i = 0; i < list.length; i++) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle All"); ?></a>
              <?php } ?></td></tr></table></td>
            </tr>
          </table>


<?php }


// where to show delete all buttons?
//
if ($show_delete_all_button_allow_override) {

   if ($show_empty_link_allow_override || $show_purge_link_allow_override)
      echo '<hr width="75%" />';

        ?><table width="100%" border="0">
            <tr>
              <td width="60%" align="right">
                <select name="empty_folders_show_delete_all[]" multiple size="8">
                  <?php foreach ($ef_folder_listing as $folder_info) { ?>
                    <option value="<?php echo $folder_info['option_value']; if ($folder_info['show_delete_all_button']) echo '" selected="selected'; ?>"><?php echo $folder_info['displayable']; ?></option>
                  <?php } ?>
                </select>
              </td>
              <td valign="bottom">
                <table cellpadding="0" cellspacing="5" border="0">
                  <tr>
                    <td><?php echo _("Delete All buttons on message list page move all messages from the folder to the trash.") . '<br /><br />'; if ($javascript_on) { ?>
                <input type="checkbox" name="confirm_delete_all_button" id="confirm_delete_all_button" value="1"<?php if ($confirm_delete_all_button) echo ' checked="checked"'; ?> /><label for="confirm_delete_all_button">
                <?php echo _("Confirm deletion"); /* "elements[x] below because javascript can't reference element names with brackets in them */ ?>
                </label>
                <br />
                <br />
                <a href="#" onClick="list = document.empty_folders_links_form.elements[<?php echo $form_index; ?>]; for (i = 0; i < list.length; i++) if (<?php
                   $first = TRUE;
                   foreach ($ef_folder_listing as $folder_info)
                   {
                      if (!$folder_info['is_special']) continue;
                      if (!$first) echo ' || ';
                      else $first = FALSE;
                      echo 'list.options[i].value==\'' . $folder_info['option_value'] . '\'';
                   }
                ?>) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle Special Folders"); ?></a>
                <br />
                <br />
                <a href="#" onClick="list = document.empty_folders_links_form.elements[<?php echo $form_index; $form_index+= 2; ?>]; for (i = 0; i < list.length; i++) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle All"); ?></a>
              <?php } ?></td></tr></table></td>
            </tr>
          </table>


<?php }


// where to show purge buttons?
//
if ($show_purge_button_allow_override) {

   if ($show_empty_link_allow_override || $show_purge_link_allow_override
    || $show_delete_all_button_allow_override)
      echo '<hr width="75%" />';

        ?><table width="100%" border="0">
            <tr>
              <td width="60%" align="right">
                <select name="empty_folders_show_purge_button[]" multiple size="8">
                  <?php foreach ($ef_folder_listing as $folder_info) { ?>
                    <option value="<?php echo $folder_info['option_value']; if ($folder_info['show_purge_button']) echo '" selected="selected'; ?>"><?php echo $folder_info['displayable']; ?></option>
                  <?php } ?>
                </select>
              </td>
              <td valign="bottom">
                <table cellpadding="0" cellspacing="5" border="0">
                  <tr>
                    <td><?php echo _("Purge buttons on the message list page remove all messages from the folder permanently.") . '<br /><br />'; if ($javascript_on) { ?>
                <input type="checkbox" name="confirm_purge_button" id="confirm_purge_button" value="1"<?php if ($confirm_purge_button) echo ' checked="checked"'; ?> /><label for="confirm_purge_button">
                <?php echo _("Confirm purge"); /* "elements[x] below because javascript can't reference element names with brackets in them */ ?>
                </label>
                <br />
                <br />
                <a href="#" onClick="list = document.empty_folders_links_form.elements[<?php echo $form_index; ?>]; for (i = 0; i < list.length; i++) if (<?php
                   $first = TRUE;
                   foreach ($ef_folder_listing as $folder_info)
                   {
                      if (!$folder_info['is_special']) continue;
                      if (!$first) echo ' || ';
                      else $first = FALSE;
                      echo 'list.options[i].value==\'' . $folder_info['option_value'] . '\'';
                   }
                ?>) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle Special Folders"); ?></a>
                <br />
                <br />
                <a href="#" onClick="list = document.empty_folders_links_form.elements[<?php echo $form_index; ?>]; for (i = 0; i < list.length; i++) { list.options[i].selected = !list.options[i].selected; } return false;"><?php echo _("Toggle All"); ?></a>
              <?php } ?></td></tr></table></td>
            </tr>
          </table>


<?php }


// show purge button on trash folder?
//
if ($show_purge_trash_button_allow_override) {

   if ($show_empty_link_allow_override || $show_purge_link_allow_override
    || $show_delete_all_button_allow_override || $show_purge_button_allow_override)
      echo '<hr width="75%" />';

        ?><input type="checkbox" id="showpurgetrash" name="show_purge_trash_button" value="1"<?php if ($show_purge_trash_button) echo ' checked="checked"'; ?> />
          <label for="showpurgetrash"><?php echo _("Show \"Purge\" button in trash folder"); ?></label>

<?php } ?>

        </td>
      </tr>
      <tr>
        <td bgcolor="<?php echo $color[0]; ?>" align="right"><input type="submit" value="<?php echo _("Save"); ?>"></td>
      </tr>
      <tr><td bgcolor="<?php echo $color[4]; ?>">&nbsp;</td></tr>
    </table>
  </form>

