<?php

/**
  * SquirrelMail Empty Folders Plugin
  * Copyright (C) 2003-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  * @package plugins
  * @subpackage Empty Folders
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_empty_folders() 
{

  global $squirrelmail_plugin_hooks;

  $squirrelmail_plugin_hooks['folders_bottom']['empty_folders'] 
     = 'empty_folders_show_options';
  $squirrelmail_plugin_hooks['left_main_after_each_folder']['empty_folders']
     = 'empty_folders_show_link';

}



/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Places text and widgets on the option page
  *
  */
function empty_folders_show_options() 
{

  include_once(SM_PATH . 'plugins/empty_folders/functions.php');
  empty_folders_show_options_do();

}



/**
  * Display empty links on target folders
  *
  * @param array $parms Parameters passed to this hook by SquirrelMail -
  *                     First element is number of messages, second is
  *                     mailbox name, third is a usable IMAP server connection.
  *
  */
function empty_folders_show_link($parms) 
{

  include_once(SM_PATH . 'plugins/empty_folders/functions.php');
  return empty_folders_show_link_do($parms);

}



/**
  * Returns version info about this plugin
  *
  */
function empty_folders_version() 
{

  return '1.2-1.2';

}



?>
