<?php

/**
  * SquirrelMail Empty Folders Plugin
  * Copyright (C) 2003, 2004 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


chdir('..');
define('SM_PATH','../');



// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');



if (compatibility_check_sm_version(1, 3))
{
   include_once (SM_PATH . 'include/validate.php');
   include_once (SM_PATH . 'functions/imap.php');
}
else
{
   include_once ('../src/validate.php');
   include_once ('../functions/imap.php');
}


if (compatibility_check_sm_version(1, 3))
   include_once (SM_PATH . 'plugins/empty_folders/config.php');
else
   include_once ('../plugins/empty_folders/config.php');


global $imapServerAddress, $imapPort, $username, $key, $move_to_trash;


// get global variable for versions of PHP < 4.1
//
if (!compatibility_check_php_version(4,1)) {
   global $HTTP_COOKIE_VARS;
   $_COOKIE = $HTTP_COOKIE_VARS;
}

$key = $_COOKIE['key'];
compatibility_sqextractGlobalVar('username');
compatibility_sqextractGlobalVar('delimiter');
compatibility_sqextractGlobalVar('onetimepad');

compatibility_sqextractGlobalVar('mailbox');
if (isset($mailbox)){
    $mailbox = urldecode( $mailbox );
}


// should we expunge or move to trash?
//
$empty_folders_link_behavior = getPref($data_dir, $username,
                                       'empty_folders_link_behavior',
                                       $default_empty_link_behavior);


// no longer needed
// do_hook('session_recall');

$imap_stream = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);


// figure out if there are any messages to delete
//
if (compatibility_check_sm_version(1, 3)) 
{
   $mbx_response = sqimap_mailbox_select($imap_stream, $mailbox);
   $mbx_response = $mbx_response['EXISTS'];
} 
else 
{
   $mbx_response = sqimap_get_num_messages($imap_stream, $mailbox);
}


// if so, move to trash or expunge, depending on desired behavior
//
if ($mbx_response > 0) {

   sqimap_mailbox_select($imap_stream, $mailbox);

   // we override the "move_to_trash" functionality
   // on our own, based on user's preferences
   //
   $myMoveToTrash = $move_to_trash;
   if ($empty_folders_link_behavior == 'moveToTrash')
      $move_to_trash = true;
   else if ($empty_folders_link_behavior == 'expunge')
      $move_to_trash = false;


   // delete messages (or move to trash)
   //
   sqimap_messages_delete ($imap_stream, 1, '*', $mailbox);
   $move_to_trash = $myMoveToTrash;


   // empty out the mailbox
   //
   sqimap_mailbox_expunge($imap_stream, $mailbox, true);

}


header ('Location: ' . SM_PATH . '../src/left_main.php');

sqimap_logout($imap_stream);

?>
