<?php
  /**
   **  Email Footer (email_footer) v0.1.0
   **
   **  By Ray Black III <allah@accessnode.net>
   **  (c) 2001 (GNU GPL - see ../../COPYING)
   **
   **  This plugin lets site operators set a default footer for
   **  all emails sent using their installation of SquirrelMail.
   **  
   **  To change the footer message, see below.
   **/


/*******************************************************
 **   Replace our footer with yours. Try to keep the
 **   width of each line under 70-ish characters, and
 **   end each line with a line break (\n). HTML in
 **   emails is bad. HTML in emails is very bad. Evil.
 *******************************************************/

$enter_your_message_here = "\n\n"                   // creating a little space between the email
    ."-----------------------------------------\n"  // and the footer, the line just looks nice
    ."This email was sent using SquirrelMail.\n"
    ."   \"Webmail for nuts!\"\n"
    ."http://squirrelmail.org/\n";                  // straight text, let the recipient's email 
                                                    // client generate the link!


/*******************************************************
 **   No need to change anything else below this point.
 *******************************************************/



global $email_footer;
$email_footer = $enter_your_message_here;

function squirrelmail_plugin_init_email_footer()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['compose_send']['email_footer']
            = 'email_footer_addition';
    $squirrelmail_plugin_hooks['compose_form']['email_footer']
            = 'email_footer_subtraction';

} // end squirrelmail_plugin_init_email_footer()


// this is pretty straight forward...
function email_footer_addition()
{

    global $email_footer, $body;

    $body = $body . $email_footer;

} // end email_footer_addition()



// lots of checks to make sure we're actually cleaning up the right stuff...
function email_footer_subtraction()
{  
     
    global $email_footer, $body;
 
    if ( !empty($body) && strlen(trim($body)) >= strlen(trim($email_footer)) && substr( $body, (-1 * strlen($email_footer)) ) == $email_footer )
        $body = substr( $body, 0, (-1 * strlen($email_footer)) );
        
} // end email_footer_subtraction()


?>