<?php

/**
  * SquirrelMail Email Footer Plugin
  * Copyright (c) 2001 Ray Black III <allah@accessnode.net>,
  * Copyright (c) 2003-2009 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage email_footer
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_email_footer()
{

   global $squirrelmail_plugin_hooks;


   // add text to bottom of outgoing message body
   //
   $squirrelmail_plugin_hooks['compose_send']['email_footer']
      = 'email_footer_addition';


   // add a menu item to the Vadmin domain prefs/user permissions
   // menu to let administrators control the email footer in the
   // Vadmin interface
   //
   $squirrelmail_plugin_hooks['vadmin_domain_perms_menu']['email_footer']
      = 'email_footer_vadmin_menu';
   $squirrelmail_plugin_hooks['vadmin_domain_perms_menu_submit']['email_footer']
      = 'email_footer_vadmin_menu_submit';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['email_footer']
      = 'email_footer_check_configuration';


}



/**
  * Returns info about this plugin
  *
  */
function email_footer_info()
{

   return array(
                 'english_name' => 'Email Footer',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '0.6',
                 'required_sm_version' => '1.4.2',
                 'requires_configuration' => 0,
                 'summary' => 'Automatically appends a custom footer to messages sent using SquirrelMail.',
                 'details' => 'This plugin automatically appends a custom footer onto the end of messages sent using SquirrelMail.  If you have the "HTML Mail" plugin installed, you can also specify a HTML-formatted version of the footer for users who send their email in HTML.  You may also specify the email footer text on a per-domain, per-IMAP server, or per-user basis using the Login Manager or Multilogin plugins or allow Vadmin administrators to control the footer text in the Vadmin interface.',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function email_footer_version()
{
   $info = email_footer_info();
   return $info['version'];
}



/**
  * Add text to bottom of outgoing message body
  *
  */
function email_footer_addition(&$argv)
{
   include_once(SM_PATH . 'plugins/email_footer/functions.php');
   return email_footer_addition_do($argv);
}



/**
  * Add a menu item to the Vadmin domain prefs/user permissions
  * menu to let administrators control the email footer in the
  * Vadmin interface
  *
  */
function email_footer_vadmin_menu($args)
{
   include_once(SM_PATH . 'plugins/email_footer/functions.php');
   return email_footer_vadmin_menu_do($args);
}
function email_footer_vadmin_menu_submit($args)
{
   include_once(SM_PATH . 'plugins/email_footer/functions.php');
   return email_footer_vadmin_menu_submit_do($args);
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function email_footer_check_configuration()
{
   include_once(SM_PATH . 'plugins/email_footer/functions.php');
   return email_footer_check_configuration_do();
}



