<?php

/**
  * SquirrelMail Email Footer Plugin
  * Copyright (c) 2001 Ray Black III <allah@accessnode.net>,
  * Copyright (c) 2003-2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage email_footer
  *
  */



/**
  * Add the footer to an outgoing mail
  *
  */
function email_footer_addition_do(&$argv)
{

   if (file_exists(SM_PATH . 'plugins/email_footer/config.php'))
      include_once(SM_PATH . 'plugins/email_footer/config.php');
   else
      include_once(SM_PATH . 'plugins/email_footer/config.sample.php');

   global $plain_text_email_footer, $config_override, $draft,
          $plugins, $email_footer_debug, $email_footer_on_drafts;


   // bail if this is a draft and we aren't adding footers to drafts
   //
   if ($draft && !$email_footer_on_drafts)
      return;


   $email_footer = $plain_text_email_footer;


   // allow vlogin or multilogin plugins to override the footer
   //
   sqgetGlobalVar('config_override', $config_override, SQ_SESSION);
   if (isset($config_override['email_footer']))
      $email_footer = $config_override['email_footer'];


   // if user is composing in HTML using the "html_mail" plugin, 
   // check for $html_email_footer and if not available, turn
   // newlines of regular footer into <br>'s
   //
   if (in_array('html_mail',$plugins))
   {

      global $strip_html_send_plain, $html_email_footer;
      sqGetGlobalVar('strip_html_send_plain', $strip_html_send_plain, SQ_FORM);

      include_once(SM_PATH . 'plugins/html_mail/functions.php');
      if (!$strip_html_send_plain && html_area_is_on_and_is_supported_by_users_browser())
      {

         if (!empty($html_email_footer))
            $email_footer = $html_email_footer;
         else
            $email_footer = preg_replace("/(\015\012)|(\015)|(\012)/", '<br />', $email_footer);


         // allow vlogin or multilogin plugins to override the footer
         //
         if (isset($config_override['email_footer_HTML']))
            $email_footer = $config_override['email_footer_HTML'];

      }

   }



   // grab the message - probably not compatible with 1.5.0 or 1.5.1
   //
   if (check_sm_version(1, 5, 2))
      $message = &$argv;
   else
      $message = &$argv[1];



   // do the actual footer insertion
   //
   if (is_array($message->entities) && sizeof($message->entities) > 0)
      $message->entities[0]->body_part = $message->entities[0]->body_part . $email_footer;
   else
      $message->body_part = $message->body_part . $email_footer;



   // debugging...
   //
   if ($email_footer_debug) 
   {
      sm_print_r($message);
      exit;
   }



   return $message;

}



