<?php

/*
 * This is the options page that you will set how
 * Disk Quota Plugin behaves.
*/

/* This is the path to your quota binary. Because
 * of the behavior of the plugin, you should not use
 * spaces when defining this path. Use "_" instead
 * of spaces if you will be using sudo.
 * That will be something like
 * "sudo_/usr/bin/quota"
 * See INSTALL for details.
*/

$dq_quota_binary = "sudo_/usr/bin/quota";

/*
 * This variable must be correctly set in order to make
 * the plugin work correctly on Linux systems. To determine
 * how to set this variable, check the quota of a "non-quota"
 * user with the binary you have stated for the above
 * variable using "quota -v username". If you get something
 * like this:
 *
 * Disk quotas for user username (uid 500):
 *    Filesystem  blocks  quota  limit  grace  files  quota  limit  grace
 *
 * That is, only two rows of output, set the variable to 0.
 *
 * But if you get something like this:
 *
 * Disk quotas for user username (uid 500):
 *    Filesystem  blocks  quota  limit  grace  files  quota  limit  grace
 *    /dev/hda1    12365      0      0            15      0      0
 *    /home         4756      0      0             4      0      0
 *
 * That is, if your quota binary generates an output for users
 * who don't have quota enabled, set the variable to 1.
 * 
 * I've left this in for the time being. I don't believe we need this
 * flag anymore. - Mike
*/

$dq_strange_binary = 0;

/*
 * This variable determines if you have SquirrelMail 1.3.x or older.
 * You MUST set this correctly in order to have the plugin work
 * without problems.
 * If you have SquirrelMail 1.3.x or newer, set to : 1
 * If you have SquirrelMail 1.2.x or older, set to : 0
*/

$dq_sm_is_13_or_newer = 0;

/*
 * This is the table border size of disk_quota.php that
 * shows the detailed quota status of the user.
 * Be careful to set this variable to '"number"' not
 * "number" or 'number'.
*/

$dq_table_border_size = '"0"';

/*
 * If you set this to 1, then the left_quota.php and
 * check_quota.php will show information about the
 * filesystems which the user has no files (blocks = 0)
 * but has quota set for.
 * To show verbose information, set to : 1
 * To hide verbose information, set to : 0
*/

$dq_show_verbose = 0;

/*
 * This shows or hides the filesystem names for the user's
 * files. If set to 1, check_quota.php (the main page) 
 * will show the filesystem names on which the user has
 * quota enabled.
 * To show filesystems, set to : 1
 * To hide filesystems, set to : 0
*/

$dq_show_filesystem_check = 0;

/*
 * This has the same effect of $dq_show_filesystem_check on
 * left_quota.php (the Disk Usage Bar on the left pane).
 * To show filesystems, set to : 1
 * To hide filesystems, set to : 0
*/

$dq_show_filesystem_left = 0;

/*
 * This can turn on or off the Details link under the disk
 * usage on the left pane. If the details link is turned off,
 * users can still see the detailed usage of their quota by
 * going to the options page and clicking "Check Quota".
 * To show details link, set to : 1
 * To hide details link, set to : 0
*/

$dq_show_details_link = 1;

/*
 * This determines if SquirrelMail and IMAP server are both
 * on the same machine.
 * If they are on the same machine, set to : 0
 * If they are on different machines, set to : 1
*/

$dq_check_quota_on_remote = 0;

/*
 * If you set $dq_check_quota_on_remote to 1, you must state
 * the address of the Virtual host that is configured on your
 * IMAP server here. You should write something like:
 * "http://quota.yourdomain.com" to this variable.
 * ATTENTION: Don't write something like:
 * "quota.yourdomain.com", "quota.yourdomain.com/" or
 * "http://quota.yourdomain.com/" or your plugin will be broken.
 * Use the format "http://quota.yourdomain.com"
 * See INSTALL for details.
*/ 

$dq_imap_server = "http://quota.yourdomain.com";

/*
 * Set $dq_use_gd = '1' if you have compiled php with gd support.
 * $dq_warn controls at which point the bar changes to a warning state.
 * $dq_alarm controls at which point the bar changes to a critical state.
*/

$dq_use_gd = '1';
$dq_warn   = '75'; // color bar turns yellow at 75%
$dq_alarm  = '90'; // color bar turns red at 90%
?>
