<?php

	/*
	*  Disk Quota Plugin
	*  By Kerem Erkan <kerem.erkan@hacettepe.edu.tr>
	*  based on the wonderful plugin by Claudio Panichi <claudio.panichi@roma2.infn.it>
	*  Version 2.5
	*  See INSTALL for detailed usage.
	*/

/* Set the SM_PATH for use with 1.4.0 */
if (!defined('SM_PATH'))
    {
      define('SM_PATH','../');
      chdir ("..");
    }

include_once (SM_PATH . 'plugins/disk_quota/options.php');

if(file_exists(SM_PATH . 'include/validate.php'))
 { require_once(SM_PATH . 'include/validate.php'); }
elseif(file_exists(SM_PATH . 'src/validate.php'))
 { require_once('../src/validate.php'); }
else{ echo "validate.php not found, program exit"; exit; }
displayPageHeader($color, "None");

include_once(SM_PATH . 'functions/i18n.php');
bindtextdomain('disk_quota', SM_PATH . 'plugins/disk_quota/locale');
textdomain('disk_quota');

$dq_you_have_no_limit = _("You_have_no_quota_limit");
$dq_ignore = _("Please_ignore_the_following_information");

echo '<p align="center">&nbsp;</p>';
echo '<h2 align="center"><strong><em><font color=' . "\"$color[8]\">";
echo _("This is your diskquota usage.") . '</font></em></strong></h2>';
echo '<table align="center" ' . "border=$dq_table_border_size>";
echo '  <tr bgcolor=' . "\"$color[5]\">";

if ( $dq_show_filesystem_check == 1 ) {

echo '    <td><div align="center"><strong>&nbsp;' .
          _("Filesystem") . '&nbsp;</strong></div></td>';

}

echo '    <td><div align="center"><strong>&nbsp;' .
          _("Used") . ' (KB)&nbsp;</strong></div></td>';
echo '    <td><div align="center"><strong>&nbsp;' .
          _("Quota") . ' (KB)&nbsp;</strong></div></td>';
echo '    <td><div align="center"><strong>&nbsp;' .
          _("Limit") . ' (KB)&nbsp;</strong></div></td>';
echo '    <td><div align="center"><strong>&nbsp;' .
          _("Grace-Time") . '&nbsp;</strong></div></td>';
echo '    <td><div align="center"><strong>&nbsp;' .
          _("Status") . '&nbsp;</strong></div></td>';
echo '  </tr>';

if ( $dq_check_quota_on_remote == 0 ) {

  include_once (SM_PATH . 'plugins/disk_quota/check_quota.php');

}
elseif ( $dq_check_quota_on_remote == 1 ) {

/*
 * We will send the color information and username to quota checker now.
 * The color information is something like #DCDCFF
 * When we include a file on a remote server, # makes problem.
 * So we remove it and send DCDCFF or else to the checker.
 * On the checker, we add the # again to the color variaable.
*/

  $dq_sendcolor = substr($color[0],1);
  include_once ("$dq_imap_server/check_quota_sv.php?username=$username&dq_quota_binary=$dq_quota_binary&dq_sendcolor=$dq_sendcolor&dq_show_filesystem_check=$dq_show_filesystem_check&dq_show_verbose=$dq_show_verbose&dq_you_have_no_limit=$dq_you_have_no_limit&dq_ignore=$dq_ignore");

}

echo '<h2 align="center"><strong><em><font color=' . "\"$color[8]\">";
echo _("Ok, but what does it mean?") . '</font></em></strong></h2>';
echo '<table align="center" ' . "border=$dq_table_border_size>";

if ( $dq_show_filesystem_check == 1 ) {

echo "  <tr>";
echo "    <td bgcolor=\"$color[5]\">" . '<div align="center"><strong>&nbsp;' .
          _("Filesystem") . '&nbsp;</strong></div></td>';
echo "    <td bgcolor=\"$color[0]\">" . '<div align="center">&nbsp;' .
          _("This is the physical device your data resides on") . '&nbsp;</div></td>';
echo '  </tr>';
echo "  <tr>";

}

echo "    <td bgcolor=\"$color[5]\">" . '<div align="center"><strong>&nbsp;' .
          _("Used") . '&nbsp;</strong></div></td>';
echo "    <td bgcolor=\"$color[0]\">" . '<div align="center">&nbsp;' .
          _("This is your actual amount of data on the physical device") . '&nbsp;</div></td>';
echo '  </tr>';
echo '  <tr>';
echo "    <td bgcolor=\"$color[5]\">" . '<div align="center"><strong>&nbsp;' .
          _("Quota") . '&nbsp;</strong></div></td>';
echo "    <td bgcolor=\"$color[0]\">" . '<div align="center">&nbsp;' .
          _("This is the amount of disk-space that you can use") . '&nbsp;</div></td>';
echo '  </tr>';
echo '  <tr>';
echo "    <td bgcolor=\"$color[5]\">" . '<div align="center"><strong>&nbsp;' .
          _("Limit") . '&nbsp;</strong></div></td>';
echo "    <td bgcolor=\"$color[0]\">" . '<div align="center">&nbsp;' .
          _("This is the absolute disk-space you cannot exceed") . '&nbsp;</div></td>';
echo '  </tr>';
echo '  <tr>';
echo "    <td bgcolor=\"$color[5]\">" . '<div align="center"><strong>&nbsp;' .
          _("Grace-Time") . '&nbsp;</strong></div></td>';
echo "    <td bgcolor=\"$color[0]\">" . '<div align="center">&nbsp;' .
          _("This shows the time left in which you can delete messages once you have exceeded your quota limit") . '&nbsp;</div></td>';
echo '  </tr>';
echo '  <tr>';
echo "    <td bgcolor=\"$color[5]\">" . '<div align="center"><strong>&nbsp;' .
          _("Status") . '&nbsp;</strong></div></td>';
echo "    <td bgcolor=\"$color[0]\">" . '<div align="center">&nbsp;' .
          _("This is your current status") . '&nbsp;</div></td>';
echo '  </tr>';
echo '</table>';

echo '<br><br>';

echo "<table border=$dq_table_border_size>";
echo '  <tr bgcolor=' . "\"$color[5]\">";
echo '    <td><div align="center"><strong>' .
          _("What's the difference between Quota and Limit?") . '</strong></div></td>';
echo '  </tr>';
echo '  <tr bgcolor=' . "\"$color[0]\">";
echo '    <td><div align="center">' .
          _("Well, you have a limited amount of disk-space available for your data. ") .
          _("You have two kind of limits. Between the first one (called Quota) and the second one ") .
          _("(called Limit) the system will still let you work for some more time ") .
          _("(the so colled Grace-Time) but if you exceed \"Limit\", the system will ") .
          _("prevent you from creating new files. Please notice that once your Grace-Time ") .
          _("is expired, you won't be able do anything than delete files!") . '</div></td>';
echo '  </tr>';
echo '  <tr bgcolor=' . "\"$color[5]\">";
echo '    <td><div align="center"><strong>' .
          _("I see an") .
          '&nbsp;<img src="../disk_quota/images/EXCEED.png" width="14" height="13">&nbsp;' .
          _("in the status-field. What's that?") . "</strong></div></td>";
echo '  </tr>';
echo '  <tr bgcolor=' . "\"$color[0]\">";
echo '    <td><div align="center">' .
          _("It's bad news. It means that you will not be able to work anymore on the system ") .
          _("unless you immediately trash & purge some of your data. Please consider the ") .
          _("possibility of moving some data on your local computer rather than leave it all ") .
          _("on the server.") . '</div></td>';
echo '  </tr>';
echo '</table>';
echo '</center>';

textdomain('squirrelmail');

?>
