<?php

$dq_quota_binary = str_replace("_", " ", $dq_quota_binary);

exec("$dq_quota_binary -v $username", $quota_data, $return_data);

/*
 * Some explanation before we go on.
 * The typical output from quota command is like that:
 *
 *       Disk quotas for user username (uid 501):
 *            Filesystem  blocks   quota   limit   grace   files   quota   limit   grace
 *              /dev/md0    8940       0       0             854       0       0
 *              /dev/hda2      0       0       0               0       0       0
 *              /dev/md1 2504904 3000000 3500000           10125       0       0
 *
 * It means that the we will skip the first two lines and
 * we will also skip the filesystems which the user doesn't have
 * any files on. This is for simplicity and to avoid confusion.
 * that's why $i in the for-cycle will start from 2, not
 * from 0.
*/

$color = "#$dq_sendcolor";

if ( sizeof($quota_data) > 2 ) {

  for ( $i=2 ; $i<sizeof($quota_data) ; $i++ ) {

    $splitted = split( "[[:blank:]]+", trim($quota_data[$i]) );

    if ( $dq_show_filesystem_check == 1 ) {
      $dq_start = 0;
    }
    elseif ( $dq_show_filesystem_check == 0 ) {
      $dq_start = 1;
    }
    if ( $dq_show_verbose == 0 ) {

      if ( !$splitted[1] == 0 ) {

        echo '  <tr bgcolor=' . "\"$color\">";
        for ( $j=$dq_start ; $j<4 ; $j++ ) {

          echo '<td><div align="center">' . $splitted[$j] . '</td>';

        }
        if ( $splitted[1]<$splitted[2] && $splitted[2] != 0 ) {

          echo '<td><div align="center">-</td>';
          echo '<td><div align="center">' .
               '<img src="../disk_quota/images/OK.png" width="14" height="13"></td>';
        }
        elseif ( !$splitted[1]<$splitted[2] && $splitted[2] != 0 ) {

          echo '<td><div align="center">' . $splitted[$j] . '</td>';
          echo '<td><div align="center">' .
               '<img src="../disk_quota/images/EXCEED.png" width="14" height="13"></td>';
        }
        elseif ( $splitted[2] == 0 ) {

          echo '<td><div align="center">-</td>';
          echo '<td><div align="center">' .
               '<img src="../disk_quota/images/OK.png" width="14" height="13"></td>';
        }
        echo '</tr>';
      }
    }
    elseif ( $dq_show_verbose == 1 ) {

      echo '  <tr bgcolor=' . "\"$color\">";
      for ( $j=$dq_start ; $j<4 ; $j++ ) {

        echo '<td><div align="center">' . $splitted[$j] . '</td>';

      }
      if ( $splitted[1]<$splitted[2] && $splitted[2] != 0 ) {

        echo '<td><div align="center">-</td>';
        echo '<td><div align="center">' .
             '<img src="../disk_quota/images/OK.png" width="14" height="13"></td>';
      }
      elseif ( !$splitted[1]<$splitted[2] && $splitted[2] != 0 ) {

        echo '<td><div align="center">' . $splitted[$j] . '</td>';
        echo '<td><div align="center">' .
             '<img src="../disk_quota/images/EXCEED.png" width="14" height="13"></td>';
      }
      elseif ( $splitted[2] == 0 ) {

        echo '<td><div align="center">-</td>';
        echo '<td><div align="center">' .
             '<img src="../disk_quota/images/OK.png" width="14" height="13"></td>';
      }
      echo '</tr>';
    }
  }

  echo '</table>';

}
else {

  $dq_you_have_no_limit = str_replace("_", " ", $dq_you_have_no_limit);
  $dq_ignore = str_replace("_", " ", $dq_ignore);
  echo '</td></tr></table>';
  echo '<h3 align="center">' . $dq_you_have_no_limit . '<br>' . $dq_ignore . '</h3>';

}

?>
