<?php

/**
  * SquirrelMail Debugger
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under BSD (because some portions of
  * the source are already licensed under BSD; typical SquirrelMail
  * license is GPL). See COPYING for details
  *
  */



/**
  * Inserts link to debugger popup window in main menu bar
  *
  */
function debug_menu_link_do()
{

   // get global variable for versions of PHP < 4.1
   //
   if (!check_php_version(4,1)) {
      global $HTTP_SERVER_VARS, $HTTP_SESSION_VARS, $HTTP_POST_VARS, $HTTP_GET_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
//      $_SESSION = $HTTP_SESSION_VARS;
      $_POST = $HTTP_POST_VARS;
      $_GET = $HTTP_GET_VARS;
   }

   $get = formatArray($_GET);
   $post = formatArray($_POST);
   $server = formatArray($_SERVER);
//   $session = formatArray($_SESSION);
//$get = '';
//$post = '';
//$server = '';
//$session = '';

   bindtextdomain ('debugger', SM_PATH . 'locale');
   textdomain ('debugger');

   //displayInternalLink("plugins/debugger/popup.php", _("Debugger"), '_blank');

   // session is too big for javascript variable
   //
   //echo '<a href="#" onclick="newwin=window.open(\'\', \'debug_win\', \'resizable=yes, scrollbars=yes, width=300, height=300\'); newwin.document.open(); newwin.document.write(\'<html><head><title>SquirrelMail Debugger</title></head><body><strong>GET:</strong><br />' . $get . '<br /><strong>POST</strong><br />' . $post . '<br /><strong>SESSION</strong><br />' . $session . '<br /><strong>SERVER</strong><br />' . $server . '<br /></body></html>\'); newwin.document.close(); return false;">' . _("Debugger") . '</a>';

   echo '<a href="#" onclick="document.debuggerform.submit(); return false;">' . _("Debugger") . '</a>';

   echo '<form style="margin:0" action="' . SM_PATH . 'plugins/debugger/popup.php" method="POST" target="_blank" name="debuggerform">'
      . '<input type="hidden" name="myget" value="' . $get . '" />'
      . '<input type="hidden" name="mypost" value="' . $post . '" />'
      . '<input type="hidden" name="myserver" value="' . $server . '" />'
      . '</form>';

   echo "&nbsp;&nbsp\n";

   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



/** 
  * Formats array (possibly with nested arrays/can be 
  * called recursively) for output in HTML.
  *
  * @param array $arr The array to be formatted
  *
  * @return string The HTML-formatted array.
  */
function formatArray($arr)
{

   ob_start();
   sm_print_r($arr);
   $output = ob_get_contents();
   ob_end_clean();

   // a little more formatting for use in javascript
   //
   $output = str_replace(array("\n", '\''), array('<br />', '\\\''), $output);
   //$output = str_replace(array("\n"), array('<br />'), $output);
   //$output = str_replace(array('\''), array('\\\''), $output);

   return $output;

}



?>
