<?php
/**
 * plugins/custom_charset/setup.php -- Main setup script
 *
 * SquirrelMail Custom Charset Plugin
 * This program is licensed under GPL. See COPYING for details
 *
 * @copyright (c) 2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * @version $Id: setup.php,v 1.3 2005/03/08 09:05:57 tokul Exp $
 * @package sm-plugins
 * @subpackage custom_charset
 */

/*
 * make sure SM_PATH is defined
 * @ignore
 */
if (!defined('SM_PATH'))  {
    define('SM_PATH','../../');
}

/**
 * init function
 */
function squirrelmail_plugin_init_custom_charset() {
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['loading_prefs']['custom_charset'] = 'custom_charset_prefs';
    $squirrelmail_plugin_hooks['optpage_loadhook_display']['custom_charset'] = 'custom_charset_optblock';
}

/**
 * loads plugin preferences
 */
function custom_charset_prefs() {
    include_once(SM_PATH . 'plugins/custom_charset/functions.php');
    custom_charset_prefs_function();
}

/**
 * adds custom_charset options to display option block
 */
function custom_charset_optblock() {
    include_once(SM_PATH . 'plugins/custom_charset/functions.php');
    custom_charset_optblock_function();
}

/**
 * shows plugin's version
 * @return string
 */
function custom_charset_version() {
    return '1.0';
}
?>