<?php


/**
  * SquirrelMail Compose Extras Plugin
  * Copyright (c) 2004-2005 Bruce Richardson <itsbruce@uklinux.net>
  *                         Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage Compose Extras
  *
  */



/**
  * Integrate options into SM options page
  *
  */
function cf_show_options_do($hookName)
{

   // 1.4.x - 1.5.0:  options go on display options page
   // 1.5.1  and up:  options go on compose options page
   //
   if (check_sm_version(1, 5, 1) && $hookName[0] != 'optpage_loadhook_compose')
      return;
   if (!check_sm_version(1, 5, 1) && $hookName[0] != 'optpage_loadhook_display')
      return;


   if ($hookName[0] == 'optpage_loadhook_display')
   {
      $tabsIndex = 2;
      $blankLinesIndex = 2;
   }
   else
   {
      $tabsIndex = 0;
      $blankLinesIndex = 1;
   }


   global $data_dir, $username;
   $tabs = getPref($data_dir, $username, 'fix_compose_tabs', 1);
   $insert_lines_in_reply_body = getPref($data_dir, $username, 'insert_lines_in_reply_body', 2);

   bindtextdomain('compose_fix', SM_PATH . 'locale');
   textdomain('compose_fix');

   global $optpage_data;
   $optpage_data['vals'][$tabsIndex][] = array(
      'name'          => 'fix_compose_tabs',
      'caption'       => _("Compose Window Tab Order"),
      'type'          => SMOPT_TYPE_STRLIST,
      'initial_value' => $tabs,
      'refresh'       => SMOPT_REFRESH_NONE,
      'posvals'       => array(0 => _("Default"),
                               1 => _("To-Subject-Message"),
                               2 => _("To-Cc-Bcc-Subject-Message")),
   );

   $optpage_data['vals'][$blankLinesIndex][] = array(
      'name'          => 'insert_lines_in_reply_body',
      'caption'       => _("Insert Blank Lines At Top Of Reply Body"),
      'type'          => SMOPT_TYPE_STRLIST,
      'initial_value' => $insert_lines_in_reply_body,
      'refresh'       => SMOPT_REFRESH_NONE,
      'posvals'       => array(0 => 0,
                               1 => 1,
                               2 => 2,
                               3 => 3,
                               4 => 4,
                               5 => 5),
   );

   bindtextdomain('squirrelmail', SM_PATH . 'locale');
   textdomain('squirrelmail');

}



/**
  * Inserts javascript for tab fixes
  *
  */
function cf_compose_go_do()
{

   global $username, $data_dir, $javascript_on;


   if (!$javascript_on)
      return;


   // make submit button disable itself when clicked once
   //
/* too bad... when form widgets are disabled, they are not sent in with the POST,
   making this code unusable, since SM looks for the button that was clicked by name

   echo "<script language='JavaScript' type='text/javascript'>\n"
      . "<!--\n"
      . "document.compose.onsubmit = disableSendBtn;\n"
      . "function disableSendBtn() {\n"
      . "  document.compose.send.disabled = true;\n"
      . "  document.compose.sigappend.disabled = true;\n"
      . "  document.compose.draft.disabled = true;\n"
      . "  document.compose.attach.disabled = true;\n"
      . "  if (typeof(document.compose.html_addr_search) != 'undefined')\n"
      . "      document.compose.html_addr_search.disabled = true;\n"
      . "  if (typeof(document.compose.open_chars) != 'undefined')\n"
      . "      document.compose.open_chars.disabled = true;\n"
      . "  if (typeof(document.compose.QScancel) != 'undefined')\n"
      . "      document.compose.QScancel.disabled = true;\n"
      . "  if (typeof(document.compose.template_button) != 'undefined')\n"
      . "      document.compose.template_button.disabled = true;\n"
      . "  if (typeof(document.compose.check_spelling) != 'undefined')\n"
      . "      document.compose.check_spelling.disabled = true;\n"
//      . "  if (typeof(document.compose.xxx) != 'undefined')\n"
//      . "      document.compose.xxx.disabled = true;\n"
      . "}\n"
      . "\n// -->\n</script>\n";
*/


   $tabs = getPref($data_dir, $username, 'fix_compose_tabs', 1);


   if ($tabs == 1) 
      include(SM_PATH . 'plugins/compose_fix/tabs1.js');


   else if ($tabs == 2) 
      include(SM_PATH . 'plugins/compose_fix/tabs2.js');

}



/**
  * Adjusts body text as needed
  *
  */
function cf_fix_body_do()
{

   global $username, $data_dir, $smaction;


   sqgetGlobalVar('smaction', $smaction, SQ_FORM);
   if ($smaction != 'reply' && $smaction != 'reply_all' && $smaction != 'forward')
//    && $smaction != 'draft' && $smaction != 'edit_as_new')
      return;


   $insert_lines_in_reply_body = getPref($data_dir, $username, 'insert_lines_in_reply_body', 2);


   if ($insert_lines_in_reply_body < 1)
      return;

   global $body;

   for ($i = 0; $i <= $insert_lines_in_reply_body; $i++)
      $body = "\n" . $body;

}



?>
