<?php

/**
  * SquirrelMail Cleanup Plugin
  * Copyright (c) 2003 Jimmy Conner <jimmy@advcs.org>,
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage cleanup
  *
  */

global $cleanup_frequency, $save_files_patterns, $save_directories,
       $delete_attachment_files_older_than, $cleanup_attachments;


// How often should cleanup happen?  This is the number
// of days between cleanups.
//
$cleanup_frequency = 7;



// Should this plugin attempt to cleanup the SquirrelMail
// attachments directory?
//
// 1 = yes, 0 (zero) = no
//
$cleanup_attachments = 1;



// How old (number of days) must an attachment file be
// before it will be deleted?
//
// Has no effect if $cleanup_attachments is turned off.
//
$delete_attachment_files_older_than = 2;



// This is a list of patterns (NOT regular expression style)
// that, if found anywhere in a file name, will prevent a
// file from being deleted during cleanup.
//
// This usually does not need to be changed.  Please report
// any changes herein that may be useful to the larger
// SquirrelMail community.
//
// Has no effect if $cleanup_attachments is turned off.
//
$save_files_patterns = array(
   '.cal',
   'dnscache',
   '.block',
   '.words',
   '.sig',
   '.si',
   '.notes',
   '.php',
   '.abook',
   '.vcf',
   '.pref',
   '.htaccess',
   'default_pref',
);



// This is a list of subdirectory names that are not to
// be scanned
//
// Has no effect if $cleanup_attachments is turned off.
//
$save_directories = array(
);



