<?php

/*******************************************************************************

	Original Author  Galen Johnson
	Contact  ......  gjohnson@trantor.org
	Program  ......  SquirrelMail Plugin - Change Cyrus Password
	Mods by .......  Brad Donison
	Version  ......  1.4

*******************************************************************************/

/* i18n.php defines the _() syntax */
include_once(SM_PATH . 'functions/i18n.php');
bindtextdomain('chg_sasl_passwd', '../plugins/chg_sasl_passwd/locale');
 
function squirrelmail_plugin_init_chg_sasl_passwd() {
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['logout_above_text']['chg_sasl_passwd'] =
        'logout_user_explanation';
    $squirrelmail_plugin_hooks['optpage_register_block']['chg_sasl_passwd'] =
        'chg_sasl_passwd_optpage_register_block';

    return;
}

function logout_user_explanation()
{
//    global $HTTP_SERVER_VARS;
    textdomain('chg_sasl_passwd');

    if (isset($_SERVER['QUERY_STRING']) &&
        stristr($_SERVER['QUERY_STRING'], 'chg_sasl_passwd') )
        echo "<br><b>" . _("Your password has been changed. This requires that you logout and then log back in with the new password.") .
             "<br><p><br>\n" . _("Logging out automagically") . ".<br><br>\n";

    /* Switch back to the SquirrelMail domain */
    textdomain('squirrelmail');
}

function chg_sasl_passwd_optpage_register_block () {
    global $optpage_blocks;
    textdomain('chg_sasl_passwd');

    $optpage_blocks[] = array (
        'name' => _("Change Password"),
        'url'  => '../plugins/chg_sasl_passwd/options.php',
        'desc' => _("Change the password to your email account (NOTE: you must know your current password to make any changes)."),
        'js'   => false);

    /* Switch back to the SquirrelMail domain */
    textdomain('squirrelmail');

    return;
}

function chg_sasl_passwd_version () {
    return '1.4';
}

?>
