<?php

/*******************************************************************************

	Original Author  Galen Johnson
	Contact  ......  gjohnson@trantor.org
	Program  ......  SquirrelMail Plugin - Change Cyrus Password
	Mods by .......  Brad Donison
	Version  ......  1.4

*******************************************************************************/
define('SM_PATH','../../');

// chdir ('..');
include_once (SM_PATH . 'include/validate.php');
/* i18n.php defines the _() syntax */
include_once (SM_PATH . 'functions/i18n.php');
include_once (SM_PATH . 'functions/page_header.php');
include_once (SM_PATH . 'include/load_prefs.php');
include_once (SM_PATH . 'plugins/chg_sasl_passwd/config.php');

global $username, $data_dir, $plugins, $chg_sasl_passwd_barredlist,
       $chg_sasl_passwd_MinPWLen, $chg_sasl_passwd_MaxPWLen,
       $chg_sasl_passwd_display, $chgsaslpasswd_cmd;

//$chgsaslpasswd_cmd = SM_PATH . "plugins/chg_sasl_passwd/chgsaslpasswd";

/* Now tell gettext where the locale directory for your plugin is
 * this is in relation to the src/ directory
 */
bindtextdomain('chg_sasl_passwd', SM_PATH . 'plugins/chg_sasl_passwd/locale');

if (isset ($_POST['password_submit'])) {

// Mods for rg=off as suggested by Thijs Kinkhorst
    $key = $_COOKIE['key'];
    $onetimepad = $_SESSION['onetimepad'];
    $clear = OneTimePadDecrypt($key, $onetimepad);

    $userid   = $username;
    sqgetGlobalVar('new_pw', $new_pw);
    sqgetGlobalVar('current_pw', $current_pw);
    sqgetGlobalVar('confirm_pw', $confirm_pw);

    if ($userid == '' || $current_pw == '' ||
        $new_pw == '' || $confirm_pw == '') {
        show_error('1');
    } elseif ($new_pw != $confirm_pw) {
        show_error('2');
    } elseif ($current_pw != $clear) {
        show_error('3');
    } elseif (strlen($new_pw) < $GLOBALS['chg_sasl_passwd_MinPWLen']) {
        show_error('4');
    } elseif (strlen($new_pw) > $GLOBALS['chg_sasl_passwd_MaxPWLen']) {
        show_error('5');
    } elseif (strcmp($new_pw, $current_pw) == 0) {
        show_error('6');
    } else {
        if (! in_array($username, $chg_sasl_passwd_barredlist)) {
            $fh=popen("$chgsaslpasswd_cmd -p $username","w");
            fwrite($fh,"$new_pw\n");
            pclose($fh);
        }
        echo '<META HTTP-EQUIV="REFRESH" CONTENT="0;URL=../../src/signout.php?chg_sasl_passwd">' .
             "\n<script language='javascript'>\n" .
             "<!-- hide from stupid browsers\n" .
             "var dir_path = window.location.pathname.substr" .
             "(0,window.location.pathname.lastIndexOf('/'));\n" .
             "setTimeout('parent.window.location =" .
             ' "" + dir_path + "/../../src/signout.php?chg_sasl_passwd";' . "', 0);\n" .
             "//-->\n</script>\n";

        echo "<H2>" . _("Your password has successfully been changed.") . "</H2>\n";
        echo '<div align=center>' . _("Please") . '<a href="' . SM_PATH .
             'src/signout.php?chg_sasl_passwd" TARGET=_top>' .
             _("logout and log back in using your new password.") . "</div>\n";
    }
    textdomain('squirrelmail');
} else {
    displayPageHeader($GLOBALS['color'], 'None');
    textdomain('chg_sasl_passwd');

    $display_address = $username;
    if ($chg_sasl_passwd_display == 1) {
      $display_address = getPref($data_dir, $username, 'email_address');
    } elseif ($chg_sasl_passwd_display == 2) {
      if (file_exists($chg_sasl_passwd_vutfile)) {
        $file = fopen($chg_sasl_passwd_vutfile, 'r');
        $acaba = 0;
        $realname = "";

        /* Read in the file. */
        while ((!feof($file)) && (!$acaba)) {
          $linia = trim(fgets($file, 1024));
          if (preg_match ("/^(\S+)\s+$username\s*/i", $linia, $resultat)) {
            $acaba=1;
            $display_address = $resultat[1];
          }
        }
        fclose($file);
      }
    }

    echo "<br>\n" .
         '<table width=350 align=center border=0 cellpadding=4 cellspacing=0>' .
         "<tr>\n" .
           '  <td valign=center align=center  bgcolor="' . $color[0] . '">' .
           '<center><b>' . _("Change Email Password") .
           '</b> for ' . $display_address . "</center>\n" .
             '  <form action="options.php" method=post>' . "\n" .
             '    <table border="0" cellpadding="2" cellspacing="0" bgcolor="' .
             $color[4] . '">'.
         "</tr><tr>\n" .
           '    <td align="left" style="padding-left: 20px;">' . _("Old Password:") .
           "</td>\n" .
           '    <td align="left" style="padding-right: 20px;">' .
//         '<input type=hidden name=userid value="';
//  echo $username;
//  echo '">'.
         '<input type=password size=16 maxlen=' .
         $GLOBALS['chg_sasl_passwd_MaxPWLen'] . ' name=current_pw value=""'.
         '</td>' . "</tr><tr>\n" .
         '    <td align="left" style="padding-left: 20px;">' . _("New Password:") .
         "</td>\n" .
         '    <td align="left" style="padding-right: 20px;">' .
         '<input type=password size=16 maxlen=32 name=new_pw value=""'.
         "</td></tr><tr>\n" .
         '    <td align="left" style="padding-left: 20px;">' . _("Confirm:") .
         "</td>\n" .
         '    <td align="left" style="padding-right: 20px;">'.
         '<input type=password size=16 maxlen=32 name=confirm_pw value=""'.
         "</td></tr>\n";
    if (isset($chg_sasl_passwd_MinPWLen)) {
      echo "<tr><td colspan='2'>Your New password must be at least <b>" .
           $chg_sasl_passwd_MinPWLen . " characters</b>";
      if (isset($chg_sasl_passwd_MaxPWLen)) {
        echo ", and no more than <b>" . $chg_sasl_passwd_MaxPWLen . " characters</b>";
      }
      echo " long .</td></tr>\n";
    }
    echo "</table><br>\n" .
           "</td></tr><tr>\n" .
           '  <td>' . '<b><font color=red size=-1>' .
           _("WARNING! Changing your password will automatically log you out! After you are logged out, you may then log back in with your New password.") .
           '</font></b>'.
           "</td></tr><tr>\n" .
           "  <td><br>\n" .
           '<center>' .
           '<input type=submit name=password_submit value=' . _("Change") . '>' .
           "</center></form>\n" .
           "</td></tr></table>\n";
    textdomain('squirrelmail');
}


/******************************************************************************/

function show_error($code) {
    displayPageHeader($GLOBALS['color'], 'None');
    textdomain('chg_sasl_passwd');
    echo '<br>' .
         '<table width=300 align=center border=0 cellpadding=4 cellspacing=0>' .
         "<tr>\n" .
           '  <td valign=center align=center  bgcolor=red>' .
           '<center><b>' . _("Error") . ' -  ' . _("Change Email Password") .
           '</b></center>' .  "</td>\n" .
         "</tr><tr>\n" .
           '  <td>';

    if ( $code == '1' ) {
        echo _("You have left a field blank. ") .
             _("Please use your browser's back button to correct the information."); 
    } elseif ($code == '2') {
        echo _("Your passwords do not match. ") .
             _("Please use your browser's back button to correct the information."); 
    } elseif ($code == '3') {
        echo _("Your old password is incorrect. ") .
             _("Please use your browser's back button to correct the information.");
    } elseif ($code == '4') {
        echo _("The new password you chose is too small. ") .
             _("Please use your browser's back button to correct the information.") . " " .
             _("The password must be between ") . $GLOBALS['chg_sasl_passwd_MinPWLen'] .
             _(" and ") . $GLOBALS['chg_sasl_passwd_MaxPWLen'] .
             _(" characters long."); 
    } elseif ($code == '5') {
        echo _("The new password you chose is too long. ") .
             _("Please use your browser's back button to correct the information.") . " " .
             _("The password must be between ") . $GLOBALS['chg_sasl_passwd_MinPWLen'] .
             _(" and ") . $GLOBALS['chg_sasl_passwd_MaxPWLen'] . _(" characters long."); 
    } elseif ($code == '6') {
        echo _("Your NEW password is the same as your OLD password, please choose a different NEW password."); 
    } else {
        echo _("The plugin has encountered an unknown error.  Please inform customer support of this."); 
    }

    echo "</td></tr></table>\n";
    textdomain('squirrelmail');
    return;
}

?>
