<?php

/*******************************************************************************

	Author  .......  Galen Johnson
	Contact  ......  gjohnson@trantor.org
	Home Site  ....  http://
	Program  ......  SquirrelMail Plugin - Change Cyrus Password
	Version  ......  1.4

*******************************************************************************/
define('SM_PATH','../');

chdir ('..');
include_once (SM_PATH . 'include/validate.php');
/* i18n.php defines the _() syntax */
include_once(SM_PATH . 'functions/i18n.php');
include_once (SM_PATH . 'functions/page_header.php');
include_once (SM_PATH . 'include/load_prefs.php');
include_once (SM_PATH . 'plugins/chg_sasl_passwd/config.php');

// $chgsaslpasswd_cmd = SM_PATH . "plugins/chg_sasl_passwd/chgsaslpasswd";

/* Now tell gettext where the locale directory for your plugin is
 * this is in relation to the src/ directory
 */
bindtextdomain('chg_sasl_passwd', SM_PATH . 'plugins/chg_sasl_passwd/locale');

if (isset ($_POST['password_submit'])) {

    displayPageHeader($GLOBALS['color'], 'None');

// Mods for rg=off as suggested by Thijs Kinkhorst
    $key = $_COOKIE['key'];
    $onetimepad = $_SESSION['onetimepad'];
    $clear = OneTimePadDecrypt($key, $onetimepad);

    $userid = $_POST['userid'];
    $new_pw = $_POST['new_pw'];
    $new_pw = escapeshellcmd("$new_pw");
    $username = escapeshellcmd("$userid");

    if ($_POST['userid'] == '' || $_POST['current_pw'] == '' || $_POST['new_pw'] == '' || $_POST['confirm_pw'] == '') {
        show_error('1');
    } elseif ( $_POST['new_pw'] != $_POST['confirm_pw'] ) {
        show_error('2');
    } elseif ($_POST['current_pw'] != $clear) {
        show_error('3');
    } elseif (strlen($new_pw) < $GLOBALS['chg_sasl_passwd_MinPWLen']) {
        show_error('4');
    } else {
        $fh=popen($GLOBALS['chgsaslpasswd_cmd'] . " -p $username","w");
        fwrite($fh,"$new_pw\n");
        pclose($fh);

        textdomain('chg_sasl_passwd');

        echo '<META HTTP-EQUIV="REFRESH" CONTENT="0;URL=../../src/signout.php?chg_sasl_passwd">' .
             "\n<script language='javascript'>\n" .
             "<!-- hide from stupid browsers\n" .
             "var dir_path = window.location.pathname.substr" .
             "(0,window.location.pathname.lastIndexOf('/'));\n" .
             "setTimeout('parent.window.location =" .
             ' "" + dir_path + "/../../src/signout.php?chg_sasl_passwd";' . "', 0);\n" .
             "//-->\n</script>\n";

        echo "<H2>" . _("Your password has successfully been changed.") . "</H2>\n";
        echo '<div align=center>' . _("Please ") . '<a href="' . SM_PATH .
             'src/signout.php?chg_sasl_passwd" TARGET=_top>' .
             _("logout and log back in</a> using your new password.") . "</div>\n";
    }

    textdomain('squirrelmail');

} else {

displayPageHeader($GLOBALS['color'], 'None');
textdomain('chg_sasl_passwd');

echo    '<br>' .
    '<table width=260 align=center border=0 cellpadding=4 cellspacing=0>'.
        '<tr>'.
            '<td valign=center align=center  bgcolor="' . $color[0] . '">'.
                '<center><b>' . _("Options") . ' -  ' . _("Change Email Password") . '</b></center>'.
                '<form action="options.php" method=post>'.
                '<input type=hidden name=userid value="';
                echo $username;
                echo '">'.
                '<table border="0" cellpadding="2" cellspacing="0" bgcolor="' . $color[4] . '">'.
                    '<tr>'.
                        '<td align="left" style="padding-left: 20px;">' . _("Old Password:") .
                        '</td>'.
                        '<td align="left" style="padding-right: 20px;">'.
                            '<input type=password size=16 maxlen=' .
                            $GLOBALS['chg_sasl_passwd_MaxPWLen'] . ' name=current_pw value=""'.
                        '</td>'.
                    '</tr>'.
                    '<tr>'.
                        '<td align="left" style="padding-left: 20px;">' . _("New Password:") .
                        '</td>' .
                        '<td align="left" style="padding-right: 20px;">'.
                            '<input type=password size=16 maxlen=32 name=new_pw value=""'.
                        '</td>'.
                    '</tr>'.
                    '<tr>'.
                        '<td align="left" style="padding-left: 20px;">' . _("Confirm:") .
                        '</td>'.
                        '<td align="left" style="padding-right: 20px;">'.
                            '<input type=password size=16 maxlen=32 name=confirm_pw value=""'.
                        '</td>'.
                    '</tr>'.
                '</table><br>'.
            '<td>'.
        '</tr>'.
        '<tr>'.
            '<td>'.
                '<b><font color=red size=-1>' . _("WARNING! Changing your password will automatically log you out! If you are unable to log back in, please contact your friendly system adminstrator.") . '</font></b>'.
            '</td>'.
        '</tr>'.
        '<tr>'.
            '<td>'.
                '<br><center>'.
                '<input type=submit name=password_submit value=' . _("Change") . '>'.
                '</center></form>'.
            '</td>'.
        '</tr>'.
    '</table>';

    textdomain('squirrelmail');
}


/******************************************************************************/

function show_error($code)
{
    textdomain('chg_sasl_passwd');
    echo    '<br>' .
        '<table width=300 align=center border=0 cellpadding=4 cellspacing=0>'.
            '<tr>'.
                '<td valign=center align=center  bgcolor=red>'.
                    '<center><b>' . _("Error") . ' -  ' . _("Change Email Password") . '</b></center>'.
                '</td>'.
             '</tr>'.
             '<tr>'.
                '<td>';

                    if ( $code == '1' ) {
                       echo _("You have left a field blank.  Please use your browser's back button and enter the missing information."); 
                    } elseif ($code == '2') {
                       echo _("Your new password does not match.  Please use your browser's back button and re-enter your new password."); 
                    } elseif ($code == '3') {
                       echo _("Your old password is incorrect.  Please use your browser's back button and enter it correctly."); 
                    } elseif ($code == '4') {
                       echo _("The password you chose to be your new password is too short. Please use your browser's back button and choose a different password, (longer and harder to guess). The password must be between " . $GLOBALS['chg_sasl_passwd_MinPWLen'] . " and " . $GLOBALS['chg_sasl_passwd_MaxPWLen'] . " characters long.");
                    } else {
                       echo _("The plugin has encountered an unknown error.  Please inform your system administrator."); 
                    }

    echo        '</td>'.
            '</tr>'.
        '</table>';
    textdomain('squirrelmail');
    return;
}

?>
