<?php

/*******************************************************************************

	Author  .......  Galen Johnson
	Contact  ......  gjohnson@trantor.org
	Home Site  ....  http://
	Program  ......  SquirrelMail Plugin - Change Cyrus Password
	Version  ......  1.3

*******************************************************************************/
define('SM_PATH','../');

/* i18n.php defines the _() syntax */
include_once(SM_PATH . 'functions/i18n.php');
bindtextdomain('chg_sasl_passwd', '../plugins/chg_sasl_passwd/locale');
 
function squirrelmail_plugin_init_chg_sasl_passwd()
{
	global $squirrelmail_plugin_hooks;

	$squirrelmail_plugin_hooks['logout_above_text']['chg_sasl_passwd'] = 'logout_user_explanation';
	$squirrelmail_plugin_hooks['optpage_register_block']['chg_sasl_passwd'] = 'chg_sasl_passwd_optpage_register_block';

	return;
}

function logout_user_explanation()
{
//    global $HTTP_SERVER_VARS;
    textdomain('chg_sasl_passwd');

    if ( isset($_SERVER['QUERY_STRING']) && stristr($_SERVER['QUERY_STRING'], 'chg_sasl_passwd') )

        echo "<br><b>" . _("Your password has been changed.  This requires that you reauthenticate with the new password. Logging out automagically.") . "<br><br>\n";

	/* Switch back to the SquirrelMail domain */
	textdomain('squirrelmail');
}

function chg_sasl_passwd_optpage_register_block ()
{
	global $optpage_blocks;
        textdomain('chg_sasl_passwd');

	$optpage_blocks[] = array (
		'name' => _("Change Cyrus Password"),
		'url'  => '../plugins/chg_sasl_passwd/options.php',
		'desc' => _("Cyrus SASL database authentication allows your Cyrus/squirrelmail installation to host mail users without requiring a Unix Shell account!<br><b><font size=-2>NOTE: This plugin only covers the &quot;sasldb&quot; case when using Cyrus SASL.  Kerberos and PAM authentication mechanisms will require other techniques to enable user password manipulations.</font></b>"),
		'js'   => false);

	/* Switch back to the SquirrelMail domain */
	textdomain('squirrelmail');

	return;
}

?>
