<?php

global $username, $key, $imapServerAddress, $imapPort, 
       $imap_stream, $imapConnection, 
       $UseSeparateImapConnection;

/*
 * Detect if we have already connected to IMAP or not.
 * Also check if we are forced to use a separate IMAP connection
*/

if ( (!isset($imap_stream) && !isset($imapConnection)) || $UseSeparateImapConnection )
{
	$stream = sqimap_login($username, $key, $imapServerAddress, $imapPort, 10);
	$previously_connected = false;
} 
elseif (isset($imapConnection)) 
{
	$stream = $imapConnection;
	$previously_connected = true;
} 
else 
{
	$previously_connected = true;
	$stream = $imap_stream;
}

$cq_usage = sqimap_get_quota($stream, 'INBOX');
if ($quota_usage_debug)
{
	echo "Usage is: <br>";
	sm_print_r($cq_usage);
}

if ( strpos($cq_usage[0], 'NOQUOTA') === FALSE) 
{
	$cq_taken = $cq_usage[0];
	$cq_total = $cq_usage[1];
	$cq_count = $cq_usage[2];
	$cq_maxcount = $cq_usage[3];

	if ( $cq_taken != '' && $cq_total != '' && $cq_total != 0 )
	{
		$cq_size_quota = TRUE;
		$cq_percent = number_format(($cq_taken / $cq_total) * 100, 1);
	}
	else 
		$cq_size_quota = FALSE;

	if ( $cq_count != '' && $cq_maxcount != '' && $cq_maxcount != 0 )
	{
		$cq_count_quota = TRUE;
		$cq_countpercent = number_format(($cq_count / $cq_maxcount) * 100, 1);
	}
	else 
		$cq_count_quota = FALSE;

	if ( $cq_use_1000KB_per_MB )
	{
		$cq_quota_KB = $cq_total;
		$cq_taken_KB = $cq_taken;
		$cq_quota = number_format($cq_total / 1000, 1);
		$cq_taken = number_format($cq_taken / 1000, 1);
	}
	else
	{
		$cq_quota_KB = $cq_total;
		$cq_taken_KB = $cq_taken;
		$cq_quota = number_format($cq_total / 1024, 1);
		$cq_taken = number_format($cq_taken / 1024, 1);
	}

	if ( $fn_left == 1 )
		include("show_graph.php");
	if ( $fn_motd == 1 )
		include("show_motd.php");

	$cq_size_quota = FALSE;
	$cq_count_quota = FALSE;
}

if ( !$previously_connected )
	sqimap_logout($stream);

/*
 * Gets current quota usage from IMAP server
 *
 * @param resource $imap_stream An open stream to the IMAP server
 * @param string $mailbox The mail folder for which to check quota 
 *                        usage
 *
 * @return array A four-element array, consisting of numbers in kilobytes
 *               representing (in this order):  
 *                  - storage used (size quota)
 *                  - total storage available (size quota)
 *                  - messages used (message count quota)
 *                  - total messages available (message count quota)
 *               If either size or message count quota is not available,
 *               the corresponding numbers will instead be returned as
 *               empty strings.
 *               If no quota is given or available, the first element
 *               in the return array is given as "NOQUOTA".
 *
*/
function sqimap_get_quota ($imap_stream, $mailbox) 
{
	global $quota_usage_debug;

	if (check_quota_capability($imap_stream)) 
	{
		$imap_command = "a001 GETQUOTAROOT \"$mailbox\"\r\n";

		fputs ($imap_stream, $imap_command);
		$read_ary = sqimap_read_data ($imap_stream, 'a001', true, $result, $message);

		if (check_sm_version(1, 5, 0))
			$read_ary = $read_ary['a001'];

		if ($quota_usage_debug) 
		{
			echo "IMAP command sent: $imap_command<br />";
			echo 'IMAP response recieved:';
			sm_print_r($read_ary);
		}

		foreach ($read_ary as $response)
		{
			$storageUsed = '';
			$storageTotal = '';
			$messagesUsed = '';
			$messagesTotal = '';
			if (is_array($response))
				foreach ($response as $resp)
				{
					if (strpos($resp, 'STORAGE') !== FALSE || strpos($resp, 'MESSAGE') !== FALSE)
					{
						preg_match('/[(]([STORAGEMESSAGE0-9 ]+)[)]/', $resp, $matches);
						$usageArray = explode(' ', $matches[1]);
						if ($usageArray[0] == 'STORAGE')
							list($storageUsed, $storageTotal) = array($usageArray[1], $usageArray[2]);
						if (!empty($usageArray[3]) && $usageArray[3] == 'STORAGE')
							list($storageUsed, $storageTotal) = array($usageArray[4], $usageArray[5]);
						if ($usageArray[0] == 'MESSAGE')
							list($messagesUsed, $messagesTotal) = array($usageArray[1], $usageArray[2]);
						if (!empty($usageArray[3]) && $usageArray[3] == 'MESSAGE')
							list($messagesUsed, $messagesTotal) = array($usageArray[4], $usageArray[5]);
						return array($storageUsed, $storageTotal, $messagesUsed, $messagesTotal);
					}
				}
			else if (strpos($response, 'STORAGE') !== FALSE || strpos($response, 'MESSAGE') !== FALSE)
			{
				preg_match('/[(]([STORAGEMESSAGE0-9 ]+)[)]/', $response, $matches);
				$usageArray = explode(' ', $matches[1]);
				if ($usageArray[0] == 'STORAGE')
					list($storageUsed, $storageTotal) = array($usageArray[1], $usageArray[2]);
				if (!empty($usageArray[3]) && $usageArray[3] == 'STORAGE')
					list($storageUsed, $storageTotal) = array($usageArray[4], $usageArray[5]);
				if ($usageArray[0] == 'MESSAGE')
					list($messagesUsed, $messagesTotal) = array($usageArray[1], $usageArray[2]);
				if (!empty($usageArray[3]) && $usageArray[3] == 'MESSAGE')
					list($messagesUsed, $messagesTotal) = array($usageArray[4], $usageArray[5]);
				return array($storageUsed, $storageTotal, $messagesUsed, $messagesTotal);
			}
		}
	}

return array('NOQUOTA');

}


/**
  * Determines if IMAP server can report quota information or not
  *
  * @param resource $imap_stream An open stream to the IMAP server
  *                              (optional if $capability is not empty)
  * @param array $capability The IMAP server's capability strings,
  *                          which, if given, is used as is instead 
  *                          of connecting to the IMAP server and 
  *                          asking for its capabilities (optional)
  *
  * @return boolean TRUE if IMAP server has QUOTA capability, FALSE otherwise
  *
  */
function check_quota_capability($imap_stream, $capability='') 
{

   // get CAPABILITY from IMAP server if needed
   //
   if (empty($capability))
   {
      fputs ($imap_stream, "a001 CAPABILITY\r\n");
      $capability = sqimap_read_data($imap_stream, 'a001', true, $a, $b);

      if (check_sm_version(1, 5, 0))
         $capability = $capability['a001'];
   }


   // parse CAPABILITIES, looking for QUOTA
   //
   foreach ($capability as $response)
   {
      if (is_array($response))
         foreach ($response as $resp)
         {
            if (strpos($resp, 'QUOTA') !== FALSE)
               return TRUE;
         }
         else if (strpos($response, 'QUOTA') !== FALSE)
            return TRUE;
   }


   return false;

}

?>
