#!/usr/bin/perl

# Use the DBI module
use DBI qw(:sql_types);

# Global variables
$squirrelmail_datadir = "/<path to your user prefs files/>";

# Declare local variables

my ($databaseName, $databaseUser, $databasePw, $dbh);
my ($stmt, $sth, @newRow);

# Set the parameter values for the connection
$databaseName = "DBI:mysql:sm";
$databaseUser = "sm";
$databasePw = "yourpassword";

$dbh = DBI->connect($databaseName, $databaseUser, 
       $databasePw) || die "Connect failed: $DBI::errstr\n";

#######################################################################
# Round one, load up any user prefs files found

# Delete contents of existing talbe 'userprefs'
print "Deleting contents of sm:userprefs ..............";
$stmt = "DELETE from userprefs";
&execute_stmt;
print "done.\n";

# Load up user preferences
print "Loading user preferences into database .........";
open(PREFS, "find $squirrelmail_datadir -name \*.pref -print |") || die "couldn't find prefs files";

PREFS:
while ($filename = <PREFS>) {

	(@basename) = split(/\//, $filename);
			##	print "\n\nPrefs file is $basename[$#basename]";
	@user = split(/\./, $basename[$#basename]);
			##	print "Username is $user[0]\n";
	open(PREF, "$filename");

	while (<PREF>) {
		($prefkey, $prefval) = split(/\=/);
		chomp($prefval);
		$prefkey =~ s/'/\\'/;
		$prefval =~ s/'/\\'/;
			##	print "User $user[0] $prefkey $prefval";

                # Create the statement.
		$stmt = "INSERT INTO userprefs (user, prefkey, prefval) VALUES ('$user[0]', '$prefkey', '$prefval')";
			##	print "\n$stmt\n";
		# Execute statement
		&execute_stmt;
		}
	close(PREF);
}
close(PREFS);
print "done.\n";

#######################################################################
# Round two, load up any address book (.abook) files found

# Delete contents of existing table 'address'
print "Deleting contents of sm:address ................";
$stmt = "DELETE from address";
&execute_stmt;
print "done.\n";

# Load up address book files
print "Loading user address books into database .......";

open(ABOOKS, "find $squirrelmail_datadir -name \*.abook -print |") || die "couldn't find address files";

ABOOKS:
while ($filename = <ABOOKS>) {

        (@basename) = split(/\//, $filename);
                        ##      print "\n\nAddress book file is $basename[$#basename]";
        @user = split(/\./, $basename[$#basename]);
                        ##      print "Username is $user[0]\n";
        open(ABOOK, "$filename");

        while (<ABOOK>) {
                ($nickname, $firstname, $lastname, $email, $label) = split(/\|/);
                chomp($email);
		$nickname =~ s/'/\\'/;
		$firstname =~ s/'/\\'/;
		$lastname =~ s/'/\\'/;
		$email =~ s/'/\\'/;
		$label =~ s/'/\\'/;
                        ##      print "$nickname $firstname $lastname $email $label\n";

                # Create the statement.
                $stmt = "INSERT INTO address (owner, nickname, firstname, lastname, email, label) VALUES ('$user[0]', '$nickname', '$firstname', '$lastname', '$email', '$label')";
                        ##      print "\n$stmt\n";
                # Execute statement
                &execute_stmt;
                }
        close(ABOOK);
}
close(ABOOK);
print "done.\n";

# Clean up the record set
$sth->finish();
$dbh->disconnect();

sub execute_stmt {
# Prepare and execute the SQL query
                $sth = $dbh->prepare($stmt) || die "prepare: $stmt: $DBI::errstr";
                $sth->execute || die "execute: $stmt: $DBI::errstr";

}
