<?php
    /*
     *  Change Pass
     *
     */

    chdir ('..');

    require_once ('../src/validate.php');
    require_once ('../functions/page_header.php');
    require_once ('../functions/imap.php');
    require_once ('../src/load_prefs.php');
    require_once ('../src/global.php');
    global $PHP_SELF;

    if(isset($_POST['plugin_change_pass'])) {
        $plugin_change_pass = $_POST['plugin_change_pass'];
    }
    if (isset($plugin_change_pass)) {
        $vars = array('cp_oldpass', 'cp_newpass', 'cp_verify');
        foreach($vars as $v) {
            if(isset($_POST[$v])) {
                $$v = $_POST[$v];
            }
        }
        $messages = change_pass_check();
    }

    displayPageHeader($color, 'None');
?>
    <table width="100%" cellpadding=2 cellspacing=2 border=0>
        <tr><td bgcolor="<?php echo $color[0] ?>">
                <center><b><?php echo _("Change Password") ?></b></center>
        </td></tr>
        <tr><td>
<?php
    if (isset($messages) && count($messages)) {
        echo "<pre>";print_r($messages);echo "</pre>";
        foreach ($messages as $line) {
            echo htmlspecialchars($line) . "<br>\n";
        }
        echo "</td></tr>\n";
        echo "<tr><td>\n";
    }
?>
            <form method="post" action="<?php echo $PHP_SELF ?>">
            <table align="center">
<?php
    $values = array(_("Old Password")        => 'cp_oldpass',
                    _("New Password")        => 'cp_newpass',
                    _("Verify New Password") => 'cp_verify');
    foreach($values as $key=>$value) {
        echo "<tr>\n<th align=\"right\">$key:</th>\n";
        echo "<td>\n<input type=\"password\" name=\"$value\" size=20>\n</td>\n";
        echo "</tr>\n";
    }
?>
                <tr><td align="center" colspan=2>
                    <input type="submit" value="Submit" name="plugin_change_pass">
                </td></tr>
            </table>
            </form>
        </td></tr>
    </table>
</body></html>
<?php
function change_pass_closeport($pop_socket, &$messages, $debug) {
    if ($debug) {
        array_push($messages, "Closing Connection");
    }
    fputs($pop_socket, "quit\r\n");
    fclose($pop_socket);
}

function change_pass_readfb($pop_socket, &$result, &$messages, $debug) {
   $strResp = '';
   $result  = '';

   if (!feof($pop_socket)) {
      $strResp = fgets($pop_socket, 1024);
      $result  = trim(substr($strResp, 0, 3));  // 200, 500
      if ($result != '200' || $debug) {
          $messages[] = "--> $strResp";
      }
   }
}

function change_pass_check($debug = 0) {
    global $cp_oldpass, $cp_newpass, $cp_verify, $key, $onetimepad;
    global $plugin_change_pass, $_COOKIE, $_SESSION;

    if(isset($_COOKIE['key'])) {
        $key = $_COOKIE['key'];
    }
    if(isset($_SESSION['onetimepad'])) {
        $onetimepad = $_SESSION['onetimepad'];
    }
    $messages = array();
    $password = OneTimePadDecrypt($key, $onetimepad);

    if ($cp_oldpass == '') {
        $messages[] = _("You must type in your old password.");
    }
    if ($cp_newpass == '') {
        $messages[] = _("You must type in a new password.");
    }
    if ($cp_verify  == '') {
        $messages[] = _("You must also type in your new password in the verify box.");
    }
    if ($cp_newpass != '' && ($cp_verify != $cp_newpass)) {
        $messages[] = _("Your new password doesn't match the verify password.");
    }
    if ($cp_oldpass != '' && ($cp_oldpass != $password)) {
        $messages[] = _("Your old password is not correct.");
    }
    if (count($messages)) {
        return $messages;
    }
    return change_pass_go($password, $debug);
}

function change_pass_go($password, $debug) {
    global $username, $base_uri, $imapServerAddress;
    global $cp_newpass, $key, $onetimepad, $_SESSION;

    if(isset($_SESSION['base_uri'])) {
        $base_uri = $_SESSION['base_uri'];
    }
    $messages = array();

    if ($debug) {
        $messages[] = "Connecting to Password Server";
    }
    $pop_socket = fsockopen($imapServerAddress, 106, $errno, $errstr);
    if (!$pop_socket) {
        $messages[] = "ERROR: $errstr ($errno)";
        return $messages;
    }

    change_pass_readfb($pop_socket, $result, $messages, $debug);
    if ($result != '200') {
        change_pass_closeport($pop_socket, $messages, $debug);
        return $messages;
    }

    fputs($pop_socket, "user $username\r\n");
    change_pass_readfb($pop_socket, $result, $messages, $debug);
    if ($result != '200') {
        change_pass_closeport($pop_socket, $messages, $debug);
        return $messages;
    }

    fputs($pop_socket, "pass $password\r\n");
    change_pass_readfb($pop_socket, $result, $messages, $debug);
    if ($result != '200') {
        change_pass_closeport($pop_socket, $messages, $debug);
        return $messages;
    }

    fputs($pop_socket, "newpass $cp_newpass\r\n");
    change_pass_readfb($pop_socket, $result, $messages, $debug);
    change_pass_closeport($pop_socket, $messages, $debug);
    if ($result != '200')
        return $messages;

    if ($debug) {
        $messages[] = 'Password changed successfully.';
    }
    // Write new cookies for the password
    $onetimepad = OneTimePadCreate(strlen($cp_newpass));
    $key = OneTimePadEncrypt($cp_newpass, $onetimepad);
    sqsession_register($onetimepad, 'onetimepad');
    setcookie('key', $key, 0, $base_uri);

    // Automatically forward back to the options screen if correct
    if ($debug == 0) {
        header('Location: ' . $base_uri
               . 'src/options.php?plugin_change_pass=true');
        exit(0);
    }
    return $messages;
}
?>
