<?php
/**
 * Sample configuration file for Change LDAP Password plugin
 * @version $Id: config_sample.php,v 1.6 2007/07/21 06:56:42 tokul Exp $
 * @package sm-plugins
 * @subpackage change_ldappass
 */

/**
 * LDAP connection URI
 * You can use any address syntax supported by your LDAP library.
 * Connection can be secured with ldaps or ldapi URIs.
 * @param string $ldap_server
 */
$ldap_server = 'localhost';

/**
 * Controls LDAP bind protocol version.
 * PHP and plugin defaults to v2 bind. Some LDAP servers (OpenLDAP v.2.1+)
 * disable v2 bind by default.
 * @param integer $ldap_protocol_version
 * @since 1.9
 */
$ldap_protocol_version = 2;

/**
 * Sets field used to store user's password.
 * Defaults to 'userpassword'
 * Name is case insensitive. Plugin uses lowercase automatically.
 * @param string $ldap_password_field
 */
$ldap_password_field = 'userpassword';

/**
 * Sets field used to store username.
 * Defaults to 'uid'
 * Name is case insensitive. Plugin uses lowercase automatically.
 * @param string $ldap_user_field
 */
$ldap_user_field = 'uid';

/**
 * Put the ldap base dn of your server here
 * Option defaults to empty string. It must be set to correct BaseDN value.
 * @param string $ldap_basedn
 */
$ldap_base_dn = 'dc=example,dc=com';

/**
 * Additional LDAP filters.
 * Limits user's DN search to "(&($ldap_filter)($ldap_user_field=$username))".
 * Use it only when you have multiple entries with same $ldap_user_field value
 * in your LDAP directory. Since 2.2 plugin will detect filtering rules enclosed
 * in parenthesis '(objectClass=qmailUser)' and won't add second patenthesis.
 * @global string $ldap_filter
 * @since 2.1
 */
$ldap_filter = '';

// we first bind to retreive the users full DN for the account by looking up
// the attribute defined above in $ldap_user_field. The account used to do the
// initial lookup is defined in $query_dn and $query_pw.  If these vars are
// blank or unset we bind anonymously.

// NOTE: You only need to set values here if you have disabled anonymous queries.
$query_dn = '';
$query_pw = '';

/**
 * After getting the users DN, we will bind as that DN to verify the password.
 * Of course, if the dn is not permitted to bind, this fails.  To skip the password
 * check via ldap-bind, define $no_bind_as_user
 * @param boolean $no_bind_as_user
 */
$no_bind_as_user = false;

/**
 * We normally change the users password while bound with their dn.
 * Of course, if you have'nt permitted the user write access to the password
 * field, this won't work.  You can either fix the ACL in slapd.conf or the
 * equivelent in your LDAP server, or do the insecure thing and bind as the
 * manager.
 *
 * USE THIS IF YOU DON'T CARE ABOUT SECURITY.
 */
$ldap_bind_as_manager = false;
$ldap_manager_dn="cn=manager,$ldap_base_dn";
$ldap_manager_pw='secret';

// Configuration for Samba-LDAP passwords (changes via CLI)

/**
 * Controls syncronization of Samba passwords with smbpasswd utility
 *
 * Please note that use of this option makes password changing two stage
 * operation. It is prone to failures and password corruption. If your Samba
 * passwords are stored in LDAP, use of $change_ldapsmb is recommended.
 * Set it to true, if you want to sync SMB passwords with smbpasswd command.
 * @global boolean $change_smb
 */
$change_smb=false;

/**
 * Path to smbpasswd program. Defaults to '/usr/bin/smbpasswd'
 * @global string $smb_passwd
 */
$smb_passwd='/usr/bin/smbpasswd';

/**
 * NOTE: set this to the NETBIOS name of your samba host if it is NOT localhost
 * @global string $smb_host
 */
$smb_host='';

// Configuration for Samba-LDAP passwords (changes via LDAP)

/**
 * Controls changes of smb passwords in LDAP
 * @global boolean $change_ldapsmb
 */
$change_ldapsmb=false;

/**
 * Path to mkntpwd
 *
 * Plugin needs mkntpwd utility in order to generate the nt/lm passwords.
 * See http://viewcvs.samba.org/cgi-bin/viewcvs.cgi/branches/SAMBA_2_2/examples/LDAP/smbldap-tools/mkntpwd/
 * Copy of utility is included in plugins/change_ldappass/mkntpwd/ directory
 * @global string $mkntpwd
 */
$mkntpwd='/usr/bin/mkntpwd';

/**
 * LanManager password field name
 *
 * NOTE: Default value is only for samba-3.x.x (using the new samba.schema).
 * samba-2.2.x or samba-3.x.x in 2.2.x compat mode should use 'lmpassword'
 * Name is case insensitive. Plugin uses lowercase automatically.
 * @global string $ldapsmb_lmpassword
 */
$ldapsmb_lmpassword='sambalmpassword';

/**
 * NT password field name
 *
 * NOTE: Default value is only for samba-3.x.x (using the new samba.schema).
 * samba-2.2.x or samba-3.x.x in 2.2.x compat mode should use 'ntpassword'
 * Name is case insensitive. Plugin uses lowercase automatically.
 * @global string $ldapsmb_ntpassword
 */
$ldapsmb_ntpassword='sambantpassword';

/**
 * Samba Object Class name
 *
 * NOTE: Default value is only for samba-3.x.x (using the new samba.schema).
 * samba 2.2.x or samba 3.x.x in 2.2.x compat mode should use 'sambaaccount'
 * Name is case insensitive. Plugin uses lowercase automatically.
 * @global string $ldapsmb_object
 * @since 2.2
 */
$ldapsmb_object = 'sambasamaccount';

// Crack support

/**
 * Controls password checks with PHP Crack extension
 * Defaults to empty string. Checks are enabled only when string is not empty.
 * Use $lcp_crack_dict = get_cfg_var('crack.default_dictionary');
 * if you want to use default dictionary configured in PHP Crack extension.
 * @global string $ldp_crack_dict
 * @since 2.2
 */
$lcp_crack_dict = '';

/**
 * Controls display of "Sync with local network password" checkbox.
 * Default checkbox value is stored in user preferences 'sync_smb_pass' setting.
 * @global boolean $force_smb_sync
 * @since 2.2
 */
$force_smb_sync = true;

/**
 * Controls display of debug information
 * @param boolean $debug
 */
$debug = false;
