<?php
/**
 * Change LDAP Password plugin - Configuration loader
 * @copyright (c) 2007 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: load_config.php,v 1.2 2007/07/19 10:51:27 tokul Exp $
 * @package sm-plugins
 * @subpackage change_ldappass
 */

/** Declare configuration globals */
global $ldap_server, $ldap_protocol_version, $ldap_password_field, 
    $ldap_user_field, $ldap_base_dn, $ldap_filter, $query_dn, $query_pw, 
    $no_bind_as_user, $ldap_bind_as_manager, $ldap_manager_dn, 
    $ldap_manager_pw, $change_smb, $smb_passwd, $smb_host, $change_ldapsmb,
    $mkntpwd, $ldapsmb_lmpassword, $ldapsmb_ntpassword, $lcp_crack_dict, 
    $debug;

/** Set defaults */
$ldap_server = 'localhost';
$ldap_protocol_version = 2;
$ldap_password_field = 'userpassword';
$ldap_user_field = 'uid';
$ldap_base_dn = '';
$ldap_filter = '';
$query_dn = '';
$query_pw = '';
$no_bind_as_user = false;
$ldap_bind_as_manager = false;
$ldap_manager_dn='';
$ldap_manager_pw='';
$change_smb=false;
$smb_passwd='/usr/bin/smbpasswd';
$smb_host='';
$change_ldapsmb=false;
$mkntpwd='/usr/bin/mkntpwd';
$ldapsmb_lmpassword='sambalmpassword';
$ldapsmb_ntpassword='sambantpassword';
$ldapsmb_object = 'sambasamaccount';
$lcp_crack_dict = '';
$force_smb_sync = true;
$debug = false;

/** Load site configuration */
if (file_exists(SM_PATH . 'plugins/change_ldappass/config.php')) {
    include_once(SM_PATH . 'plugins/change_ldappass/config.php');
}

/** Make sure that LDAP attribute and object names are lowercased */
$ldap_password_field = strtolower($ldap_password_field);
$ldap_user_field = strtolower($ldap_user_field);
$ldapsmb_lmpassword = strtolower($ldapsmb_lmpassword);
$ldapsmb_ntpassword = strtolower($ldapsmb_ntpassword);
$ldapsmb_object = strtolower($ldapsmb_object);
