<?php
/**
 * Change_ldappass options
 *
 * V.1.6 copyright notice
 * ----------------------
 * Copyright Simon Annetts 2000 - 2003. simon@ateb.co.uk 
 *
 * This software may be used, modified and distributed freely
 * providing this copyright notice remains intact at the head 
 * of the file.
 *
 * This software is freeware. The author accepts no liability for
 * any loss or damages whatsoever incurred directly or indirectly 
 * from the use of this script. The author of this software makes 
 * no claims as to its fitness for any purpose whatsoever. If you 
 * wish to use this software you should first satisfy yourself that 
 * it meets your requirements.
 * ----------------------
 * change_ldappass v.2.0 version is relicensed under GPL.
 *
 * @copyright &copy; 2000-2003 Simon Annetts <simon@ateb.co.uk>
 * @copyright &copy; 2006-2007 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: options.php,v 1.10 2007/01/20 11:51:22 tokul Exp $
 * @package plugins
 * @subpackage change_ldappass
 */

/** @ignore */
define('SM_PATH','../../');

/**/
include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'plugins/change_ldappass/functions.php');

unset($Messages);
if ( file_exists(SM_PATH . 'plugins/change_ldappass/config.php') &&
     sqGetGlobalVar('plugin_change_ldappass',$plugin_change_ldappass,SQ_POST)) {
    bindtextdomain('change_ldappass', SM_PATH . 'plugins/change_ldappass/locale');
    textdomain('change_ldappass');
    $Messages = change_ldappass_check();
    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
}

displayPageHeader($color, '');

bindtextdomain('change_ldappass', SM_PATH . 'plugins/change_ldappass/locale');
textdomain('change_ldappass');

// Make sure that ldap extension is available
if (! extension_loaded('ldap')) {
    include_once(SM_PATH . 'functions/display_messages.php');
    $error = _("PHP LDAP extension is not available.");
    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
    error_box($error,$color);
    die('</body></html>');
}

// Make sure that config file is present
if (! file_exists(SM_PATH . 'plugins/change_ldappass/config.php')) {
    include_once(SM_PATH . 'functions/display_messages.php');
    $error = _("Please create plugin configuration file.");
    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
    error_box($error,$color);
    die('</body></html>');
}

echo '<br>'
    .'<table width="95%" align="center" cellpadding="2" cellspacing="2" border="0">'
    .'<tr><td bgcolor="' . $color[0] . '">'
    .'<center><b>' . _("Change Password") . '</b></center>'
    .'</td></tr>';

if (isset($Messages) && count($Messages)) {
    echo "<tr><td>\n";
    foreach ($Messages as $line) {
        echo $line . "<br>\n";
    }
    echo "</td></tr>\n";
}
?>
  <tr><td align="center">
    <form method="post" action="options.php">
    <table>
      <tr>
        <th align="right"><?php echo _("Old Password:"); ?></th>
        <td><input type="password" name="cp_oldpass" value="" size="20"></td>
      </tr>
      <tr>
        <th align="right"><?php echo _("New Password:"); ?></th>
        <td><input type="password" name="cp_newpass" value="" size="20"></td>
      </tr>
      <tr>
        <th align="right"><?php echo _("Verify New Password:"); ?></th>
        <td><input type="password" name="cp_verify" value="" size="20"></td>
      </tr>
      <tr>
        <td align="center" colspan="2">
        <input type="submit" value="<?php echo _("Change Password"); ?>" name="plugin_change_ldappass">
        </td>
      </tr>
    </table>
    </form>
  </td></tr>
  </table>
</body></html>
